(* Ulm's Oberon Compiler
   Copyright (c) 1989 by University of Ulm, SAI, D-W-7900 Ulm, Germany
   ----------------------------------------------------------------------------
   $Id: Suffixes.m2,v 0.1 1992/07/30 10:49:33 borchert Exp $
   ----------------------------------------------------------------------------
   $Log: Suffixes.m2,v $
   Revision 0.1  1992/07/30  10:49:33  borchert
   Initial revision

   ----------------------------------------------------------------------------
*)

IMPLEMENTATION MODULE Suffixes;		(* Martin Hasch, Jan 1989 *)

   FROM Strings IMPORT StrLen;
   FROM Exception IMPORT Assert;

(***** EXPORTED:
   CONST
      ...SX = ...;
*****)

   PROCEDURE TestSuffix(filename,suffix: ARRAY OF CHAR): BOOLEAN;(* EXPORTED *)
      VAR
	 sxindex: CARDINAL;
	 fnlen,
	 sxlen: CARDINAL;
   BEGIN
      fnlen := StrLen(filename);
      sxlen := StrLen(suffix);
      IF sxlen > fnlen THEN
	 RETURN FALSE
      END;
      FOR sxindex := 0 TO sxlen-1 DO
	 IF filename[fnlen-sxlen+sxindex] # suffix[sxindex] THEN
	    RETURN FALSE
	 END;
      END;
      RETURN TRUE
   END TestSuffix;

   PROCEDURE MakeName(  VAR filename: ARRAY OF CHAR;
	       (*read*) VAR sourcename: ARRAY OF CHAR;
			oldsuffix, newsuffix: ARRAY OF CHAR);	(* EXPORTED *)
      VAR
	 index: CARDINAL;
	 fnlen,
	 baselen: CARDINAL;
   BEGIN
      baselen := StrLen(sourcename) - StrLen(oldsuffix);
      fnlen := baselen + StrLen(newsuffix);
      Assert( fnlen-1 <= HIGH(filename) );
      FOR index := 0 TO baselen-1 DO
	 filename[index] := sourcename[index];
      END;
      FOR index := baselen TO fnlen-1 DO
	 filename[index] := newsuffix[index-baselen];
      END;
      IF fnlen <= HIGH(filename) THEN
	 filename[fnlen] := 0C;
      END;
   END MakeName;

END Suffixes.
