(* Ulm's Oberon Compiler
   Copyright (c) 1989 by University of Ulm, SAI, D-W-7900 Ulm, Germany
   ----------------------------------------------------------------------------
   $Id: SymFile.d,v 0.1 1992/07/30 10:47:40 borchert Exp $
   ----------------------------------------------------------------------------
   $Log: SymFile.d,v $
   Revision 0.1  1992/07/30  10:47:40  borchert
   Initial revision

   ----------------------------------------------------------------------------
*)

DEFINITION MODULE SymFile; (* AFB 1/89 *)

   (* interface to symbol files *)

   FROM IdentSys IMPORT Identifier;
   FROM SymTab IMPORT Type, Ident, IdentList;

   PROCEDURE InitType((* out *) VAR t: Type);
      (* all types must be linked into a chain for symbol file generation *)

   PROCEDURE LinkType((* in *) t: Type);
      (* link used but possible not (via InitType) initialized type *)
      (* into the chain *)

   PROCEDURE GenSymFile(modip: Ident);
      (* generate symbol file; file names are taken from `ScanArgs' *)

   PROCEDURE ReadSymFile(modid: Identifier; VAR modip: Ident;
			 ourmodule: BOOLEAN);
      (* read symbol file; *)
      (* `modip' serves as reference to the export list and *)
      (* the module key but is not entered into the symbol *)
      (* table *)
      (* `ourmodule' (only if ~defunit): indicates if the *)
      (* corresponding definition is to be read; this information *)
      (* is necessary to remember the filename for symbol file updates *)

   PROCEDURE UpdateSymFile(t: Type);
      (* update size information of type `t' in symbolfile; *)
      (* defunit must be FALSE; an error message is printed if *)
      (* updates are prohibited or the symbolfile is member of an archive *)

END SymFile.
