(* Ulm's Oberon Compiler
   Copyright (c) 1989 by University of Ulm, SAI, D-W-7900 Ulm, Germany
   ----------------------------------------------------------------------------
   $Id: SymRef.d,v 0.1 1992/07/30 10:47:44 borchert Stab $
   ----------------------------------------------------------------------------
   $Log: SymRef.d,v $
   Revision 0.1  1992/07/30  10:47:44  borchert
   Initial revision

   ----------------------------------------------------------------------------
*)

DEFINITION MODULE SymRef; (* AFB 7/90 *)

   (* generation of reference files *)

   FROM Scan IMPORT Pos;
   FROM ScanArgs IMPORT FileName;
   FROM SymTab IMPORT Ident;

   PROCEDURE OpenRef(filename: FileName);
      (* open reference file for writing and
	 enable reference file generation
	 (else all other procedures are noops)
      *)

   PROCEDURE CloseRef;
      (* close reference file *)

   PROCEDURE RefImport(ident: Ident);
      (* write reference record for import *)

   PROCEDURE RefIdent(ident: Ident; pos: Pos);
      (* write reference record for modules, types, variables and procedures;
	 pos should point to the identifier
      *)

   PROCEDURE RefOpenBlock;
      (* blocks are to be opened after RefIdent of modules or procedures *)

   PROCEDURE RefCloseBlock;
      (* to be called at end of procedure/module *)

END SymRef.
