(* Ulm's Oberon Compiler
   Copyright (c) 1989 by University of Ulm, SAI, D-W-7900 Ulm, Germany
   ----------------------------------------------------------------------------
   $Id: SymTab.d,v 0.7 1994/05/25 11:50:23 borchert Exp $
   ----------------------------------------------------------------------------
   $Log: SymTab.d,v $
   Revision 0.7  1994/05/25  11:50:23  borchert
   seekpos added to ParamListRec -- this was necessary because
   varkind may be updated by SymDef

   Revision 0.6  1993/09/27  12:50:34  borchert
   treatAsAddress component added to TypeRec

   Revision 0.5  1993/06/25  12:32:59  borchert
   taggedptr added to TypeRec (form = pointer)
   this was necessary to support the new compiler option $O

   Revision 0.4  1993/06/18  15:31:28  borchert
   type definition of Size moved to Types

   Revision 0.3  1993/06/16  09:43:31  borchert
   int16 added to Form for SYSTEM.INT16

   Revision 0.2  1992/10/22  14:44:20  borchert
   seekpos component added to FieldListRec

   Revision 0.1  1992/07/30  10:47:47  borchert
   Initial revision

   ----------------------------------------------------------------------------
*)

DEFINITION MODULE SymTab; (* AFB 1/89 *)

   (* management of the symbol table *)

   FROM Calendar IMPORT Time;
   FROM Lex IMPORT Constval;
   FROM IdentSys IMPORT Identifier;
   FROM SystemTypes IMPORT ProcessId, OFF;
   IMPORT Types;

   CONST
      standard = 0;		(* level of standard names *)
      import = 1;		(* import level *)
      global = 2;		(* global level *)

   TYPE
      Form = (
	 shortint, int16, integer, longint, real, longreal, (* numeric types *)
	 boolean, char, set, byte,			(* non-numeric types *)
	 array, record, pointer, proceduretype);	(* structured types *)
      FormSet = SET OF Form;
   CONST
      Numeric = FormSet{shortint..longreal};
      Basic = FormSet{shortint..byte};
      Structured = FormSet{array..proceduretype};
      address = longint;
	 (* mark that numeric type which is suited for addresses *)

   TYPE
      HiddenPart;		(* of Ident *)
      StdProc = (absF, oddF, capF, ashF, lenF, maxF, minF,
		 ordF, chrF, shortF, longF, entierF,
		 incP, decP, inclP, exclP, copyP, newP, haltP,
		 (* builtin module SYSTEM *)
		 adrF, bitF, lshF, rotF, sizeF, valF,
		 getP, putP, moveP, sysnewP,
		 (* coroutines *)
		 crspawnP, crswitchP,
		 (* local additions to SYSTEM *)
		 unixcallF, unixforkF, unixsignalF, tasF,
		 syshaltP, wmoveP, wclearP);
      Size = Types.Size; (* type for size and offsets in bytes *)
      Ident = POINTER TO IdentRec;
      Type = POINTER TO TypeRec;
      FieldList = POINTER TO FieldListRec;
      FieldListRec =
	 RECORD
	    id: Identifier;
	    CASE : BOOLEAN OF
	    | TRUE:  typeno: CARDINAL;
	    | FALSE: type: Type;
	    END;
	    offset: Size;
	    link: FieldList;
	    seekpos: OFF; (* used by `SymFile' *)
	 END;
      VarKind = (paramV, varparamV, copyparamV, noparamV);
	 (* paramV:	call by value; value is copied by calling procedure
	    varparmV:	call by reference; address is pushed on stack
	    copyparamV:	call by value; address is pushed on stack
	    noparamV:	no parameter
	 *)
      ParamList = POINTER TO ParamListRec;
      ParamListRec =
	 RECORD
	    id: Identifier;	(* for error messages only *)
	    CASE : BOOLEAN OF
	    | TRUE:  typeno: CARDINAL;
	    | FALSE: type: Type;
	    END;
	    varkind: VarKind;	(* anything but noparamV *)
	    offset: Size;	(* 1st parameter has offset 0 *)
	    link: ParamList;
	    seekpos: OFF;       (* used by `SymFile' *)
	 END;
      TypeRec =
	 RECORD
	    CASE : BOOLEAN OF
	    | TRUE:  identno: CARDINAL;	(* for SymFile *)
	    | FALSE: ident: Ident;	(* defining identifier *)
	    END;
	    refcnt: CARDINAL; (* reference count -- used if ident = NIL *)
	    typeno: CARDINAL; (* used by `SymFile' *)
	    rtypeno: CARDINAL;(* used by `SymRef' *)
	    tagno: CARDINAL;  (* used by `GenTypes' *)
	    containsptr: BOOLEAN; (* type containing pointers? *)
	    size: Size;	      (* in bytes *)
	    link: Type;       (* chain of types -- used by `SymFile' *)
	    seekpos: OFF;     (* seek position in symbol file; ident # NIL *)
	    privateparts: BOOLEAN; (* any private parts we don't know about? *)
	    sizemodified: BOOLEAN; (* size modified by SymFile.Update *)
	    CASE form: Form OF
	    | address:   treatAsAddress: BOOLEAN;
	    | array:     CASE dyn: BOOLEAN OF
			 | FALSE: length: Size;
			 END;
			 CASE : BOOLEAN OF
			 | TRUE:  elementtypeno: CARDINAL;
			 | FALSE: element: Type;
			 END;
	    | record:    CASE : BOOLEAN OF
			 | TRUE:  basetypeno: CARDINAL;
			 | FALSE: basetype: Type;    (* may be NIL *)
			 END;
			 fields: FieldList; (* list of known fields *)
			 CASE projection: BOOLEAN OF (* hidden parts possible *)
			 | TRUE: extmod: Ident;   (* quick reference *)
				 extended: BOOLEAN;
			 ELSE
			 END;
	    | pointer:   CASE : BOOLEAN OF
			 | TRUE:  reftypeno: CARDINAL;
			 | FALSE: reftype: Type;    (* may be NIL: forward! *)
			 END;
			 taggedptr: BOOLEAN; (* IS and WITH legal? *)
	    | proceduretype:
			 function: BOOLEAN;
			 CASE std: BOOLEAN OF
			 | TRUE:  stdproc: StdProc;
			 | FALSE: param: ParamList;
				  CASE (* function *) : BOOLEAN OF
				  | TRUE: CASE : BOOLEAN OF
					  | TRUE:  restypeno: CARDINAL;
					  | FALSE: restype: Type;
					  END;
				  END;
			 END;
	    END;
	 END;

   TYPE
      IdentList = POINTER TO IdentListRec;
      IdentListRec =
	 RECORD
	    ident: Ident;
	    link: IdentList;
	 END;
      IdentClass = (moduleC, constC, typeC, varC, procedureC, badclass);
      Key = RECORD time: Time; pid: ProcessId; END; (* set by SymFile *)
      IdentRec =
	 RECORD
	    hidden: HiddenPart;
	    name: Identifier;
	    identno: CARDINAL;		(* used by `SymFile'; >0 if set *)
	    error: BOOLEAN;
	    CASE class: IdentClass OF
	    | badclass:
	    | moduleC:  export: IdentList;
			key: Key;
			origname: Identifier;	(* original name *)
			modid: CARDINAL;	(* used by `SymFile' *)
	    ELSE
	       CASE (* symbolfile *) : BOOLEAN OF
	       | TRUE:  typeno: CARDINAL;
	       | FALSE: type: Type;
	       END;
	       CASE : BOOLEAN OF
	       | TRUE:  modno: CARDINAL;	(* used by `SymFile' *)
	       | FALSE: mod: Ident;		(* defining module *)
	       END;
	       exported: BOOLEAN;
	       CASE (* class *) : IdentClass OF
	       | constC:            constval: Constval;
	       | typeC:
	       | varC, procedureC:  plevel: CARDINAL; (* procedure nest level *)
				    CASE : IdentClass OF
				    | varC:        offset: Size;
						   indirect: BOOLEAN;
						   CASE varkind: VarKind OF
						   | copyparamV:  ptroffset:
								     Size;
						   END;
				    | procedureC:  local: IdentList; (* vars *)
						   params: IdentList;
						   parmoffset: Size;
						   varoffset: Size;
						   forward: BOOLEAN;
						   procno: CARDINAL;
				    END;
	       END;
	    END;
	 END;

   VAR
      extmods: IdentList;	(* managed by `GenSymFile.ExtMod' and used by *)
				(* `GenSymFile' *)
				(* includes "our" module *)
      mainmod: Ident;           (* "our" module; initialized by `SymDef' *)
      globalvars: IdentList;	(* list of global variables; *)
				(* managed by SymDef *)


   PROCEDURE OpenScope;
      (* the first call opens the module scope *)
      (* the second call opens the module; *)
      (* all further calls are for procedures only *)
      (* module: to be called AFTER the imports *)
      (* procedures: to be called AFTER DeclProc *)

   PROCEDURE CloseScope;
      (* to be called at END (ProcedureName|ModuleName) *)

   PROCEDURE Enter(sname: Identifier; idclass: IdentClass;
		   VAR ident: Ident) : BOOLEAN;
      (* enter `name' into the current scope; *)
      (* allocate `ident'; *)
      (* initialize hidden part of `ident'; *)
      (* initialize class, name, and plevel of `ident' *)
      (* print error messages on multiple occurences *)
      (* return TRUE if successful *)

   PROCEDURE Include(ident: Ident);
      (* enter `ident' (already initialized) into current scope; *)
      (* aborts if not successful *)

   PROCEDURE Find(level: CARDINAL;
		  name: Identifier; VAR ident: Ident) : BOOLEAN;
      (* starting from level `level' *)
      (* search for `name' starting in the current scope *)
      (* return TRUE if `name' has been found *)

   PROCEDURE Search(name: Identifier; VAR ident: Ident) : BOOLEAN;
      (* search for `name' starting in the current scope *)
      (* mark `name' as used in this level *)
      (* return TRUE if `name' has been found *)

   PROCEDURE SearchAndEnter(name: Identifier; VAR ident: Ident);
      (* print error message if `name' is unknown; *)
      (* to avoid multiple error messages enter unknown names *)

   PROCEDURE SearchList(id: Identifier; idlist: IdentList;
			VAR ip: Ident) : BOOLEAN;
      (* search for `id' in `idlist' *)

   PROCEDURE SearchFieldList(id: Identifier; fields: FieldList;
			     VAR fp: FieldList) : BOOLEAN;
      (* search for `id' in `fields' *)

   PROCEDURE SearchParamList(id: Identifier; params: ParamList;
			     VAR pp: ParamList) : BOOLEAN;
      (* search of `id' in `params' *)

   PROCEDURE Level() : CARDINAL;
      (* returns the current level *)

   PROCEDURE Used(ip: Ident) : BOOLEAN;
      (* return TRUE if `ip' has been used (i.e. Search called) *)

   PROCEDURE Touch(ip: Ident; level: CARDINAL);
      (* mark `ip' as used *)

END SymTab.
