/*
 *	mdb - reffile parsing
 */

#include	<stdio.h>
#include	<setjmp.h>
#include	"mdb_ref.h"
#include	"mdb_bp.h"
#include	"mdb_tree.h"
#include	"odb_vartab.h"

extern char * archivesearch();
extern char * get_first();
extern char * get_next();
extern char * searchfile();
extern char * calloc();

static void new();

extern int version;
extern int fflag;

tree *parse();
tree *module();
tree *block();
tree *procedure();
tree *variable();

static symbol sym;
static jmp_buf fail;
static tree *last;
static int plevel; /* procedure nest level */
static int level;  /* nest level */
static char * errmsg;
static char * modname;

#define TTLEN 1024	/* length of type table */
static struct type * tt[TTLEN];

static init_tt()
{	int i;
	
	for (i = 0; i < TTLEN; ++ i)
		tt[i] = NULL;
}

static fixtyperefs(t)
	tree * t;
{
	while (t)
	{	if (t->t_type == T_VAR && t->t_typeno < TTLEN &&
				tt[t->t_typeno])
		{	t->t_vartype = tt[t->t_typeno];
			t->t_size = t->t_vartype->size;
		}
		t = t->t_link;
	}
}

tree *build(modname)
	char *modname;
{	char filename[BUFSIZ];
	char *file;
	tree *result;
	char * archive;

	if ((file = searchfile(modname, "r")) == NULL)
	{	archive = get_first();
		do
		{	if (file = archivesearch(archive, modname, "r"))
				break;
		}
		while (archive = get_next());
	}
	if (! file)
	{	message("%s: no reference file found", modname);
		if (fflag)
			return NULL;
		getfilename(filename, BUFSIZ);
		if (! filename[0]) return NULL;
		if ((file = archivesearch(filename, modname, "r")) == NULL)
			file = filename;
		else
			enter(filename);
	}
	if (refopen(file))
	{	my_perror(file);
		return NULL;
	}
	if (setjmp(fail))
	{	message("%s: syntax error in reference file", modname);
		if (errmsg)
			message("%s: %s", modname, errmsg);
		refclose();
		return NULL;
	}
	result = parse();
	result->t_father = NULL;
	result->t_left = NULL;
	result->t_right = NULL;
	refclose();
	return result;
}

tree *parse()
{	tree *result;

	init_tt();
	last = NULL;
	plevel = 0;
	level = 0;
	result = module();
	result->t_father = NULL;
	fixtyperefs(result);
	return result;
}

void link(t)
	tree * t;
{
	if (last) last->t_link = t;
	t->t_link = NULL;
	last = t;
}

tree *module()
{	tree *mod;
	word magic;
	char namebuf[NAMSIZ];

	if ((magic = getnum()) != OR_MAGIC)
		error("magic number not found");
	new(&mod, sizeof(tree));
	mod->t_type = T_MOD;
	mod->t_plevel = plevel;
	if (level == 0)
		link(mod);		/* global modules first */
	mod->t_line = 1;
	getident(mod->t_name, NAMSIZ);
	modname = mod->t_name;
	mod->t_pnum = 0;
	mod->t_parlength = 0;

	/* skip key and imports */
	getnum(); getnum(); /* key */
	while ((sym = getsym()) == OR_IMPORT)
	{	getident(namebuf, NAMSIZ);
		getnum(); getnum(); /* key */
	}

	mod->t_son = block();

	if (level > 0)		/* local modules later */
		link(mod);

	markfather(mod->t_son, mod);
	mod->t_left = mod->t_right = NULL;
	if (sym != OR_END)
		error("module: END missing");
	sym = getsym();
	mod->t_left = mod->t_right = NULL;
	return mod;
}

head(line, ident, size, nr)
	word *line;
	char ident[];
	int size;
	word *nr;
{
	getident(ident, size);	/* Name */
	*line = getnum();		/* LineNum */
	if (nr)
		*nr = getnum();
}

extern char * strsave();

void read_type()
{	struct type * type;
	int typeno;
	char namebuf[NAMSIZ];

	new(& type, sizeof(struct type));
	typeno = getnum();
	getident(namebuf, NAMSIZ);
	if (namebuf[0])
		type->name = strsave(namebuf);
	else
		type->name = NULL;
	type->size = getnum();
	type->form = getsym();
	switch (type->form)
	{	case OR_POINTER: getnum(); sym = getsym(); break;
		case OR_ARRAY:   getnum(); getnum(); sym = getsym(); break;
		case OR_RECORD:  getnum();
				 while ((sym = getsym()) == OR_FIELD)
				 {	getident(namebuf, NAMSIZ);
					getnum(); getnum();
				 }
				 if (sym != OR_END)
					error("record-type: END missing");
				 sym = getsym();
				 break;
		default:	 sym = getsym(); break;
	}
	tt[typeno] = type;
}

tree *block()
{	tree *bl;
	tree *brother;

	++ level;
	bl = NULL;
	while ( sym == OR_TYPE || sym == OR_PROC || sym == OR_VAR ) {
		switch ( sym ) {
		case OR_PROC :	brother = procedure(); break;
		case OR_VAR :	brother = variable(); break;
		case OR_TYPE :  brother = NULL; read_type(); break;
		}
		if (brother) {
			brother->t_left = bl;
			if (bl)
				bl->t_right = brother;
			brother->t_right = NULL;
			bl = brother;
		}
	}
	-- level;
	return bl;
}

tree *procedure()
{	tree *proc;

	++plevel;
	if ( sym != OR_PROC )
		error("procedure: PROC missing");
	new(&proc, sizeof(tree));
	proc->t_type = T_PROC;
	proc->t_plevel = plevel;
	proc->t_bp[0] = proc->t_bp[1] = proc->t_bp[2] = NULL;
	head(&proc->t_line, proc->t_name, NAMSIZ, &proc->t_pnum);
	proc->t_parlength = getnum();
	sym = getsym();
	proc->t_son = block();

	link(proc);

	markfather(proc->t_son, proc);
	if (sym != OR_END)
		error("procedure: END missing");
	proc->t_right = NULL;
	proc->t_left = NULL;
	sym = getsym();
	--plevel;
	return proc;
}

tree *variable()
{	tree *var;

	if ( sym != OR_VAR )
		error("variable: VAR missing");
	new(&var, sizeof(tree));

	link(var);

	var->t_type = T_VAR;
	var->t_plevel = plevel;
	getident(var->t_name, NAMSIZ);	/* Name */
	var->t_line = getnum();		/* LineNumber */
	var->t_address = getnum();	/* Address */
	if (var->t_address == 0)
	{	var->t_address = addr_of_variable(modname, var->t_name);
		if (var->t_address == 0)
			message("cannot find address of %s.%s", modname,
				var->t_name);
	}
	var->t_addrmode = readref();	/* AddrMode */
	var->t_typeno = getnum();	/* VarType */
	var->t_vartype = NULL;
	switch(var->t_addrmode)
	{	case OR_INDIR:	var->t_addrmode = Ind; break;
		case OR_DIR:	var->t_addrmode = Rel; break;
	}
	var->t_size = 0;		/* Size */
	sym = getsym();
	var->t_son = var->t_left = var->t_right = NULL;
	return var;
}

/*
 *	allocate space and check
 */

static void new(ptr, size)
	char **ptr;
	int size;
{
	if ( (*ptr = calloc(1, size)) == NULL ) {
		message("no space available");
		error("no space available");
		}
}

error(msg)
	char * msg;
{
	errmsg = msg;
	longjmp(fail);
}

markfather(son, father)
	tree *son, *father;
{
	if ( !son ) return;
	while ( son->t_left )
		son = son->t_left;
	son->t_father = father;
	while ( son->t_right ) {
		son = son->t_right;
		son->t_father = father;
		}
}
