/*
 * maintain table of variables
 *
 * entered are tripels (module, varname, address)
 * which are looked for by (module, varname)
 */

#include "mdb.h"
#include "mdb_ref.h"
#include "mdb_tree.h"

extern char * calloc();
extern char * strsave();

struct entry {
   char * module;
   char * varname;
   address addr;
   struct entry * next;
};

#define HTABLEN 1009

static struct entry * bucket[HTABLEN];

static void new(ptr, size)
   char ** ptr; int size;
{
   if ((*ptr = calloc(1, size)) == NULL) {
      message("no space available"); die(1);
   }
}

static int hash(module, varname)
   char * module, * varname;
{  int val; char * cp;
   for (val = 0, cp = module; * cp && cp - module < NAMSIZ; ++ cp)
      val = (val<<3) + * cp;
   for (val = 0, cp = varname; * cp && cp - varname < NAMSIZ; ++ cp)
      val = (val<<3) + * cp;
   if (val < 0) { ++ val; val = - val; }
   val %= HTABLEN;
   return val;
}

void enter_variable(module, varname, addr)
   char * module, * varname; address addr;
{  struct entry * entry; int hashval;
   new(& entry, sizeof(struct entry));
   entry->module = strsave(module);
   entry->varname = strsave(varname);
   entry->addr = addr;
   hashval = hash(module, varname);
   entry->next = bucket[hashval];
   bucket[hashval] = entry;
}

address addr_of_variable(module, varname)
   char * module, * varname;
{  struct entry * p = bucket[hash(module, varname)];
   while (p)
   {  if (strncmp(module, p->module, NAMSIZ) == 0 &&
	  strncmp(varname, p->varname, NAMSIZ) == 0)
	 return p->addr;
      p = p->next;
   }
   return 0;
}
