#!/bin/sh

# lt   (log tail)
# Tail ACSnet link logs.
#
# Usage:
#	lt [lines] [machine]
#
# 'lines' (basically a tail(1) option) may also be:
#	-r	to print the log in reverse line order rom last line to first.
#	-f	to watch the logf continuously (or NNf).
#
# Set the environment variable 'acshost' to the link you are normally
# interested in.  The default is taken from 'link' below if you don't
# set acshost.
#
# The -r option will use either 'tail -r' or 'tac' (cat backwards).
# You can change which is used by altering the setting of the 'reverser'
# variable below.  If you don't have either, comment out both lines.
#
# eg:	lt 20
#	lt hpausla
#	lt -r
#	lt hpausla 5f &
# $Header: lt,v 1.1 86/11/26 20:17:17 brian Exp $ ASO

# ------ Customizable variables ---------------------------------------
# Default link to use if acshost environment variable not set
link=mulga
# Backwards cat/tail program.  tac is better, no line limit.
reverser=tac
#reverser='tail -r'
# PATH for local binaries
PATH=/usr/local/bin:/usr/contrib/bin:$PATH
# Spool directory for ACSnet
acshome=/usr/spool/ACSnet
# ------ End of customizable variables. --------------------------------

defopt=-15	# This is usually enough to see one complete log message.
opt=$defopt
mylink=${acshost-$link}
tail=tail

for arg
do
	case x$arg in
	x-[0-9]*)	opt=$arg ;;
	x[0-9]*)	opt=-$arg ;;
	x-r|xr)		tail="${reverser-tail}"; rev=yes ;;
	x-f|xf)		opt=${opt}f ;;
	x*)		mylink=$arg ;;
	esac
done

if [ ! -d $acshome/$mylink ]
then
	echo "$0: no such link as $mylink" 1>&2
	exit 1
fi

if [ "$rev" = yes ]
then
	if [ "$opt" != "$defopt" ]
	then
		echo "Warning: no options allowed with -r!"
		opt=
	fi
	opt=
fi

echo $tail $opt /usr/spool/ACSnet/$mylink/log
exec $tail $opt /usr/spool/ACSnet/$mylink/log
