.\" tbl proto.ms | troff -ms
.\" .nr PS 12
.\" .ps 12
.\" .nr VS 1.5v
.\" .vs 1.5v
.ND
.TL
.ps +2
A Reliable Virtual Circuit Protocol Package
.AU
.ps +2
Piers Dick-Lauder
.AI
Department of Computer Science
University of Sydney
.AB
.nh
This package has been developed as a simple implementation
of a reliable virtual circuit protocol,
suitable for use over low bandwidth communications links.
The protocol provides up to four full-duplex virtual circuits per link.
The protocol uses variable sized packets with \s-1CRC\s0 error detection,
and implements error correction by packet re-transmission.
Variable window sizes are allowed,
and an out-of-band channel for control information
is provided for each virtual circuit.
.AE
.nh
.NH 1
INTRODUCTION
.LP
There are many situations
where physical links between computers are easily installed,
but where the reliability of the link is less than sufficient.
Examples are provided by \s-1RS\s0-232 twisted pair connections,
or by modems using the public telephone network.
In such instances,
where data integrity is not provided by the link level hardware,
it is useful to be able to install a protocol that will transform
an unreliable circuit into a reliable one.
.PP
A
.I reliable
circuit is one that guarantees to
deliver exactly the same information to the receiver
that was passed to the transmitter.
A
.I virtual
circuit is merely one that may not be supported by a unique physical link.
Ordinary circuits tend both to lose and corrupt data,
and thus a protocol attempting to turn such a circuit into a reliable one
must guarantee to detect such errors,
and then correct them.
.PP
There are many protocols that provide reliable virtual circuits,
and some have the advantage of implementing well known standards
for communication interfaces, 
such as the \s-1CCITT X\s0.25.
However,
almost all have the disadvantage of being unnecessarily
complicated for this particular task,
and consequently,
of needing much effort to implement,
and excessive computer resources to run.
.PP
It is the aim of this package to provide a small and efficient
reliable virtual circuit protocol
with a simple user interface.
The package has been written in the 'C' language as a set of
routines that can be incorporated into an applications program.
.NH 1
DESIGN
.LP
The package is designed for flexible interfacing to the user's application.
It is accessed in two ways,
via routines to execute the protcol,
and via a global data structure to provide protocol parameters and 
addresses of user routines to handle events.
.PP
The protocol is designed to detect and correct all transmission errors,
at the same time providing several virtual circuits over the one
transmission path,
with a facility for transmitting out-of-band data to control each
virtual circuit.
.PP
Each virtual circuit is implemented by the transmission of
sequenced packets containing the circuit number and data.
Every packet contains a 16 bit
.I "Cyclic Redundancy Check"
(\s-1CRC\s0)
to detect transmission errors.
If the \s-1CRC\s0 is incorrect, then the packet is ignored.
Error correction occurs when a subsequent packet is received,
and the gap in the sequence is discovered.
Alternatively, if no correct packets are received for some time,
then a
.I timeout
request is sent to cause re-transmission.
.PP
There are three types of packets,
.I data
packets which must be acknowledged,
.I control
packets which must be acknowledged if they contain ``out-of-band'' data,
and 
.I acknowledgement
packets.
Control packets are used to initialise the virtual circuits,
and prompt for re-transmissions after unexpected delays.
.PP
.I Acknowledgement
packets may be either positive (\s-1ACK\s0),
or negative (\s-1NAK\s0).
Correctly received packets are acknowledged with \s-1ACK\s0 packets
sent in reply.
A packet received out of sequence
with a valid CRC is acknowledged with a
\s-1NAK\s0 packet sent in reply.
Reception of a \s-1NAK\s0 packet by the transmitter causes the retransmission
of the previous data packet.
.NH 1
PACKETS
.LP
All packets have the same format
(bytes are shown in separate boxes,
bit fields within bytes are separated by vertical bars,
repetition is represented by ellipses,
and optional bytes are shown in square brackets):
.DS L
.TS
center allbox;
c c c c c.
CHK\fB|\fR\|TYPE\fB|\fR\|CHAN\fB|\fR\|SEQ	SIZE	[DATA ...]	[LOCRC]	[HICRC]
.TE
.DE
.LP
where:
.LP
.RS 2
.nr PD 0
.IP \s-1CHK\s0 "\w'LOCRC,XHICRCXXXX'u"
is either 1 if 16 bit \s-1CRC\s0 is present, or 0;
.IP \s-1TYPE\s0
is either 0 (\fBdata\fR), 1 (\s-1ACK\s0), 2 (\s-1NAK\s0), or 3 (\fBcontrol\fR);
.IP \s-1CHAN\s0
is is the circuit number in the range 0-3;
.IP \s-1SEQ\s0
is the packet sequence number in the range 0-7;
.IP \s-1SIZE\s0
is the size of the data portion in the range 0 - 255;
.IP \s-1DATA\s0
is a sequence of \s-1SIZE\s0 8 bit bytes;
.IP "\s-1LOCRC, HICRC\s0"
are an optional 16 bit \s-1CRC\s0.
.nr PD .3v
.RE
.LP
The 16 bit \s-1CRC\s0 is optional as some connections
(such as those using X.25)
may already guarantee the data.
\s-1SIZE\s0 will probably be proportional to the speed of the link.
.NH 2
Data Packets
.LP
Data packets can contain up to 255 data bytes,
though the maximum is limited by the configuration, normally 128.
.NH 2
\s-1ACK\s0 Packets
.LP
Data packets are acknowledged by zero-length \s-1ACK\s0
packets with the same sequence number.
.NH 2
\s-1NAK\s0 packets
.LP
If a data packet is received \fIout of sequence\fP,
then it is buffered, and a \s-1NAK\s0
packet with the same sequence number is sent in reply.
The transmitter will then mark that packet as acknowledged,
and re-transmit the previous packet.
.NH 2
Control Packets
.LP
There are six types of control packets:
.IP "\fBreset\ transmitter\fP" "\w'\fBreset\ acknowledgeXX\fP'u"
These packets request that the circuit transmitter state be initialised.
A
.I "reset\ acknowledge"
packet is generated in reply.
Reset transmitter
(or \s-1XMT_RESET\s0)
packets also contain two fields representing
the maximum size of data packet that can be received,
and the maximum number of buffers available
(the window size).
.IP "\fBreset\ acknowledge\fP"
Reset acknowledge
(or \s-1ACK_RESET\s0)
packets cause the receiver state to be reset.
.IP "\fBreset\ request\fP"
\s-1REQ_RESET\s0
packets request the remote to send a
.I "reset transmitter"
packet in reply.
They are ignored if the remote 
.I receiver
is already reset,
in which case, an
\s-1XMT_RESET\s0
packet is already on its way, or will be sent after a time.
.IP \fBtimeout\fP
Timeout packets are generated by the receiver whenever
no correct packet has been received on the circuit for some time.
The sequence number of a timeout packet is set to that of the last correctly
received data packet.
Timeout packets also contain two fields representing the current transmit
data size, and the current transmit window size.
.IP \fBidle\fP
These packets are just fillers,
and are ignored on reception,
except for the setting of the 
.I Plastidle
flag (see below).
.IP \fBuser\fP
The contents of user control packets are passed to the invoker
via a mechanism separate from data packets,
and therefore can be used for
.I "out-of-band"
data.
The first byte of the data may not have the top bit set.
These packets are otherwise treated the same as
.I data
packets.
.NH 2
Sequence Numbers
.LP
.I Sequence
numbers are monotonically increasing (modulo 8) numbers used
to identify packet order.
The sequence numbers of \s-1ACK\s0 and \s-1NAK\s0 packets
refer to the packet being acknowledged,
all other packets
(except
.I resets ,
.I idles ,
and \fItimeouts\fP) must be in sequence. 
.PP
Specifically,
\s-1ACK\s0 means that all packets whose sequence numbers are less than
or equal to the sequence number of the \s-1ACK\s0 have been received correctly.
\s-1NAK\s0 means that the packet whose sequence number
is the same as the \s-1NAK\s0 has
been received correctly, but \fIout of sequence\fP,
and therefore implies that the sender should re-transmit
the previous packet (whose sequence number is \fIless\fP).
.NH 1
INITIALISATION
.LP
In order to use the protocol,
the user must initialise an external data structure called
.I Pconfig.
It contains parameters that should be given values as follows:
.PP
.IP PqPkt "\w'PrecvControlXX'u"
This should be a pointer to a function
that can be called to transmit a data packet.
It is called with two arguments,
the first is a pointer to the packet,
and the second is the size of the packet.
The packet pointed to may be queued for later transmission.
.IP PqCpkt
This should be a pointer to a function
that can be called to transmit a control packet.
It is called with two arguments,
the first is a pointer to the packet,
and the second is the size of the packet.
The packet pointed to must be transmitted
(or copied)
immediately, as it may be re-used.
.IP PfillPkt
This should be a pointer to a function
that can be called to fill a packet with data for a circuit.
It is called with three arguments,
the circuit number,
a pointer to a place to put the data,
and the maximum size of data that can be put there.
It must return an integer value being equal to the size of the valid data.
.IP PrecvData
This should be a pointer to a function
that can be called to receive data from a packet.
It is called with three arguments,
the circuit number,
a pointer to the data,
and the size of the data.
.IP PrecvControl
This should be a pointer to a function
that can be called to receive data from a control packet.
It is called with three arguments,
the circuit number,
a pointer to the control data,
and the size of the control data.
.IP PrTimeout
This should be a pointer to a function
that can be called to indicate a remote timeout on an idle circuit.
It is called with one argument, the circuit number.
A timeout packet has been received for a circuit for which
there are no transmit packets queued.
.IP PrReset
This should be a pointer to a function
that can be called to indicate a receiver reset on a circuit.
It is called with one argument, the circuit number.
The receiver has been reset,
and the remote transmitter has been reset.
.IP PxReset
This should be a pointer to a function
that can be called to indicate a transmitter reset on a circuit.
It is called with one argument, the circuit number.
The transmitter has been reset,
and an acknowledgement sent in reply to reset the remote receiver.
.IP PRead
This should be a pointer to a function
that can be called to read bytes from the remote virtual circuit.
It is called with four arguments,
a pointer to a place to put the bytes,
a count of the exact number of bytes to put there,
a flag indicating whether a timeout should be turned on before the read,
and a flag indicating whether the timeout should be turned off after the read,
If a timeout mechanism is employed,
then if it occurs,
this function should not return.
If it does return,
then the caller assumes that the requested number of bytes have been read.
.IP PItimo
This should be set to the number of time units that should elapse before
a timeout packet is sent on an
.I idle
circuit that has not received any bytes for
that time interval.
An
.I idle
circuit is one that has not received data for at least two
.I PRtimo
time periods.
It should be at least twice the value set for \fIPRtimo\fP.
.IP PRtimo
This should be set to the number of time units that should elapse before
a timeout packet is sent on an
.I active
circuit that has not received any bytes for
that time interval.
It should be large enough to allow for the maximum round-trip delay
for a packet and its acknowledgement,
and is obviously dependant on the speed of the real circuit,
the number of active virtual circuits,
the number of active buffers per circuit,
and the maximum size of the data packets.
.IP PXsize
This should be set to the size to be used for the data part of a packet.
This parameter is useful to restrict the size of packets on
unduly error prone or slow circuits.
It may be adjusted down by the protocol on reception of a
\s-1XMT_RESET\s0
packet.
.IP PXmax
This is set by the protocol on reception of \s-1XMT_RESET\s0 packets.
It limits the maximum size of transmitted packets to the size
of the remote receiver buffer.
.IP Pnbufs
This can be set to restrict the number of buffers in use per circuit.
A larger number will sometimes improve throughput on circuits with
large internal delays
where only one circuit is in use most of the time.
The range is 1\-4 (if configured at compile-time),
but 2 has proved optimal for most circuits.
It may be adjusted down by the protocol on reception of a
\s-1XMT_RESET\s0
packet.
.IP Poverhead
This is set by
.I Pinit
to be the protocol overhead for a packet.
The maximum size of a packet will be \fIPXsize + Poverhead\fP.
.IP PprotoT
This flag should have bit \s-1PT_CRC\s0 set if
\s-1CRC\s0
checks are to be used on all packets.
This is unnecessary on circuits via a medium such as
.I Ethernet
where the data is already guaranteed.
.IP Pnchans
This should be set to the number of circuits that are going to be used.
.IP Pfchan
This should be set to the number of the first circuit that can be used
(\fI< Pnchans\fP).
.IP Plastidle
This is set by the protocol
whenever the last packet received or transmitted was an
\s-1IDLE.\s0
.IP PBufMax
Set this to the maximum size of data to be bufferred.
Should be the same as the file system block size.
.IP PHoldAcks
Set this to the number of \s-1ACK\s0s that should be withheld.
Can't be more than \fIPnbufs\fP-1.
.IP PinPkts
This field is incremented by the protocol whenever an packet is received.
.IP PoutPkts
This field is incremented by the protocol whenever an packet is transmitted.
.IP PinBytes
This field is incremented by the protocol whenever bytes of data are received.
.IP PoutBytes
This field is incremented by the protocol whenever bytes of data are transmitted.
.IP PRsize
This value represents the current size of data packet being received.
Set by the protocol whenever a timeout packet is received.
.IP PRnbufs
This value represents the current window size being received.
Set by the protocol whenever a timeout packet is received.
.NH 2
.B "Dynamic Parameterisation"
.LP
Most of these parameters can be changed dynamically.
In particular,
\fIPRtimo\fP, \fIPXsize\fP, and \fIPnbufs\fP
can be altered to reflect changing circuit conditions.
However,
a change to
.I Pnbufs ,
.I Pnchans
or
.I Pfchan
.B must
be followed by a call to
.I Preset,
or preferably
.I Pinit
which will also check the ranges.
A change to 
.I PprotoT
\fBmust\fP be followed by a call to 
.I Pinit .
.NH 1
PROTOCOL
.LP
The protocol is considered in three parts:
circuit initialisation,
normal data transmission,
and error recovery.
.NH 2
Initialisation
.LP
Each circuit is initialised by sending a
.I "reset request"
packet followed by a
.I "reset transmitter"
packet,
and marking the circuit
\s-1RESET.\s0
No other packets can be sent on the circuit until both a
.I "reset transmitter"
packet,
and a 
.I "reset acknowledge"
packet
have been received,
at which point the circuit is marked
\s-1IDLE.\s0
If no
.I "reset transmitter"
packet is received within four
.I PItimo
intervals,
then a 
.I "reset request"
packet is re-transmitted.
.PP
On receiving a 
.I "reset request"
packet,
an active circuit is marked
\s-1RESET,\s0
and a 
.I "reset transmitter"
packet sent in reply.
Alternatively,
if the circuit is already
\s-1RESET,\s0
then the request is ignored.
.PP
On receiving a
.I "reset transmitter"
packet,
the transmitter sequence number is set to zero,
all the window buffers are cleared,
a 
.I "reset acknowledge"
packet is sent in reply,
and the user is informed via the routine \fIPxReset\fP.
.PP
On receiving a
.I "reset acknowledge"
packet,
the receiver expected sequence number is set to zero,
all the out-of-sequence buffers are cleared,
and the user is informed via the routine \fIPrReset\fP.
.NH 2
Data Transmission
.LP
Once a circuit is marked
\s-1IDLE,\s0
data packets
(or user control packets)
may be sent,
as many as are allowed by the window size.
When all available buffers in the window are full,
further data transmission is blocked until an 
\s-1ACK\s0
packet is received.
An 
\s-1ACK\s0
packet acknowledges all waiting data packets
with sequence numbers less than or equal to the 
\s-1ACK\s0
packet.
For each acknowledged packet in sequence,
the user is prompted to send more data via \fIPfillPkt\fP.
If a
\s-1NAK\s0
packet is received,
the packet with the same sequence number is marked as
acknowledged,
and the previous un-acknowledged packet is re-transmitted.
.NH 2
Error Detection and Correction
.LP
On reception of every packet,
the 
\s-1CRC\s0
is computed,
(if present, as indicated by the
\s-1CHK\s0
bit in the header).
If incorrect, the packet is dropped.
Next, for data and user control packets,
the sequence number is checked.
If the packet is in sequence,
then it is passed back to the user via the routines
\fIPrecvData\fP, or \fIPrecvControl\fP.
If it is out of sequence,
it is buffered in a holding area,
and a
\s-1NAK\s0
packet is generated in response.
Every time a correctly sequenced packet is received,
the out of sequence packet holding area is scanned for packets
that are now in sequence which are then passed back to the user.
Then an
\s-1ACK\s0
packet with the final sequence number is sent in response.
.PP
If no data packet is received in
.I PRtimo
time intervals,
then a
.I timeout
packet is transmitted.
On receiving a timeout packet,
the transmitter scans the window buffers for waiting packets,
and re-transmits in sequence any that have timed-out.
If there are no waiting packets,
then the user is informed via the routine \fIPrTimeout\fP.
.NH 1
ROUTINES
.LP
Several routines are provided to execute the protocol on behalf of the user.
In a typical implementaion
.I Pinit
should be called at the start,
and then 
.I Precv
should be called from within a driver loop,
with periodic calls to 
.I Ptimo.
.I Pflush
should be called on termination to retrieve any bufferred data.
.I Pidle
can be used to keep the real circuit busy if need be.
.I Psend
and
.I Psendc
are best used from within the routines allocated in
.I Pconfig
(described above).
.NH 2
.B Pflush
.LP
This routine flushes any data that has been received and buffered
but not yet passed back to the user.
.NH 2
.B Pidle
.LP
This routine generates an 
\s-1IDLE\s0
packet and queues it for transmission via the routine \fIPqCpkt\fP.
.NH 2
.B Pinit
.LP
.I Pinit\^
initialises the transmitter and receiver states,
generates a
\s-1REQ_RESET\s0
packet,
and calls
.I Preset,
for each circuit in use.
.I Pinit
returns the value
.B false
if an initialisation inconsistency is detected.
.NH 2
.B Preset
.LP
.I Preset
sends an
\s-1XMT_RESET\s0
packet for the circuit and initialises the receiver state information.
A corresponding
\s-1ACK_RESET\s0
packet is expected from the remote end to signal that the remote
transmitter state has been reset.
.NH 2
.B Precv
.LP
.I Precv
disassembles packets from the link.
It should be called whenever there is data to be received.
.I Precv
will make use of the
.I Pconfig
function pointer field
.I PRread
to fetch data from the link.
.I PRread
is called with four arguments:
the first a pointer to a data buffer;
the second a count of bytes to be placed there;
the third and fourth are booleans:
the third is true if
.I timeouts
should be turned on,
the fourth is true if
.I timeouts
should be turned off.
On identifying a correct packet,
.I Precv
will use the function pointer
.I PqCpkt
to send an acknowledgement.
.PP
On receiving a data packet,
the data will be passed back via the function pointer
.I PrecvData
with three arguments:
the circuit number;
a pointer to the data;
and the size of the data.
Control data will be passed back via the function pointer
.I PrecvControl
with arguments as for \fIPrecvData\fP.
.PP
\s-1XMT_RESET\s0
packets will cause the transmitter state to be reset,
and an
\s-1ACK_RESET\s0
packet sent in reply,
and then the user will be notified via the function pointer
.I PxReset
with the circuit number as argument.
Similarly, when a
\s-1ACK_RESET\s0
packet is received, the receiver state will be reset,
and then the user will be notified via the function pointer
.I PrReset
with the circuit number as argument.
.PP
\s-1REQ_RESET\s0
packets will cause
.I Preset
to be called iff the receiver is not already reset.
.PP
Remote
.I timeouts
received on an
.I idle
circuit will be notified via the function pointer
.I PrTimeout
with the circuit number as argument.
However, if the circuit is
.I active
(has packets awaiting acknowledgement),
then the waiting packets will be re-transmitted.
.PP
\s-1ACK\s0
packets received will cause
.I Precv
to call
.I Psend
with the circuit number as argument.
.NH 2
.B Psend
.LP
.I Psend
will attempt to find an empty packet,
and fill it with data via the function pointer \fIPfillPkt\fP.
.I PfillPkt
is called
with three arguments:
the circuit number;
a pointer to the data;
and the size of the data.
It should return the size of the data actually read.
The packet is then queued for transmission via the function pointer
\fIPqPkt\fP.
.PP
.I Psend
will fail (return value <= 0) if
.I PfillPkt
fails,
or if there are no empty packets.
.I Psend
assumes that its argument is in range.
.NH 2
.B Psendc
.LP
.I Psendc
behaves in much the same way as \fIPsend\fP,
except that data is passed in its arguments.
It will format a control packet,
move the data into it,
and queue the packet for transmission via the function pointer \fIPqPkt\fP.
.I Psendc
checks its arguments for consistency,
and will return -1 if there is an error.
It will return 0 if there are no empty packets available,
and 1 for success.
.NH 2
.B Ptimo
.LP
.I Ptimo
should be called at periodic intervals to scan the circuits for stalled flow.
Its argument should be the time units
elapsed since the last call to either \fIPinit\fP or \fIPtimo\fP,
(ie: the same time units as those used to preset
the \fIPItimo\fP and \fIPRtimo\fP
fields in \fIPconfig\fP).
.I Ptimo
will generate
\s-1TIMEOUT\s0
packets for those circuits that have not received recently.
.I Recently
means the value in
.I PItimo
for
.I idle
circuits, or the value in
.I PRtimo
for active ones.
.I Ptimo
returns \fBtrue\fR if none of the circuits have received anything for
four (4)
.I PItimo
time periods.
.NH 1
ALTERNATIVE PROTOCOLS
.LP
Several alternative versions of the protocol exist to cater for various
virtual circuit characteristics.
These alternatives are selected by compile-time options in the protocol source.
.NH 2
Bit Dropouts
.LP
An alternative version of the protocol exists
for use on links with severe dropout characteristics
(ie: whole bytes disappear, rather than just getting the bits corrupted).
In an attempt to make packet header synchronisation more effective,
an extra
.I size
byte, being the complement of the first, is added to the header.
This allows more reliable identification of a packet header,
and results in fewer errors resulting from the mistaken
recognition of header bytes within packet data.
.PP
All packets have the same format,
and are the same as those described earlier,
except for the introduction of the ``complement size'' byte
(bytes are shown in separate boxes,
bit fields within bytes are separated by vertical bars,
repetition is represented by ellipses,
and optional bytes are shown in square brackets):
.DS L
.TS
center allbox;
c c c c c c.
CHK\fB|\fR\|TYPE\fB|\fR\|CHAN\fB|\fR\|SEQ	SIZE	~SIZE	[DATA ...]	[LOCRC]	[HICRC]
.TE
.DE
.LP
where:
.LP
.RS 2
.nr PD 0
.IP \s-1CHK\s0 "\w'LOCRC,XHICRCXXXX'u"
is either 1 if 16 bit \s-1CRC\s0 is present, or 0;
.IP \s-1TYPE\s0
is either 0 (\fBdata\fR), 1 (\s-1ACK\s0), 2 (\s-1NAK\s0), or 3 (\fBcontrol\fR);
.IP \s-1CHAN\s0
is is the circuit number in the range 0-3;
.IP \s-1SEQ\s0
is the packet sequence number in the range 0-7;
.IP \s-1SIZE\s0
is the size of the data portion in the range 0 - 255;
.IP ~\s-1SIZE\s0
is the complement of the size of the data portion in the range 255 - 0;
.IP \s-1DATA\s0
is a sequence of \s-1SIZE\s0 8 bit bytes;
.IP "\s-1LOCRC, HICRC\s0"
are an optional 16 bit \s-1CRC\s0.
.nr PD .3v
.RE
.LP
The 16 bit \s-1CRC\s0 is optional as some connections
may already guarantee the data.
\s-1SIZE\s0 will probably be proportional to the speed of the link.
.NH 2
Ethernet Datagrams
.LP
If access to a virtual circuit using Ethernet datagrams is available
(such as \s-1UDP\s0),
then a version of the protocol exists which uses 1024 byte packets,
with no \s-1CRC\s0 calculation.
This takes advantage of the fact that an Ethernet datagram, if delivered,
will already have had its bits checked with Ethernet's 32-bit \s-1CRC\s0.
The protocol need only attempt to detect dropped, or duplicated, packets.
.PP
Packets are formatted as follows:
.DS L
.TS
center allbox;
c c c c.
TYPE\fB|\fR\|CHAN\fB|\fR\|SEQ	SIZE1	SIZE2	[DATA ...]
.TE
.DE
.LP
where:
.LP
.RS 2
.nr PD 0
.IP \s-1TYPE\s0 "\w'LOCRC,XHICRCXXXX'u"
is either 0 (\fBdata\fR), 1 (\s-1ACK\s0), 2 (\s-1NAK\s0), or 3 (\fBcontrol\fR);
.IP \s-1CHAN\s0
is is the circuit number in the range 0-3;
.IP \s-1SEQ\s0
is the packet sequence number in the range 0-7;
.IP \s-1SIZE1\s0
is the low 8 bits of the size of the data portion in the range 0 - 65535;
.IP \s-1SIZE2\s0
is the high 8 bits of the size of the data portion in the range 0 - 65535;
.IP \s-1DATA\s0
is a sequence of (\s-1SIZE2\s0<<8)|\s-1SIZE1\s0 8 bit bytes;
.nr PD .3v
.RE
.NH 2
X.25
.LP
If the virtual circuit is provided by an X.25 connection,
then various features need to be taken into consideration.
Public Packet Switched Networks
usually charge per-packet, rather than by the amount of data transferred.
With data flowing uni-directionally, \s-1ACK\s0 packets then incur the full
cost of an X.25 packet \(em a feature devoutly to be avoided.
Also, the reliability of such circuits is usually very high.
So, this version of the protocol reduces the number of \s-1ACK\s0s in flight
per data byte transferred by a factor of up to 56 on the standard protocol.
This is done by allowing a window size of up to 8 packets,
by only sending an \s-1ACK\s0 every \fIwindow\fP-1 packets,
and by allowing the packets to contain up to 1024 bytes of data.
.PP
Packets are formatted as follows:
.DS L
.TS
center allbox;
c c c c c c.
TYPE\fB|\fR\|CHAN\fB|\fR\|SEQ	SIZE1	SIZE2	[DATA ...]	LOCRC	HICRC
.TE
.DE
.LP
where:
.LP
.RS 2
.nr PD 0
.IP \s-1TYPE\s0 "\w'LOCRC,XHICRCXXXX'u"
is either 0 (\fBdata\fR), 1 (\s-1ACK\s0), 2 (\s-1NAK\s0), or 3 (\fBcontrol\fR);
.IP \s-1CHAN\s0
is is the circuit number in the range 0-3;
.IP \s-1SEQ\s0
is the packet sequence number in the range 0-15;
.IP \s-1SIZE1\s0
is the high 8 bits of the size of the data portion in the range 0 - 65535;
.IP \s-1SIZE2\s0
is the low 8 bits of the size of the data portion in the range 0 - 65535;
.IP \s-1DATA\s0
is a sequence of (\s-1SIZE1\s0<<8)|\s-1SIZE2\s0 8 bit bytes;
.IP "\s-1LOCRC, HICRC\s0"
are the 16 bit \s-1CRC\s0.
.nr PD .3v
.RE
