/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID 88/07/24 @(#)SysWarn.c	1.3
*/

/*
**	System warning on stderr
*/

#define	STDIO

#include	"global.h"

extern char *	sys_errlist[];
extern int	sys_nerr;


#if VARARGS
void
SysWarn(va_alist)
	va_dcl
{
	char *		s;
	register int	en = errno;
	va_list		va;

	va_start(va);
	s = va_arg(va, char *);
	VMesg("system warning", s, va);
	va_end(va);

	if ( en < sys_nerr )
		(void)fprintf(stderr, ": %s\n", sys_errlist[en]);
	else
		(void)fprintf(stderr, ": Error %d\n", en);

	(void)fflush(stderr);

	errno = en;
}
#else
/*VARARGS1*/
void
SysWarn(s, a1, a2, a3, a4, a5, a6)
	char *		s;
	char *		a1;
	char *		a2;
	char *		a3;
	char *		a4;
	char *		a5;
	char *		a6;
{
	register int	en = errno;

	Mesg("system warning", s, a1, a2, a3, a4, a5, a6);

	if ( en < sys_nerr )
		(void)fprintf(stderr, ": %s\n", sys_errlist[en]);
	else
		(void)fprintf(stderr, ": Error %d\n", en);

	(void)fflush(stderr);

	errno = en;
}
#endif
