#ifndef	lint
static char sccsid[] = "@(#)dataplex.c	1.1 (IPS)	8 May 1986";
#endif	lint


/*
 *	patterns and functions to call using hayes compatible modems
 */

#include	"global.h"
#include	"caller.h"
#include	"ipso.h"

#define TRACE

/*
 *	modem parameters: AT (Hayes) command set
 *
 *		&F		reset modem to factory configuration
 *		&C1		DCD follows state of received carrier
 *		&D2		hang up on loss of DTR
 *		&I0		disable constant speed DTE interface
 *		S37=10		set inactivity timer to 10 minutes
 */
#define	RESETMODEM	"write AT&F&C1&D2S37=10\r"

/*
 *	The following PASSWD stuff is imported from "passwd.q"
 */

#ifndef	CALLARGS
#define	CALLARGS	"callargs"
#endif
#ifndef	CALLTIMES
#define	CALLTIMES	"calltimes"
#endif	CALLTIMES

#define	MAXPHONES	8

extern	int	Traceflag;

char	*callargs	= CALLARGS,	
	*daemon1	= NNDAEMON,	/* standard daemon */
	*daemon2	= NN2DAEMON,	/* alternate protocol */
	*hostflg	= "-BF",	/* dialup, don't fork, cooked */
	*host	 	= "ipso",	/* connecting from where? */
	*target  	= NULLSTR,	/* connecting to where? */
	*passwd  	= PASSWD,
	*ph_num[MAXPHONES + 1],		/* array of phone number pointers */
	**phoneno	= ph_num,	/* Current phone number to call */
	*device  	= DEVICE,	/* Which call unit? (cul0) */
	*speed   	= "1200",
	*opentime	= "60",
	*logintime	= "25";		/* MUST be greater then 15 seconds
						(modem carrier detect time) */

int	rclcount = 0,	/* count of resets calls */
	rcount	 = 0,	/* count of resets */
	tcount	 = 0,	/* count of timeouts */
	lcount	 = 0;	/* count of Unix login attempts */
	dcount	 = 0;	/* count of dial attempts */
	hadlogin = 0;	/* marker set to detect passwd: before login: */

int	callbusy(),
	callefail(),
	calltfail(),
	eof(),
	gotlogin(),
	gotpasswd(),
	ignoreline(),
	noanswer(),
	nocarrier(),
	nodialtone(),
	resetnotok(),
	resetunit(),
	start2(),
	started(),
	timeout();
	tocallunit(),
	tounix();


struct patlist atreset[] =
{
	{ "OK",    tocallunit },
	{ TIMEOUT, resetnotok },
	{ 0, 0 }
};

struct patlist atcallunit[] =
{
	{ "CONNECT", tounix },
	{ "BUSY", callbusy },
	{ "NO ANSWER", noanswer },
	{ "NO CARRIER", nocarrier },
	{ "NO DIALTONE", nodialtone },
	{ "ERROR", callefail },
	{ TIMEOUT, calltfail },
	{ 0, 0 }
};

struct patlist atunix[] =
{
	{ "[Ii]llegal", ignoreline },
	{ "[Ii]ncorrect", ignoreline },
	{ "[Ll]ogin", gotlogin },
	{ "[Pp]assword", gotpasswd },
	{ STARTMSG, started},
	{ START2MSG, start2 },	/* alternate protocol */
	{ TIMEOUT, timeout },
	{ EOFSTR, eof },
	{ 0, 0 }
};

args(argc, argv)
register int	argc;
register char *	argv[];
{
	while ( --argc > 0 )
	{
		if ( **++argv == '-' )
		{
			register int	c;

			while ( c = *++*argv )
			{
				switch ( c )
				{
				case 'd':
					device = ++*argv;
					goto break2;
				case 'l':
					host = ++*argv;
					goto break2;
				case 'p':
					if (phoneno != &ph_num[MAXPHONES])
					{
					    *phoneno++ = ++*argv;
					    goto break2;
					}
					outend("fail too many phone numbers");
					exit(1);
				case 's':
					speed = ++*argv;
					goto break2;
				case 'P':
					passwd = ++*argv;
					goto break2;
				case '1':
					daemon1 = ++*argv;
					goto break2;
				case '2':
					daemon2 = ++*argv;
					goto break2;
				case 'T':
#ifdef TRACE
					Traceflag = atoi(++*argv);
#endif
					goto break2;
				default:
					out("fail unexpected flag \"-");
					out(*argv);
					out("\" in ");
					outend(CALLARGS);
					exit(1);
				}
			}
break2:			;
		}
		else if (target != NULLSTR)
		{
			out("fail target already given: \"");
			out(*argv);
			outend("\" unexpected.");
			exit(1);
		}
		else
			target = *argv;
	}
}

void
init(argc, argv)
int	argc;
char	*argv[];
{

	args(argc, argv);

	if (target == NULLSTR)
	{
		outend("fail no target");
		exit(1);
	}

	callargs = concat(SPOOLDIR(), target, "/", callargs, NULLSTR);
	(void)readargs(callargs, args);
	phoneno = ph_num;

	if (*phoneno == NULLSTR)
	{
		outend("fail no phone numbers");
		exit(1);
	}

#	ifdef	TRACE
	if (Traceflag > 5 )
		outend("trace opening line......");
#	endif	TRACE

	out("timeout "); outend(opentime);
	out("opendial "); outend(device);
#	if	SYSTEM >= 3
	outend("local");
#	endif	SYSTEM
	out("speed "); outend(speed);
	out("timeout "); outend(logintime);

#	ifdef	TRACE
	if (Traceflag > 1 )
		outend("trace starting reader ......");
#	endif	TRACE

	outend("read");
	resetunit();
	rclcount = 0;
}

resetunit()
{
#ifdef	TRACE
	if (Traceflag > 5 )
		outend("trace resetting modem ......");
#endif	TRACE

	if (++rclcount > 20)
		outend("fail call fail - modem reset called 20 times.");

	rcount = 0;
	dcount = 0;
	hadlogin = 0;
	state(atreset);
	outend("sleep 2");
#	ifdef	NOTDEF
	outend("write +++");
	outend("sleep 2");
#	endif	NOTDEF
	outend(RESETMODEM);
	getinput();
}

resetnotok()
{
#	ifdef	TRACE
	if (Traceflag > 5 )
		outend("trace issuing another reset comand ......");
#	endif	TRACE

	if (++rcount > 10)
		outend("fail call fail - 10 modem resets failed.");

	state(atreset);
	outend("sleep 2");
#	ifdef	NOTDEF
	outend("write +++");
	outend("sleep 2");
#	endif	NOTDEF
	flushinput();
	outend(RESETMODEM);
	reset();
}

tocallunit()
{
#	ifdef	TRACE
	if (Traceflag > 1 )
		outend("trace dialing......");
#	endif	TRACE

	state(atcallunit);
	out("write ATDP"); out(*phoneno++); outend("\r");

	if (*phoneno == NULLSTR)
		phoneno = ph_num;

	getinput();
}

callbusy()
{
	if (++dcount > 9)
		outend("fail was busy 10 times");
	else
	{
#		ifdef	TRACE
		if (Traceflag)
			outend("trace reset modem - call busy");
#		endif	TRACE

		resetunit();
	}
}

noanswer()
{
	if (++dcount > 9)
		outend("fail no answer 10 times");
	else
	{
#		ifdef	TRACE
		if (Traceflag)
			outend("trace reset modem - no answer");
#		endif	TRACE

		resetunit();
	}
}

nodialtone()
{
	if (++dcount > 9)
		outend("fail no no dialtone 10 times");
	else
	{
#		ifdef	TRACE
		if (Traceflag)
			outend("trace reset modem - no dial tone");
#		endif	TRACE

		resetunit();
	}
}

calltfail()
{
#	ifdef	TRACE
	if (Traceflag > 5 )
		outend("trace waiting......");
#	endif	TRACE

	if (++dcount > 9)
		outend("fail timeout 9 times");
	else
		reset();
}

callefail()
{
	getinput();

	if (++dcount > 9)
		outend("fail error");
	else
	{
#		ifdef	TRACE
		if (Traceflag)
			outend("trace reset modem - error");
#		endif	TRACE

		reset();
		flushinput();
		resetunit();
	}
}

ignoreline()
{
	getinput();
	reset();
}

nocarrier()
{
	if (++dcount > 9)
		outend("fail no carrier");
	else
	{
#		ifdef	TRACE
		if (Traceflag)
			outend("trace reset modem - no carrier");
#		endif	TRACE

		resetunit();
	}
}

tounix()
{
	tcount = 0;
	lcount = 0;
	dcount = 0;

#	ifdef	TRACE
	if (Traceflag > 5 )
		outend("trace clearing line of modem startup garbage ......");
#	endif	TRACE

	outend("write \n\n");
	sleep(10);
	flushinput();
	outend("write \n");

#	ifdef	TRACE
	if (Traceflag > 1 )
		outend("trace waiting for login......");
#	endif	TRACE

#	if	SYSTEM >= 3
	outend("remote");
#	endif	SYSTEM
	state(atunix);
}

gotlogin()
{
#	ifdef	TRACE
	if (Traceflag > 5 )
		outend("trace got login ......");
#	endif	TRACE

	if ( ++lcount >= 9 )
	{
		out("fail too many login attempts at ");
		outend(target);
	}

	hadlogin++;

	out("write "); out(host); outend("\r");
	getinput();
}


gotpasswd()
{
#	ifdef	TRACE
	if (Traceflag > 5 )
		outend("trace got passwd ......");
#	endif	TRACE

	if (hadlogin)
	{
		out("write "); out(passwd); outend("\r");
		getinput();
	}
	else
		ignoreline();
}


started()
{
#	ifdef	TRACE
	if (Traceflag)
		outend("trace call succeeded, daemon starting");	/**/
#	endif	TRACE

	out("succeed "); outend(target);
	exit(0);
}


start2()
{
#	ifdef	TRACE
	if (Traceflag)
		outend("trace call succeeded, daemon 2 starting");	/**/
#	endif	TRACE

	out("daemon "); outend(daemon2);
	out("succeed "); out(hostflg); out(" "); outend(target);
	exit(0);
}


timeout()
{
	if (++tcount >= 9)
	{
		outend("sleep 2");
#		ifdef	NOTDEF
		outend("write +++");
		outend("sleep 2");
#		endif	NOTDEF
		outend(RESETMODEM);
		outend("fail 9 timeouts in login");
		exit(1);
	}
	outend("write \r");
	reset();
}

eof()
{
	outend("fail unexpected eof");
	exit(1);
}
