static char sccsid[] = "@(#)trailblazer.c	1.2 (Softway) 86/04/28";
/*
**	Patterns and functions to call using the Netcomm ``Trailblazer'' modem
**	(mostly Hayes compatible.)
**
**
**	Here are suggested Sun III setup parameters for use with Trailblazer
**	modems.  These parameters give an average real data throughput of
**	about 680 bytes/sec. to/from somewhat overloaded VAX 11/780s, and
**	allow connection at the slower speeds as well by sending <BREAK>
**	to trigger the getty speed selection cycle.
**
**  The following is INSANE .. both modems should be configured the same
**  way (since any rational modem will be both dial in and dial out there
**  is no difference in any case .. use the "getty" modem config...)
**
**	The calling Trailblazer should be config'd with the following command:-
**
**	at &f s45=0 s50=0 s51=4 s52=2 s54=3 s58=3 s66=0 s68=3 s110=1 q6 &w
**
**	and the ``getty'' Trailblazer with this command:-
**
**	at &f s45=0 s50=0 s51=4 s52=2 s53=3 s54=3 s55=3
**		s58=3 s66=0 s68=3 s110=1 e0 q3 &w
**
**	The call program should invoke ``PNdaemon'' with the following
**	parameters in the ``params'' file:-
**		-CXNH -b8 -f2 -s500 -w1 -z512
**
**	These configure ``cooked'' protocol with XON/XOFF flow control,
**	and half-duplex message transfer on one channel.
**
**	I've tried ``-z1024'' and it seems sometimes to achieve around 850
**	bytes/sec. but in general gets more errors.  This may be due to
**	overloaded vaxen, and you might try the larger buffers on faster
**	CPUs (with DMA tty i/o.)
*/

#include	"global.h"
#include	"caller.h"
#include	<signal.h>

#define TRACE

/*
**	The following PASSWD stuff is imported from "passwd.q"
*/

#ifndef	CALLARGS
#define	CALLARGS	"callargs"
#endif
#ifndef	CALLTIMES
#define	CALLTIMES	"calltimes"
#endif	CALLTIMES

#define	MAXPHONES	8

extern	int	Traceflag;

char
	*callargs	= CALLARGS,	
	*daemon1	= NNDAEMON,	/* standard daemon */
	*daemon2	= ENDAEMON,	/* alternate protocol */
	*daemon3	= PNDAEMON,	/* high-speed protocol */
	*hostflg	= "-BF",	/* dialup, don't fork, cooked */
	*host	 	= NULLSTR,	/* connecting from where? */
	*target  	= NULLSTR,	/* connecting to where? */
	*passwd  	= NULLSTR,
	*dialpw  	= NULLSTR,
	*afterst	= "ATZ",
	*ph_num[MAXPHONES + 1],		/* array of phone number pointers */
	**phoneno	= ph_num,	/* Current phone number to call */
	*device  	= NULLSTR,	/* Which call unit? (cul0) */
	*speed   	= "19200",
	*opentime	= "60",
	*logintime	= "35";		/* MUST be greater then 15 seconds
						(modem carrier detect time) */


int
	rclcount = 0,	/* count of resets calls */
	rcount	 = 0,	/* count of resets */
	tcount	 = 0,	/* count of timeouts */
	ecount	 = 0,	/* count of unexpected eofs */
	lcount	 = 0,	/* count of Unix login attempts */
	dcount	 = 0,	/* count of dial attempts */
	flush	 = 0,	/* flush input on connect flag */
	fast	 = 1,	/* 19200 connection to blazer */
	ccitt	 = 1,	/* 1200 baud using V22 standard */
	xonoff   = 0;	/* use RTS/CTS or XON/XOFF flow control */

int
	callbusy(),
	callefail(),
	calltfail(),
	eof(),
	gotlogin(),
	gotpasswd(),
	gotdialpw(),
	ignoreline(),
	nocarrier(),
	resettimo(),
	resetunit(),
	startpn(),
	start2(),
	started(),
	timeout();
	tocallunit(),
	tounix1200(),
	tounix2400(),
	tounix300(),
	tounixfast(),
	tounix();

struct patlist atreset[] =
{
	{ "OK",    tocallunit },
	{ TIMEOUT, resettimo },
	{ 0, 0 }
};


struct patlist atcallunit[] =
{
	{ "CONNECT FAST", tounixfast },
	{ "CONNECT 1200", tounix1200 },
	{ "CONNECT 2400", tounix2400 },
	{ "CONNECT",	  tounix300 },	/* really want to bother? */
	{ "BUSY",	  callbusy },
	{ "NO CARRIER",   nocarrier },
	{ "ERROR",	  callefail },
	{ TIMEOUT,	  calltfail },
	{ 0, 0 }
};

struct patlist atunix[] =
{
	{ "[Ii]llegal", ignoreline },
	{ "[Ii]ncorrect", ignoreline },
	{ "[Ll]ogin", gotlogin },
	{ "[Dd]ial[iu][np] [Pp]assword", gotdialpw },
	{ "[Pp]assword", gotpasswd },
	{ PNSTARTS, startpn },
	{ STARTMSG, started },
	{ START2MSG, start2 },	/* alternate protocol */
	{ "NO CARRIER", nocarrier },
	{ TIMEOUT, timeout },
	{ EOFSTR, eof },
	{ 0, 0 }
};

args(argc, argv)
	register int	argc;
	register char *	argv[];
{
	while ( --argc > 0 )
	{
		if ( **++argv == '-' )
		{
			register int	c;

			while ( c = *++*argv )
			{
				switch ( c )
				{
				case 'b':
					ccitt = 0;	/* Bell 212 1200 */
					break;
				case 'c':
					ccitt = 1;	/* CCITT V22 1200 */
					break;
				case 'F':
					flush = 1;	/* Flush input on connect */
					break;
				case 'd':
					device = ++*argv;
					goto break2;
				case 'l':
					host = ++*argv;
					goto break2;
				case 's':
					speed = ++*argv;
					goto break2;
				case 'p':
					if (phoneno != &ph_num[MAXPHONES])
					{
					    *phoneno++ = ++*argv;
					    goto break2;
					}
					outend("fail too many phone numbers");
					exit(1);
				case 'P':
					passwd = ++*argv;
					goto break2;
				case 'D':
					dialpw = ++*argv;
					goto break2;
				case 'a':
					afterst = ++*argv;
					goto break2;
				case '1':
					daemon1 = ++*argv;
					goto break2;
				case '2':
					daemon2 = ++*argv;
					goto break2;
				case '3':
					daemon3 = ++*argv;
					goto break2;
				case 'M':
					hostflg = ++*argv;
					goto break2;
				case 'X':
					++xonoff;
					break;
				case 'T':
#ifdef TRACE
					Traceflag = atoi(++*argv);
#endif
					goto break2;
				default:
					out("fail unexpected flag \"-");
					out(*argv);
					out("\" in ");
					outend(CALLARGS);
					exit(1);
				}
			}
break2:			;
		}
		else if (target != NULLSTR)
		{
			out("fail target already given: \"");
			out(*argv);
			outend("\" unexpected.");
			exit(1);
		}
		else
			target = *argv;
	}
}

setafter()
{
	outend("after local");
	outend("after sleep 2");
	outend("after write +++");
	outend("after sleep 2");
	out("after speed "); outend(speed);
	outend("after break");
	outend("after write A");
	out("after write "); out(afterst); outend("\r");
	outend("after close");
}

sigabort()
{
#ifdef	TRACE
	if (Traceflag)
		outend("trace sigterm received - exiting");	/**/
#endif	TRACE
	outend("sleep 2");
	outend("flush");
	flushinput();
	outend("write +++");
	outend("sleep 2");
	outend("flush");
	flushinput();
	fail("sigterm received");
}

void
init(argc, argv)
	int	argc;
	char	*argv[];
{

	args(argc, argv);
	if (target == NULLSTR)
	{
	    outend("fail no target");
	    exit(1);
	}

	callargs = concat(SPOOLDIR(/), target, "/", callargs, NULLSTR);
	(void)readargs(callargs, args);
	phoneno = ph_num;
	if (*phoneno == NULLSTR)
	{
	    outend("fail no phone numbers");
	    exit(1);
	}
	signal(SIGTERM, sigabort);
#ifdef	TRACE
	if (Traceflag >= 2 )
		outend("trace opening line......");
#endif	TRACE
	out("timeout "); outend(opentime);
	out("opendial "); outend(device);
	outend("local");
	out("speed "); outend(speed);
	outend("write \r");
	out("timeout "); outend(logintime);
	setafter();
#ifdef	TRACE
	if (Traceflag >= 2 )
		outend("trace starting reader ......");
#endif	TRACE
	outend("read");
	resetunit();
	rclcount = 0;
}

resetunit()
{
	rcount = 0;
	dcount = 0;
	resettimo();
}

resettimo()
{
#ifdef	TRACE
	if (Traceflag >= 2 )
		outend("trace resetting modem ......");
#endif	TRACE
	if (++rclcount > 6)
		fail("call fail - modem reset called 6 times.");
	state(atreset);
	outend("local");
	outend("sleep 2");
	outend("flush");
	flushinput();
	outend("write +++");
	outend("sleep 2");
	outend("flush");
	flushinput();
	out("speed "); outend(speed);
	if ((rclcount & 1) == 0)
	{
		outend("break");
		outend("sleep 3");
		outend("write A");
		outend("sleep 1");
		outend("write ATZ\r");
		outend("sleep 2");
		outend("write ATE0Q3\r");
		outend("sleep 1");
	}
	else
		outend("write A");
	outend("write ATH0");
	outend("write Q0E0");
	outend("write X3V1");
#ifdef	TRACE
	if (Traceflag)
		outend("write M1");
	else
#endif	TRACE
		outend("write M1");

	if (fast) {
		outend("write S52=2");
		outend("write S66=1");
		outend("write S51=5");
		if (xonoff)
			outend("write S58=3");
		else
			outend("write S58=2");
		outend("write S67=0");
		outend("write S68=255");
		outend("write S95=2");
		outend("write S110=1");
	}
	/*
	if (ccitt)
		outend("write B2");
	else
		outend("write B7");
	*/
	outend("write S0=0\r");
	reset();
}

tocallunit()
{
#ifdef	TRACE
	if (Traceflag >= 2 )
		outend("trace dialing......");
#endif	TRACE
	state(atcallunit);
	out("write ATD"); out(*phoneno++); outend("\r");
	if (*phoneno == NULLSTR)
	    phoneno = ph_num;
	reset();
}

callbusy()
{
	if (++dcount > 9)
		fail("was busy 10 times");
	else
	{
#ifdef	TRACE
		if (Traceflag)
			outend("trace reset modem - call busy");
#endif	TRACE
		resetunit();
	}
}

calltfail()
{
#ifdef	TRACE
	if (Traceflag >= 2 )
		outend("trace waiting......");
#endif	TRACE
	if (++dcount > 9)
		fail("timeout 9 times");
	else
		reset();
}

callefail()
{
	if (++dcount > 9)
		fail("error");
	else
	{
#ifdef	TRACE
		if (Traceflag)
			outend("trace reset modem - error");
#endif	TRACE
		outend("flush");
		flushinput();
		resetunit();
	}
}

ignoreline()
{
	reset();
}

nocarrier()
{
	if (++dcount > 9)
		fail("no carrier");
	else
	{
#ifdef	TRACE
		if (Traceflag)
			outend("trace reset modem - no carrier");
#endif	TRACE
		resetunit();
	}
}

tounix1200()
{
	tounix("1200");
}

tounix2400()
{
	tounix("2400");
}

tounixfast()
{
	tounix("19200");
}

tounix300()
{
	tounix("300");
}

tounix(sp)
char *sp;
{
	tcount = 0;
	lcount = 0;
	dcount = 0;
	if (strcmp(speed, sp) != 0)
	{
		out("speed "); outend(sp);
	}
#ifdef	TRACE
	if (Traceflag >= 2 )
		outend("trace waiting for login......");
#endif	TRACE
	outend("remote");
	if (flush)
	{
		outend("sleep 5");
		outend("flush");
		flushinput();	/* toss away junk */
		out("write "); out(host); outend("\r");
	}
	state(atunix);
	reset();
}

gotlogin()
{
#ifdef	TRACE
	if (Traceflag >= 2 )
		outend("trace got login ......");
#endif	TRACE
	if ( ++lcount >= 9 )
		fail("too many login attempts");
	out("write "); out(host); outend("\r");
	reset();
}


gotpasswd()
{
#ifdef	TRACE
	if (Traceflag >= 2 )
		outend("trace got passwd ......");
#endif	TRACE
	out("write "); out(passwd); outend("\r");
	reset();
}


gotdialpw()
{
#ifdef	TRACE
	if (Traceflag >= 2 )
		outend("trace got dialin passwd ......");
#endif	TRACE
	out("write "); out(dialpw); outend("\r");
	reset();
}


startpn()
{
#ifdef	TRACE
	if (Traceflag)
		outend("trace call succeeded, PNdaemon starting");	/**/
#endif	TRACE
	out("daemon "); outend(daemon3);
	out("succeed "); out(hostflg); out(" "); outend(target);
	exit(0);
}


started()
{
#ifdef	TRACE
	if (Traceflag)
		outend("trace call succeeded, daemon starting");	/**/
#endif	TRACE
	out("succeed "); out(hostflg); out(" "); outend(target);
	exit(0);
}


start2()
{
#ifdef	TRACE
	if (Traceflag)
		outend("trace call succeeded, daemon 2 starting");	/**/
#endif	TRACE
	out("daemon "); outend(daemon2);
	out("succeed "); out(hostflg); out(" "); outend(target);
	exit(0);
}


timeout()
{
	if (++tcount >= 9)
	{
		outend("sleep 2");
		outend("write +++");
		outend("sleep 2");
		fail("9 timeouts in login");
	}
	if (tcount & 1)
		outend("write \r");
	else
		outend("break");
	reset();
}

eof()
{
	outend("close");
	out("timeout "); outend(opentime);
	out("opendial "); outend(device);
	out("speed "); outend(speed);
	outend("write \r");
	out("timeout "); outend(logintime);
	outend("local");
	if (++ecount > 5)
		fail("unexpected eof");
#ifdef	TRACE
	if (Traceflag)
		outend("trace unexpected eof");	/**/
#endif	TRACE
	outend("read");
	resetunit();
}

fail(s)
register char *s;
{
	outend("write \r");
	out("write "); out(afterst); outend("\r");
	out("fail ");
	outend(s);
	exit(1);
}
