#include <sysexits.h>

char *ap[800];
char hn[32];
char org[128];
char *rindex(), *index();

/*
 * this cruddy little program gets round a deficiency in SunIII
 * whereby there's no option to sendfile to set the address of
 * the sender of a message directly, someone has to split it into
 * the user name & host pieces.  That's us.
 */

main(argc, argv)
	register int argc;
	register char **argv;
{
	register char **a = ap;
	register char *p, *q, *d;

	gethostname(hn, sizeof(hn));

	for (a = ap; --argc >= 0; a++, argv++) {
		if (!(*a = *argv))
			break;
		if (argv[0][0] != '-' || argv[0][1] != 's')
			continue;

		/* we found the '-s' arg from sendmail (-suser@host) */

		p = rindex(argv[0], '@');
		if (p == 0)			/* no host - OK */
			continue;
		p++;
		q = index(p, '.');
		/*
		 * 'q' is the domain string (if any), 'd' is the last domain
		 */
		if (q) {
			d = rindex(q, '.');		/* cannot be 0 */
			*q = 0;
		}
		if (strccmp(p, hn) == 0) {
			/*
			 * Its our host!
			 *
			 * SunIII has fits if we tell it that the message
			 * comes from where it comes from, so we had better
			 * not do that ...
			 */
			p[-1] = 0;
			continue;
		}
		if (q && strccmp(d+1, "oz")) {
			/*
			 * we have a domain string, that doesn't end in 'oz'
			 *
			 * for now, just pass sendfile "-suser@host.domain"
			 * that will cause the sender address to look like
			 * "user@host.domain@OURHOST.oz" when it arrives
			 * at its destination.  Most cases that we care about,
			 * "domain" is "uucp" or "arpa" or something, and
			 * this result is exactly what we want
			 */
			if (q)
				*q = '.';
			continue;
		}
		/*
		 * its got no domain, or one that ends in 'oz'.
		 *
		 * So, we will tell sendfile that the origin was
		 * the host that sendmail told us that the mail
		 * came from, that makes return addresses work.
		 * (Otherwise we would have things like "kre@munnari@mulga"
		 * which is decidedly ugly!)
		 */
		if (q) {
			*q = '.';
			/*
			 * old versions of SunIII only like lower
			 * case, so we better make sure that's what
			 * the "oz" is (it will often be "OZ" in
			 * reality)
			 */
			if (strccmp(d+1, "oz") == 0) {
				d[1] = 'o';
				d[2] = 'z';
			}
		}
		p[-1] = 0;		/* change the -s arg to "-suser" */
		sprintf(org, "-o%s", p);
		*++a = org;		/* and add a "-ohost.domain" arg */
	}
	setuid(0);
	execv("/usr/local/sendfile", ap);
	exit(EX_OSFILE);
}

/*
 * quick & dirty case independant string comparison.
 * will fail for all kinds of cases I don't care about
 */
strccmp(p, q)
	register char *p, *q;
{
	register c;

	while (c = *p++) {
		if ((c ^ *q++) & ~040)
			return (1);
	}
	if (*q)
		return (1);
	return (0);
}
