/*
**	Copyright (c) 1986 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)MatchAction.c	1.2 86/07/14
*/

/*
**	Returns the "action" whose "pattern" matches "string" in "file".
**
**	The file contains lines of the form:-
**		pattern<TAB>action<NL>
**
**	The pattern is a regular expression as recognised by "regexp(3)".
**	White-space in either the pattern or the action must be quoted or escaped.
*/


#include	"global.h"
#include	"debug.h"

extern char	*regcmp(), *regex();


char *
MatchAction(file, string)
	char *		file;
	char *		string;
{
	register char *	cmp;
	register int	i;
	register int	j;
	register char *	fs;
	VarArgs		va;

	Trace3(1, "MatchAction(\"%s\", \"%s\")", file, string);

	if ( file == NULLSTR || string == NULLSTR )
		return NULLSTR;

	if ( (fs = ReadFile(file)) == NULLSTR )
		return NULLSTR;

	NARGS(&va) = 0;

	if ( (i = SplitArg(&va, fs)) > MAXVARARGS )
		Error("Too many patterns (%d) in \"%s\"", i, file);
	else
	for ( j = 0 ; (i -= 2) >= 0 ; j += 2 )
	{
		Trace3(2, "MatchAction: \"%s\" ==> \"%s\"", ARG(&va, j), ARG(&va, j+1));

		if ( (cmp = regcmp(ARG(&va, j), NULLSTR)) == NULLSTR )
		{
			Error("Bad regular expression \"%s\" in \"%s\"", ARG(&va, j), file);
			break;
		}

		if ( regex(cmp, string) != NULLSTR )
		{
			free(cmp);
			cmp = newstr(ARG(&va, j+1));
			FreeArgs(&va);
			free(fs);
			return cmp;
		}

		free(cmp);
	}

	if ( i != -2 )
		Error("Incomplete pattern/action in \"%s\"", file);

	FreeArgs(&va);
	free(fs);
	return NULLSTR;
}
