/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)NodeinPrim.c	1.4 85/02/08
*/

/*
**	Given node index, return true if node is a member of our primary domain,
**	(or there is no primary domain).
*/

#include	"global.h"
#include	"debug.h"
#include	"state.h"

#include	"route.h"


bool
NodeinPrim(index)
	int		index;
{
	register int	i;
	register int	home_prim;

	if ( index == LINK_N_A )
		return false;
	
	if ( index == (NodeCount-1) )
		return true;
	
	if ( (home_prim = RT_NODE(NodeCount-1)->ne_primary) == LINK_N_A )
		return true;

	i = index * DomainCount + home_prim;

	if ( MemberTable[i/8] & (1 << (i%8)) )
		return true;

	return false;
}
