/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID	@(#)Malloc.c	1.3 88/07/26
*/

/*
**	Safe, fast "malloc" for statefile.
*/

#include	"global.h"


static char *	Next;
static char *	End;
static int	Left;
static int	BrkIncr		= 8192;
#define		MININCR		64

#ifndef	ALIGN
#define		ALIGN		sizeof(char *)
#endif
#define		MASK		(ALIGN-1)

extern char *	sbrk();



char *
Malloc(size)
	register int	size;
{
	register char *	cp;
	register int	incr;

	size += MASK;
	size &= ~MASK;

	if ( Left < size )
	{
		for ( incr = BrkIncr ; size > incr ; incr <<= 1 );

		for ( ;; )
		{
			if ( (cp = sbrk(incr)) != (char *)-1 )
				break;

			if ( incr <= MININCR || incr <= size )
				Syserror("no memory for malloc(%d)", size);
			else
				incr >>= 1;
		}

		if ( incr < BrkIncr )
			BrkIncr = incr;

		if ( cp == End )
			Left += incr;
		else
		{
			Left = incr;
			Next = cp;
		}

		End = cp + incr;
	}
				
	cp = Next;
	Next += size;
	Left -= size;
	return cp;
}



char *
Malloc0(size)
	int		size;
{
	return strclr(Malloc(size), size);
}



char *
malloc(size)
	unsigned	size;
{
	return Malloc((int)size);
}



void
free(p)
	char *	p;
{
#	ifdef	lint
	*p = '\0';
#	endif
}



char *
realloc(old, size)
	char *		old;
	unsigned	size;
{
	register char *	new;

	new = Malloc((int)size);
	bcopy(old, new, size);
	return new;
}
