/*
 * sendmail.c
 *
 *	This program takes input of the form
 *		@@mail userlist
 *		message...
 *		@@end
 *	arbitrarily repeated and pokes it into the
 *	ACSnet using
 *
 *		sendfile -amailer -ssender -ohost -brecipient
 *
 *
 *	It has one argument which is the origin pseudo-host
 *	for these messages.
 */

#define	STDIO

#include	"global.h"

char	*usage = "(v2.2)Usage: %s pseudohost\n";
char	* Name;
char	tn[320];
char	tn1[320];		/* name of file to be returned to sender */
char	*argv[320];
char	*host;
char	whofrom[256];
char	wherefrom[256];
char	rtnfrom[200];
char	bwhoto[512];
int	status;
void	finish();

main(ac, av)
int	ac;
char	* av[];
{
	register char	*p;
	register char	**q;
	register int	n;
	char		buf[5120];

	if (ac <= 1)
	{
		fprintf( stderr, usage, av[0] );
		exit(1);
	}
	if ((Name = strrchr(*av, '/')) != NULLSTR)
		Name++;
	else
		Name = *av;

	host = av[1];
	strcpy(tn, "-f/tmp/SUNXXXXXX");
	mktemp(&tn[2]);

	p = buf;

	q = argv;
	q[0] = "sendfile";
	q[1] = "-amailer";
	q[4] = wherefrom;

	strcpy(whofrom, "-s" );
	strcpy(rtnfrom, "-s" );
	strcpy(wherefrom, "-o" );

	while(gets(p) != NULL)
	{
		q[3] = whofrom;
		q[2] = tn;
		if (!eqstring(p, "@@mail"))
			continue;
		/*
		 * first copy input away
		 */
		strcpy(&whofrom[2], "postmaster");
		strcpy(&wherefrom[2], host);
		spool(&tn[2]);
		getargs(p + 6, q + 5);
		showargs( q );
		switch(n = fork())
		{
		case 0:
			setuid(0);	/* trick mail and net */
			close(2);
			creat("/tmp/smailerr", 0666);
			execv("/bin/sendfile", q);
			exit(1);
		default:
			while(wait(&status) != n);
			if (status != 0)
			{
				int	n;
				long	tim;
				char	*ctime();
				char	* ThisNode;
				FILE	*fd, *fd1, *fd2, *fopen();

				printf("\tbad return status from sendfile\n");
				strcpy(tn1,"-f/tmp/SUNXXXXXX");
				mktemp(&tn1[2]);
				if ((fd1 = fopen(&tn1[2],"w")) == NULL)
				{
					perror(&tn1[2]);
					exit(1);
				}
				ThisNode = NodeName();
				time(&tim);
				fprintf(fd1,
					"From postmaster %s", ctime(&tim));
				fprintf(fd1,
					"Subject: undelivered mail returned from %s\n\n",
					ThisNode);
				for (n = 0; n < 75; n++)
					fputc('*', fd1);
				fprintf(fd1,
					"\n\nFailure explanation follows :\n");
				if ((fd = fopen("/tmp/smailerr","r")) == NULL)
					perror("/tmp/smailerr");
				if (fgets(buf,132,fd) != NULL)
				{
					fprintf(fd1, "%s\n", buf);
					printf("\t%s\n", buf);
				}
				for (n = 0; n < 75; n++)
					fputc('*', fd1);
				fprintf(fd1, "\n\n>");
				if ((fd2 = fopen(&tn[2], "r")) == NULL)
				{
					perror(&tn[2]);
					exit(1);
				}
				while (fgets(buf, 132, fd2)!= NULL)
					fprintf(fd1, "%s", buf);
				fclose(fd1);
				fclose(fd2);
				fclose(fd);
				strcat(whofrom, "@");
				strcat(whofrom, host);
				strcpy(&rtnfrom[2], "postmaster");
				strcpy(&wherefrom[2], ThisNode);
				q[3] = rtnfrom;
				q[2] = tn1;
				q[5] = &whofrom[2];
				q[6] = NULL;
				showargs( q );
				switch(n = fork())
				{
				case 0:
					setuid(0);
					execv("/bin/sendfile",q);
					exit(1);
				default:
					while(wait(&status) != n);
					break;
				case SYSERROR:
					printf("\tfork failed for sendfile\n");
				}
				unlink(&tn1[2]);
				unlink("/tmp/smailerr");
				unlink(&tn[2]);
			}
			break;
		case SYSERROR:
			printf("\tfork failed for sendfile\n");
			unlink(&tn[2]);
			return(1);
		}
	}
	unlink(&tn[2]);
	unlink("/tmp/smailerr");
	return 0;
}

spool(file)
char	* file;
{
	register FILE	*f;
	register char	*p;
	int		subject;
	int		from;
	char		buf[512];

	if ((f = fopen(file, "w")) == NULL)
	{
		printf("can't create %s\n", file);
		exit(1);
	}
	p = buf;
	subject = 0;
	from = 0;
	while (gets(p) != NULL)
	{
		if (eqstring(p, "@@end"))
			break;
		if (!from && eqstring(p, "From "))
		{
			register char	*s;

			from++;
			s = p + 5;		/* step over 'From ' */
			while (*s && *s != ' ')
				s++;
			if (*s)
			{
				*s++ = 0;
				strcpy(&whofrom[2], p + 5);
				fprintf(f, "%s@%s %s\n", p, host, s);
				continue;
			}
			else
				strcpy(&whofrom[2], p + 5);
		}
		if (!subject && eqstring(p, "Subject: "))
			subject++;
		fputs(p, f);
		putc('\n', f);
	}
	(void)fclose(f);
	if (!subject)
	{
		register FILE	*nf;

		f = fopen(file, "r");
		unlink(file);
		nf = fopen(file, "w");
		fgets(p, 512, f);	/* from line */
		fputs(p, nf);
		fputs("Subject: No subject!\n\n", nf);
		while(fgets(p, 512, f))
			fputs(p, nf);
		fclose(f);
		fclose(nf);
	}
}

eqstring(s1, s2)
register char	* s1;
register char	* s2;
{
	while (*s2)
		if (*s1++ != *s2++)
			return 0;
	return 1;
}

getargs(s, argv)
register char *s;
register char *argv[];
{

/*	copy names of recipients from s (space-separated) into bwhoto
	preceded by -b, and store pointers in argv
*/	

	register char *t;

	t = bwhoto;

	for (;;)
	{
		while (*s && *s == ' ')
			s++;
		if (!*s)
			break;
		*argv++ = t;
		*t++ = '-'; *t++ = 'b';
		while (*s && *s != ' ')
			*t++ = *s++;
		*t++ = 0;
		if (!*s)
			break;
	}
	*argv++ = 0;
}

showargs( q )
char	**q;
{
	printf(">");
	while (*q != 0)
		printf("%s ", *q++);
	printf("\n");
}

void
finish(error)
int	error;
{
	(void)exit (error);
}
