/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)DestReached.c	1.1 84/06/12
*/

/*
**	Check if HomeNode is in address,
**	if so, remove HomeNode from list if necessary, return true,
**	otherwise return false.
*/

#include	"global.h"

#include	"address.h"
#include	"debug.h"
#include	"header.h"



bool
DestReached(handler)
	char **		handler;
{
	register char *	cp1;
	register char *	cp2;
	register char *	err;
	static char *	mesg	= "bad %s address \"%s\"";

	cp1 = HdrDest;

	Trace2(2, "DestReached with \"%s\"", cp1);

	switch ( *cp1++ )
	{
	case ATYP_BROADCAST:
		if ( *cp1 == '\0' )
			return true;

		if ( *cp1++ == DOMAIN_SEP )
		{
			if ( *cp1 == ATYP_BROADCAST )
			{
				if ( cp1[1] == '\0' )
					return true;
			}
			else
				return HomeDomain(cp1, handler);
		}

		err = "broadcast";
		break;

	case ATYP_MULTICAST:
		for ( ; ; )
		{
			if ( (cp2 = strchr(cp1, ATYP_MULTICAST)) == NULLSTR )
			{
				if ( cp1 == &HdrDest[1] )
				{
					err = "multicast";
					goto err_out;
				}
			}
			else
				*cp2 = '\0';

			if ( HomeAddress(cp1, handler) )
			{
				*--cp1 = '\0';

				if ( cp2 != NULLSTR )
				{
					if
					(
						cp1 == HdrDest
						&&
						strchr(cp2+1, ATYP_MULTICAST) == NULLSTR
					)
						cp2++;
					else
						*cp2 = ATYP_MULTICAST;
				}
				else
				if ( strchr(&HdrDest[1], ATYP_MULTICAST) == NULLSTR )
				{
					cp1 = HdrDest;
					cp2 = cp1+1;
				}
				else
					return true;

				(void)strcpy(cp1, cp2);

				return true;
			}

			if ( (cp1 = cp2) == NULLSTR )
				break;
			else
				*cp1++ = ATYP_MULTICAST;
		}

		return false;
	
	case ATYP_EXPLICIT:
		if ( (cp2 = strchr(cp1, ATYP_EXPLICIT)) == NULLSTR )
		{
			err = "explicit routing";
			break;
		}

		*cp2++ = '\0';

		while ( HomeAddress(cp1, handler) )
		{
			if ( cp2 == NULLSTR )
			{
				HdrDest[0] = '\0';
				return true;
			}

			if ( strchr(cp2, ATYP_EXPLICIT) == NULLSTR )
				cp1--;

			(void)strcpy(cp1, cp2);

			if ( (cp2 = strchr(cp1, ATYP_EXPLICIT)) != NULLSTR )
				*cp2++ = '\0';
		}

		if ( cp2 != NULLSTR )
			*--cp2 = ATYP_EXPLICIT;

		return false;

	default:
		if ( !HomeAddress(--cp1, handler) )
			return false;

		*cp1 = '\0';
		return true;
	}

err_out:

	Error(mesg, err, HdrDest);
	HdrDest[0] = '\0';
	return false;
}
