/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)SetFthTo.c	1.1 84/06/12
*/

/*
**	Make FthTo list.
**
**	It may take the following form:
**
**	user[<FTH_USEP>user...][<FTH_UDEST>nodelist][<FTH_UDSEP>...]
*/

#include	"global.h"
#include	"ftheader.h"


char		FthToRestricted[]	= { FTH_USEP, FTH_UDEST, FTH_UDSEP, '\0' };

extern void	QuoteChars();



void
SetFthTo()
{
	register FthUlist *	up;
	register FthUlist *	nup;
	register char *		cp;
	register int		length;

	if ( NFthUsers == 0 )
		Error("Need at least one destination user");

	for ( up = FthUsers, length = 0 ; up != (FthUlist *)0 ; up = up->u_next )
	{
		length += strlen(up->u_name);

		if ( up->u_dest != NULLSTR )
			length += strlen(up->u_dest);
	}

	FthTo = cp = Malloc(length + NFthUsers*3);

	for ( up = FthUsers ; up != (FthUlist *)0 ; up = nup )
	{
		register char *	ocp = cp;

		cp = strcpyend(cp, up->u_name);

		QuoteChars(ocp, FthToRestricted);

		if
		(
			(nup = up->u_next) != (FthUlist *)0
			&&
			nup->u_dest == up->u_dest
		)
		{
			*cp++ = FTH_USEP;
		}
		else
		{
			if ( up->u_dest != NULLSTR )
			{
				*cp++ = FTH_UDEST;
				cp = strcpyend(cp, up->u_dest);
			}

			if ( nup != (FthUlist *)0 )
				*cp++ = FTH_UDSEP;
		}
	}
}
