/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)ExecPipe.c	1.6 84/10/30
*/

/*
**	pipe(), fork(), execve() sequence.
*/

#define	FILE_CONTROL
#define	RECOVER
#define	STDIO

#include	"global.h"

#include	"debug.h"

#include	<signal.h>

#define	TOCHILD		1
#define	CHILD0		0


static int	EP_fd;
static VarArgs *EP_cmd;
static int	EP_pid;
static int	(*EP_sig)();

extern Time_t	Time;


FILE *
ExecPipe(args)
	register VarArgs *args;
{
	register int	i;
	char *		errfile;
	int		p[2];

	DODEBUG(if(NARGS(args)>MAXVARARGS)Fatal("MAXVARARGS"));

	ARG(args, NARGS(args)) = NULLSTR;

	while ( pipe(p) == SYSERROR )
		Syserror("Can't pipe");

	if ( !ErrorTty(&EP_fd) )
	{
		errfile = UniqueName(newstr(TMPDIR(error.file....)), (long)0, Time);

#		if	defined(O_CREAT)
		while ( (EP_fd = open(errfile, O_RDWR|O_CREAT, 0600)) == SYSERROR )
#		else	defined(O_CREAT)
		while
		(
			(EP_fd = creat(errfile, 0600)) == SYSERROR
			||
			close(EP_fd) == SYSERROR
			||
			(EP_fd = open(errfile, O_RDWR)) == SYSERROR
		)
#		endif	defined(O_CREAT)
			Syserror("Can't creat \"%s\"", errfile);

		(void)unlink(errfile);
		free(errfile);
	}

	for ( ;; )
	{
		switch ( EP_pid = fork() )
		{
		case SYSERROR:
			Syserror("Can't fork");
			continue;

		case 0:
			Recover(ert_finish);

			DODEBUG(EchoArgs(NARGS(args), &ARG(args, 0)));

			if ( p[CHILD0] != 0 )
			{
				(void)close(0);
				if ( dup(p[CHILD0]) != 0 )
					exit(100);
			}

			for ( i = 1 ; i <= 2 ; i++ )
				if ( i != EP_fd )
				{
					(void)close(i);
					if ( dup(EP_fd) != i )
						exit(100+i);
				}

			for ( i = 3 ; close(i) != SYSERROR ; i++ );

			for ( ;; )
			{
				(void)execve(ARG(args, 0), &ARG(args, 0), (char **)0);
				Syserror("Cannot execve \"%s\"", ARG(args, 0));
			}
		}

		(void)close(p[CHILD0]);

		EP_sig = signal(SIGPIPE, SIG_IGN);
		EP_cmd = args;

		return fdopen(p[TOCHILD], "w");
	}
}



char *
ExPipeClose(fd)
	FILE *		fd;
{
	register int	i;
	int		status;
#	if	DEBUG >= 1
	char *		errfile;
#	endif	DEBUG >= 1

	(void)fclose(fd);
	(void)signal(SIGPIPE, EP_sig);

	while ( (i = wait(&status)) != EP_pid )
		if ( i == SYSERROR )
		{
			Syserror("Lost child");
			return NULLSTR;
		}

	if ( ErrorTty((int *)0) )
		return NULLSTR;

	if ( status )
		return GetErrFile(EP_cmd, status, EP_fd);

#	if	DEBUG >= 1
	if
	(
		Traceflag > 0
		&&
		(errfile = GetErrFile(EP_cmd, 0, EP_fd)) != NULLSTR
	)
	{
		Trace(1, errfile);
		free(errfile);
	}
	else
#	endif	DEBUG >= 1

	(void)close(EP_fd);

	return NULLSTR;
}
