/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)InList.c	1.1 84/06/12
*/

/*
**	Return TRUE if arg1 is in list.
**
**	"list" may be any sequence of words separated by any of '\n', ' ', or '\t',
**	in any number of arguments terminated by a NULLSTR.
**
**	If "list" is a full path name, and the file can be read,
**	then the list will be read from the file.
*/

#define	FILE_CONTROL
#define	STAT_CALL

#include	"global.h"
#include	"debug.h"


static bool	in_list();



/*VARARGS3*/
bool
InList(arg1, list, end)
	char *		arg1;
	char *		list;
	char *		end;	/* Not used */
{
	char **		cpp;
	register char *	cp;
	register int	count;

	Trace3(2, "InList \"%s\" \"%s\"", arg1, list);

	for ( count = 0, cpp = &list ; (cp = ARGS_OFF_STACK(cpp)) != NULLSTR ; count++ )
	{
		if ( in_list(arg1, (cp = newstr(cp))) )
		{
			free(cp);
			return true;
		}

		free(cp);
	}

	Trace2(2, "InList trying file \"%s\"", list);

	if ( count == 1 && list[0] == '/' && (cp = ReadFile(list)) != NULLSTR )
	{

		if ( in_list(arg1, cp) )
		{
			free(cp);
			return true;
		}

		free(cp);
	}

	Trace1(2, "InList no match");

	return false;
}



static bool
in_list(el, lp)
	char *		el;
	register char *	lp;
{
	register char *	cp;
	static char *	space = " \t\n";

	do
	{
		if ( (cp = strpbrk(lp, space)) != NULLSTR )
		{
			*cp++ = '\0';
			cp += strspn(cp, space);
		}
		
		if ( strcmp(el, lp) == STREQUAL )
		{
			Trace2(3, "in_list match word \"%s\"", lp);
			return true;
		}
	}
		while ( (lp = cp) != NULLSTR );

	return false;
}
