/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
*/

static char	sccsid[]	= "@(#)reporter.c	1.8 85/02/08";

/*
**	Process news items from message received from network.
**
**	Pump news into network with:-
**		"sendfile -NRSareporter -d<dest-list> -t600000 -e<cmd> <item>"
**
**	You will need to make the file that NEWSCMDS refers to (well, not
**	need, it will work without as long as the command execution
**	stuff isn't used) - eg: /usr/spool/ACSnet/_lib/newscmds - format is
**
**		cmd<tab>full-path[<space>arg ...]
**
**	(that is, command name (as it will be passed to '-e' arg to
**	sendfile), followed by a tab (or more than one) followed
**	by a full path name for that command, optionally followed
**	by args to the command, preceded by spaces).
*/

#define	FILE_CONTROL
#define	STAT_CALL
#define	STDIO

#include	"global.h"

#include	"debug.h"
#include	"header.h"
#include	"spool.h"

#include	<errno.h>

/*
**	Parameters set from arguments.
*/

bool	Broadcast;		/* Message has been everywhere */
char *	CommandsFile;		/* Commands of files to be pre-pended to Message */
char *	HomeNode;		/* Name of this node */
char *	LinkNode;		/* Message arrived from this node */
char *	Message;		/* Message */
char *	Name;			/* Program invoked name */
char *	SourceNode;		/* Message originated at this node */
int	Traceflag;		/* Global tracing control */

/*
**	Miscellaneous
*/

char *	DataName;		/* Used by ExpandArgs() */
int	Pid;			/* Used by UniqueName() in Exec...() */
char *	SenderName;		/* Used by ExpandArgs() */
Time_t	Time;			/* Used by UniqueName() in Exec...() */
char *	UserName;		/* Used by ExpandArgs() */

#define	Fprintf		(void)fprintf
#define	free(A)

void	finish(), sendinfiles();



int
main(argc, argv)
	register int	argc;
	register char *	argv[];
{
	register int	fd;
	char *		cp;

	if ( (Name = strrchr(*argv, '/')) != NULLSTR )
		Name++;
	else
		Name = *argv;

	Pid = getpid();
	Time = time((long *)0);

	DataName = SenderName = UserName = "news";

	while ( --argc > 0 )
	{
		if ( **++argv == '-' )
		{
			register int	c;

			while ( c = *++*argv )
			{
				switch ( c )
				{
				case 'B':
					Broadcast = true;
					continue;

				case 'T':
					if ( (Traceflag = atol(++*argv)) == 0 )
						Traceflag = 1;
					break;

				case 'c':
					CommandsFile = ++*argv;
					goto break2;

				case 'd':
					DataLength = atol(++*argv);
					break;

				case 'e':
					HdrEnv = ++*argv;
					goto break2;

				case 'h':
					HomeNode = ++*argv;
					goto break2;

				case 'l':
					LinkNode = ++*argv;
					goto break2;

				case 's':
					SourceNode = ++*argv;
					goto break2;

				default:
					Trace2(1, "unrecognised flag '%c'", c);
					goto break2;
				}

				while ( (c = **argv) <= '9' && c >= '0' )
					++*argv;
				--*argv;
			}

break2:			;
		}
		else
		if ( Message != NULLSTR )
			Error("only one message allowed");
		else
			Message = *argv;
	}

	if ( (cp = GetEnv(ENV_RETURNED)) != NULLSTR )
	{
		free(cp);
		Error("news returned from \"%s\"", SourceNode);
	}

	if ( (cp = GetEnv(ENV_ACK)) != NULLSTR )
	{
		free(cp);
		Error("news acknowledged from \"%s\"", SourceNode);
	}

	while ( (fd = open(Message, O_READ)) == SYSERROR )
		Syserror("Can't open \"%s\"", Message);

#	ifdef	NEWSEDITOR
	sendinfiles(fd);
#	endif	NEWSEDITOR

	return 0;
}



/*
**	Called from the errors routines to cleanup
*/

void
finish(error)
	int	error;
{
	(void)exit(error);
}



#ifdef	NEWSEDITOR

/*
**	Pass data on to the local news editor
*/

void
sendinfiles(ifd)
	int		ifd;
{
	register char *	cp;
	register int	n;
	register int	r;
	FILE *		fd;
	char *		errs;
	VarArgs		va;
	bool		piperr;
	char		buf[BUFSIZ];

	if ( (cp = GetEnv(ENV_HANDLER_FLAGS) ) == NULLSTR)
		FIRSTARG(&va) = NEWSEDITOR;
	else
	{
		register char *	np;
		register char * sp;

		if ( (sp = strpbrk(cp, "\t ")) != NULLSTR )
			*sp++ = '\0';

		NARGS(&va) = 0;

#		ifdef	NEWSCMDS

		if ( (fd = fopen(NEWSCMDS, "r") ) == NULL)
		{
			Error("No news commands file \"%s\"", NEWSCMDS);
			return;
		}

		while ( fgets(buf, sizeof buf, fd) != NULL )
		{
			if (buf[0] == '#')
				continue;

			if ( (np = strchr(buf, '\n')) != NULLSTR )
				*np = '\0';

			if ( (np = strchr(buf, '\t')) == NULLSTR )
				continue;

			*np++ = '\0';

			if ( strcmp(cp, buf) != STREQUAL )
				continue;

			SplitArg(&va, np);

			break;
		}

		if ( feof(fd) )
		{
			fclose(fd);
			Error("Unknown news command \"%s\"", cp);
			return;
		}

		fclose(fd);

#		else  NEWSCMDS

		FIRSTARG(&va) = cp;

#		endif NEWSCMDS

		if ( sp != NULLSTR )
			SplitArg(&va, sp);

		free(cp);
	}

#	ifdef	NEWSARGS
	ExpandArgs(&va, NEWSARGS, NULLSTR);
#	endif	NEWSARGS

	/*
	** News takes too long to hold up the NNdaemon channel
	** until its finished being processed.  Really, we should
	** move the files to some news input spool directory, and
	** run a daemon over that, but for now ...
	**
	** We have the message file open, so it won't hurt if
	** receiver deletes it.
	*/

	while ( (n = fork()) == SYSERROR )
		Syserror("Can't fork");

	if ( n != 0 )
		return;	/* Parent returns */

	fd = ExecPipe(&va);

	/*
	** We're lucky here - this never happens, if it did, there
	** would be a race, receiver is busily deleting this file
	** just as we're attempting to open it.  Not nice!
	*/
	if ( CommandsFile != NULLSTR )
		CopyFromComFile(CommandsFile, fileno(fd), "pipe", NULLSTR);

	(void)lseek(ifd, (long)0, 0);

	piperr = false;

	while
	(
		(r = DataLength > sizeof buf ? sizeof buf : DataLength) > 0
		&&
		(n = read(ifd, buf, r)) > 0
	)
	{
		DataLength -= n;
		cp = buf;

		while ( (r = write(fileno(fd), cp, n)) != n )
		{
			if ( r == SYSERROR )
			{
				if ( errno == EPIPE )
				{
					piperr = true;
					goto break2;
				}

				Syserror("Can't write to pipe!");
			}
			else
			{
				cp += r;
				n -= r;
			}
		}
	}

	if ( n == SYSERROR )
		Syserror("Can't read message \"%s\"", Message);

break2:
	if
	(
		(errs = ExPipeClose(fd)) != NULLSTR
		||
		(piperr && (errs = newstr("broken pipe")))
	)
	{
		Error(errs);
		free(errs);
	}
}

#endif	NEWSEDITOR
