/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)AtHome.c	1.6 85/05/04
*/

/*
**	Return 'true' if 'HomeNode' in destination list.
**
**	(Used in FthTo list searches.)
*/

#include	"global.h"
#include	"address.h"



bool
AtHome(s)
	register char *	s;
{
	register char *	a;
	char *		handler;	/* Not used */

	if ( (a = strrchr(s, ATYP_EXPLICIT)) != NULLSTR )
		return AtHome(a+1);

	while ( (a = strchr(s, ATYP_MULTICAST)) != NULLSTR )
	{
		*a = '\0';

		if ( AtHome(s) )
		{
			*a = ATYP_MULTICAST;
			return true;
		}

		*a++ = ATYP_MULTICAST;
		s = a;
	}

	if
	(
		s[0] == ATYP_BROADCAST
		&&
		(
			s[1] == '\0'
			||
			(
				s[1] == DOMAIN_SEP
				&&
				(
					(
						s[2] == ATYP_BROADCAST
						&&
						s[3] == '\0'
					)
					||
					HomeDomain(&s[2], &handler, EXCL_HIER)
				)
			)
		)
	)
		return true;
	
	if ( HomeAddress(s, &handler, INCL_HIER) )
		return true;

	return false;
}
