/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)CopyFile.c	1.1 84/06/12
*/

/*
**	Copy contents of "file" to "ofd".
*/

#define	FILE_CONTROL
#define	STDIO

#include	"global.h"


void
CopyFile(file, ofd, ofile)
	char *		file;
	int		ofd;
	char *		ofile;
{
	register int	ifd;
	register int	r;
	char		buf[BUFSIZ];

	while ( (ifd = open(file, O_READ)) == SYSERROR )
		Syserror("Can't read \"%s\"", file);
	
	while ( (r = read(ifd, buf, sizeof buf)) > 0 )
	{
		register char *	cp = buf;
		register int	w;

		while ( (w = write(ofd, cp, r)) != r )
		{
			if ( w == SYSERROR )
				Syserror("Can't write \"%s\"", ofile);
			else
			{
				cp += w;
				r -= w;
			}
		}
	}

	(void)close(ifd);
}
