/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)MatchString.c	1.3 85/05/14
*/

/*
**	Find "match" in "string".
**	Return pointer to start of match, or NULLSTR.
**
**	Boyd & Moore algorithm.
*/

#include	"global.h"

#define	ASIZE	0100
#define	AMASK	(ASIZE-1)



char *
MatchString(string, match)
	register char *	string;
	register char *	match;
{
	register int	i;
	register int	j;
	short		a[ASIZE];

	if ( string == NULLSTR || match == NULLSTR )
		return NULLSTR;

	for ( i = 0 ; match[i] != '\0' ; i++ )
		if ( string[i] == '\0' )
			return NULLSTR;

	for ( j = 0 ; j < ASIZE ; j++ )
		a[j] = i;

	for ( j = 0 ; --i > 0 ; j++ )
		a[match[j]&AMASK] = i;

	for ( ;; )
	{
		i = j;

		while ( match[i] == string[i] )
			if ( --i < 0 )
				return string;

		i = a[string[i]&AMASK];

		do
			if ( (++string)[j] == '\0' )
				return NULLSTR;
		while
			( --i > 0 );
	}
}
