/*
**	uses strpbrk and strspn to break string into tokens on
**	sequentially subsequent calls. Returns NULLSTR at end.
**	`subsequent' calls are calls with first argument NULL.
**
**	SCCSID @(#)strtok.c	1.2 84/07/16
*/

#define	NULLSTR	(char *) 0

extern int	strspn();
extern char	*strpbrk();


char *
strtok(string, sepset)
	char *		string;
	char *		sepset;
{
	register char *	p;
	register char *	q;

	static char *	savept;

	if ( string == NULLSTR )
		p = savept;
	else
		p = string;

	if ( p == 0 )
		return NULLSTR;

	q = p + strspn(p, sepset);

	if ( *q == '\0' )
		return NULLSTR;

	if ( (p = strpbrk(q, sepset)) == NULLSTR )
		savept = 0;
	else
	{
		*p++ = '\0';
		savept = p + strspn(p, sepset);
	}

	return q;
}
