/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)GetLink.c	1.2 85/02/20
*/

/*
**	Return link with requested index if it exists, else NULLSTR.
*/

#include	"global.h"
#include	"debug.h"
#include	"state.h"

#include	"route.h"


bool
GetLink(index, nlp)
	register int		index;
	register NodeLink *	nlp;
{
	register int		n;

	Trace2(1, "GetLink %d", index);

	if ( RouteBase == NULLSTR )
		if ( !ReadRoute() )
			return false;

	if ( index >= LinkCount )
		return false;

	nlp->nl_link = index;
	nlp->nl_flags = RT_LINK(index)->le_flags;
	nlp->nl_index = RT_LINK(index)->le_index;
	nlp->nl_name = RT_NODE(nlp->nl_index)->ne_name;
	nlp->nl_domind = RT_NODE(nlp->nl_index)->ne_primary;

	if ( n = RT_LINK(index)->le_handlers[PT_MSG] )
		nlp->nl_spooler = &Strings[n];
	else
		nlp->nl_spooler = NULLSTR;

	if ( n = RT_LINK(index)->le_handlers[PT_CON] )
		nlp->nl_connector = &Strings[n];
	else
		nlp->nl_connector = NULLSTR;

	if ( n = RT_LINK(index)->le_caller )
		nlp->nl_caller = &Strings[n];
	else
		nlp->nl_caller = NULLSTR;

	return true;
}
