/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
*/

static char	sccsid[]	= "@(#)ACSnet_VMS.c	1.2	84/10/02";

/*
**	Process messages destined for VMS mail spooling.
*/

#define	FILE_CONTROL
#define	STAT_CALL
#define	STDIO

#include	"global.h"

#ifdef	VMS_NET
#include	"address.h"
#include	"debug.h"
#include	"ftheader.h"
#include	"handlers.h"
#include	"header.h"
#include	"spool.h"
#include	"sub_proto.h"

/*
**	Parameters set from arguments.
*/

char *	CommandsFile;		/* Commands for files to be pre-pended to Message */
char *	Destination;		/* New destination */
Time_t	ElapsedTime;		/* Travel time for last link */
Time_t	StartTime;		/* Time this message arrived */
char *	HomeNode;		/* Name of this node */
char *	LinkNode;		/* Message destined to leave by this node */
char *	ThisDest;		/* Current destination of this message */
char *	Message;		/* Message */
char *	Name;			/* Program invoked name */
char *	Source;			/* New source address */
int	Traceflag;		/* Global tracing control */

/*
**	ACSnet ftp handler types
*/

typedef enum
{
	mail, file, print
}
	FTP_t;

/*
**	Miscellaneous
*/

bool	Ack;			/* This message is an acknowledgment */
char *	AckMessage	= WORKDIR(ack....message);
FthUlist *AckUsers;		/* List of recipients for sendack() */
char	Buf[BUFSIZ];		/* Transfer buffer */
char **	DestArg;		/* Address of destination in arg list */
int	MesgFd;			/* File descriptor for Message */
int	Pid;			/* Process id */
char	ProtoType[2];		/* Header protocol type */
bool	Returned;		/* True if invoked for returned message */
Time_t	Time;			/* Invocation time */
VarArgs	VA;			/* Arguments for 'net' */

#define	Fprintf		(void)fprintf

void	ack_message(), copy(), vms(), ret_message(), sendack();
bool	vms1(), vms2();



int
main(argc, argv)
	register int	argc;
	register char *	argv[];
{
	HdrReason	reason;
	char *		cp;

	if ( (Name = strrchr(*argv, '/')) != NULLSTR )
		Name++;
	else
		Name = *argv;

	Time = time((long *)0);
	Pid = getpid();

	while ( --argc > 0 )
	{
		if ( **++argv == '-' )
		{
			register int	c;

			while ( c = *++*argv )
			{
				switch ( c )
				{
				case 'T':
					if ( (Traceflag = atol(++*argv)) == 0 )
						Traceflag = 1;
					break;

				case 'a':
					Destination = ++*argv;
					goto break2;

				case 'c':
					CommandsFile = ++*argv;
					goto break2;

				case 'h':
					HomeNode = ++*argv;
					goto break2;

				case 'l':
					LinkNode = ++*argv;
					goto break2;

				case 's':
					Source = ++*argv;
					goto break2;

				case 't':
					ElapsedTime = atol(++*argv);
					break;

				default:
					Error("unrecognised flag '%c'", c);
				}

				while ( (c = **argv) <= '9' && c >= '0' )
					++*argv;
				--*argv;
			}

break2:			;
		}
		else
		if ( Message != NULLSTR )
			Error("only one message allowed");
		else
			Message = *argv;
	}

	while ( (MesgFd = open(Message, O_READ)) == SYSERROR )
		Syserror("Can't open \"%s\"", Message);

	if ( (reason = ReadHeader(MesgFd)) != hr_ok )
		Error("Header %s error", HeaderReason(reason));

	if ( Source != NULLSTR )
		HdrSource = Source;
	if ( Destination != NULLSTR )
		HdrDest = Destination;
	StartTime = Time - (atol(HdrTt) + ElapsedTime);

	if ( (cp = GetEnv(ENV_ACK)) != NULLSTR )
	{
		free(cp);
		Ack = true;
	}

	if ( (cp = GetEnv(ENV_RETURNED)) != NULLSTR )
	{
		free(cp);
		Returned = true;
	}

	vms();

	(void)unlink(Message);

	return 0;
}



/*
**	Called from the errors routines to cleanup
*/

void
finish(error)
	int	error;
{
	(void)unlink(AckMessage);
	(void)exit(error);
}



/*
**	Look at header to find out what sort of message,
**	and call 'net1' once for each destination.
*/

void
vms()
{
	FthReason	reason;

	FIRSTARG(&VA) = VMS_NET;	/* Should be 'vms' */
	NEXTARG(&VA) = LinkNode;
	NEXTARG(&VA) = newstr("");	/* Place holder for destination */
	DestArg = &LASTARG(&VA);

	if ( strcmp(HdrHandler, STATEHANDLER) == STREQUAL )
		return;
	else
	if ( !Returned && !Ack && strcmp(HdrHandler, MAILHANDLER) != STREQUAL )
	{
		Error("handler \"%s\" not available via VMS", HdrHandler);
		return;
	}
	
	if
	(
		(reason = ReadFtHeader(MesgFd, DataLength, !Returned)) != fth_ok
		||
		(reason = GetFthFiles()) != fth_ok
	)
		Error("File transfer header \"%s\" error", FTHREASON(reason));

	if ( HdrDest[0] == ATYP_BROADCAST )
		(void)vms1(LinkNode);
	else
		(void)ExDests(HdrDest, vms1);

	if ( FthType[0] & FTH_ACK )
		sendack();
}

/*
**	Pass copies of message on for one destination.
*/

bool
vms1(dest)
	char *		dest;
{
	register int	i;
	register char *	save_home = HomeNode;

	Trace2(2, "vms1 \"%s\"", dest);

	HomeNode = dest;	/* For benefit of AtHome() */

	if (strcmp(dest, LinkNode) == STREQUAL)
		ThisDest = NULLSTR;
	else
		ThisDest = dest;
	
	for ( i = 0 ; vms2(i++) ; );

	HomeNode= save_home;

	return true;
}

/*
**	Mail sender. Send each item for each user at HomeNode.
*/

bool
vms2(index)
	int			index;
{
	register int		i;
	register FthUlist *	up;
	register FthFD_p	fp;
	register int		user;
	register int		file;
	register long		start;

	Trace2(2, "vms2 %d", index);

	if ( index == 0 )
	{
		/*
		**	First time for this destination.
		*/

		FthToFree();

		if ( Ack || Returned )
		{
			FthUsers = Talloc(FthUlist);
			FthUsers->u_next = (FthUlist *)0;
			FthUsers->u_name = newstr(FthFrom);
			FthUsers->u_dest = NULLSTR;
			NFthUsers = 1;
		}
		else
		if ( GetFthTo() == 0 )
		{
			Error("Unrecognisable address \"%s\"", FthTo);
			return false; /* Shouldn't happen! */
		}
	}

	file = index % NFthFiles;
	user = index / NFthFiles;

	/*
	**	Find file and user, and copy file to 'fd'.
	*/

	for ( i = 0, start = 0, fp = FthFiles ; fp != (FthFD_p)0 ; fp = fp->f_next, i++ )
	{
		if ( i == file )
		{
			for ( i = 0, up = FthUsers ; up != (FthUlist *)0 ; up = up->u_next, i++ )
			{
				if ( i == user )
				{
					copy(fp, up, start);

					if ( (FthType[0] & FTH_ACK) && file == 0 )
					{
						char *	name = up->u_name;

						up = Talloc(FthUlist);
						up->u_name = name;
						up->u_dest = HomeNode;
						up->u_next = AckUsers;
						AckUsers = up;
					}

					return (bool)(index != (NFthUsers*NFthFiles-1));
				}
			}

			DODEBUG(Fatal1("Program bug, NFthUsers < 'user'"));

			return false;
		}

		if
		(
			CommandsFile == NULLSTR
			||
			!(fp->f_mode & FTH_NOT_IN_MESG)
		)
			start += fp->f_length;
	}

	DODEBUG(Fatal1("Program bug, NFthFiles < 'file'"));

	return false;
}



/*
**	Copy a file for a user to output.
*/

void
copy(fp, up, start)
	FthFD_p		fp;
	FthUlist *	up;
	long		start;
{
	register char *	cp;
	register int	n;
	register int	r;
	register long	l;
	register FILE *	fd;

	if (ThisDest == NULLSTR)
		cp = newstr(up->u_name);
	else
		cp = concat(ThisDest, "!", up->u_name, NULLSTR);

	fd = ExecPipe(&VA);

	Fprintf(fd, "@@mail %s\n", cp);
	free(cp);

	if ( Ack || Returned )
		Fprintf(fd, "From ACSnet %s", ctime(&StartTime));

	if ( Ack )
		ack_message(fd, fp);
	else
	{
		if ( Returned )
			ret_message(fd, fp);

		(void)fflush(fd);

		if
		(
			CommandsFile != NULLSTR
			&&
			(fp->f_mode & FTH_NOT_IN_MESG)
		)
			CopyFromComFile(CommandsFile, fileno(fd), "pipe", fp->f_name);
		else
		{
			if ( lseek(MesgFd, start, 0) != start )
				Syserror("Can't seek \"%s\"", Message);

			for
			(
				l = fp->f_length ;
				(r = l > sizeof Buf ? sizeof Buf : l) > 0
				&&
				(n = read(MesgFd, Buf, r)) > 0 ;
			)
			{
				l -= n;
				cp = Buf;

				while ( (r = write(fileno(fd), cp, n)) != n )
				{
					if ( r == SYSERROR )
						Syserror("Can't write to pipe");
					else
					{
						cp += r;
						n -= r;
					}
				}
			}

			if ( n == SYSERROR )
				Syserror("Can't read \"%s\"", Message);
		}
	}

	Fprintf(fd, "@@end\n");

	if ( (cp = ExPipeClose(fd)) != NULLSTR )
	{
		Error(cp);
		free(cp);
	}
}



/*
**	Make up message for returned files.
*/

void
ret_message(fd, fp)
	FILE *		fd;
	FthFD_p		fp;
{
	register char *	cp;
	register int	i;

	Fprintf
	(
		fd, 
		"Subject: Undelivered mail returned from %s\n\n",
		HdrSource
	);


	for ( i = 0 ; i < 79 ; i++ )
		putc('*', fd);

	Fprintf
	(
		fd,
		"\nMAIL \"%s\" SENT TO \"%s\" RETURNED FROM \"%s\"\n",
		fp->f_name,
		FthTo,
		HdrSource
	);

	if ( (cp = GetEnv(ENV_ERR1)) != NULLSTR )
	{
		Fprintf(fd, "\nFailure explanation follows :-\n");
		Fprintf(fd, "%s\n", cp);
		free(cp);
	}

	for ( i = 0 ; i < 79 ; i++ )
		putc('*', fd);

	Fprintf(fd, "\n\n");
}



/*
**	Notify sender of acknowledgement.
*/

void
ack_message(fd, fp)
	FILE *		fd;
	FthFD_p		fp;
{
	Fprintf
	(
		fd,
		"Subject: Acknowledgement received for %s sent to %s at %s\n\n",
		fp->f_name,
		FthTo,
		HdrSource
	);

	Fprintf
	(
		fd,
		"The following item has been delivered to %s!%s (VMS).\n  Mode       Size   Modify time   Name\n",
		FthTo,
		HdrSource
	);

	Fprintf
	(
		fd,
		"  0%3o %10ld %.15s %s\n",
		fp->f_mode,
		fp->f_length,
		ctime(&fp->f_time)+4,
		fp->f_name
	);
}



/*
**	Send an acknowledgement message to source.
*/

void
sendack()
{
	register FthFD_p	fp;
	register long		size;
	register char *		errs;
	int			fd;
	VarArgs			va;

	HdrEnv = MakeEnv(ENV_ACK, NULLSTR, NULLSTR);

	HdrDest = HdrSource;
	HdrSource = HomeNode;

	Time = time((long *)0);

	FthUsers = AckUsers;

	SetFthTo();

	for ( fp = FthFiles ; fp != (FthFD_p)0 ; fp = fp->f_next )
		fp->f_time = Time;

	SetFthFiles();

	while ( (fd = creat(UniqueName(AckMessage, (long)0, Time), 0600)) == SYSERROR )
		Syserror("Can't creat \"%s\"", AckMessage);

	while ( (size = WriteFtHeader(fd, (long)0, false, false)) == SYSERROR )
		Syserror("Can't write \"%s\"", AckMessage);

	ProtoType[0] = FTP;
	HdrSubpt = ProtoType;

	while ( WriteHeader(fd, size, 0) == SYSERROR )
		Syserror("Can't write \"%s\"", AckMessage);
	
	(void)close(fd);

	FIRSTARG(&va) = RECEIVER;
	NEXTARG(&va) = concat("-h", HomeNode, NULLSTR);
	NEXTARG(&va) = AckMessage;

	if ( (errs = Execute(&va)) != NULLSTR )
	{
		Error("Acknowledgement failed;\n%s\n", errs);
		free(errs);
		(void)unlink(AckMessage);
	}
}



#else	VMS_NET
main()
{
	exit (1);
}
#endif	VMS_NET
