: '@(#)install.sh	1.16	10/29/86'

if test "$#" != 6
then
	echo "usage: $0 spooldir libdir bindir nuser ngroup ostype"
	exit 1
fi
SPOOLDIR=$1
LIBDIR=$2
BINDIR=$3
NEWSUSR=$4
NEWSGRP=$5
OSTYPE=$6

: Get name of local system
case $OSTYPE in
	usg)	SYSNAME=`uname -n`
		if test ! -d $LIBDIR/history.d
		then
			mkdir $LIBDIR/history.d
			chown $NEWSUSR $LIBDIR/history.d
			chgrp $NEWSGRP $LIBDIR/history.d
		fi;;
	v7)	SYSNAME=`uuname -l`
		touch $LIBDIR/history.pag $LIBDIR/history.dir;;
	*)	echo "$0: Unknown Ostype"
		exit 1;;
esac

if test "$SYSNAME" = ""
then
	echo "$0: Cannot get system name"
	exit 1
fi

: Ensure SPOOLDIR exists
for i in $SPOOLDIR $SPOOLDIR/.rnews
do
	if test ! -d $i
	then
		mkdir $i
	fi
	chmod 777 $i
	chown $NEWSUSR $i
	chgrp $NEWSGRP $i
done

chown $NEWSUSR $LIBDIR
chgrp $NEWSGRP $LIBDIR

: Ensure certain files in LIBDIR exist
touch $LIBDIR/history $LIBDIR/active $LIBDIR/log $LIBDIR/errlog $LIBDIR/users
chmod 666 $LIBDIR/users

: If no sys file, make one.
if test ! -f $LIBDIR/sys
then
echo
echo Making a $LIBDIR/sys file to link you to oopsvax.
echo You must change oopsvax to your news feed.
echo If you are not in the USA, remove '"usa"' from your line in the sys file.
echo If you are not in North America, remove '"na"' from your line in the sys file.
	cat > $LIBDIR/sys << EOF
$SYSNAME:world,comp,sci,news,rec,soc,talk,misc,net,mod,na,usa,to::
oopsvax:world,comp,sci,news,rec,soc,talk,misc,net,mod,na,usa,to.oopsvax::
EOF
fi

: If no seq file, make one.
if test ! -s $LIBDIR/seq
then
	echo '100' >$LIBDIR/seq
fi

: If no mailpaths, make one.
if test ! -s $LIBDIR/mailpaths
then
	cat <<E_O_F >$LIBDIR/mailpaths
backbone	%s
internet	%s
E_O_F
echo "I have created $LIBDIR/mailpaths for you. The paths are certainly wrong."
echo "You must correct them manually to be able to post to moderated groups."
fi

sh makeactive.sh $LIBDIR $SPOOLDIR $NEWSUSR $NEWSGRP

for i in $LIBDIR/ngfile $BINDIR/inews $LIBDIR/localgroups $LIBDIR/moderators \
	$LIBDIR/cunbatch $LIBDIR/c7unbatch
do
	if test -f $i
	then
		echo "$i is no longer used. You should remove it."
	fi
done

for i in $LIBDIR/csendbatch $LIBDIR/c7sendbatch
do
	if test -f $i
	then
		echo "$i is no longer used. You should remove it after"
		echo "changing your crontab entry to use sendbatch [flags]"
	fi
done

if test -f $BINDIR/cunbatch
then
	echo "$BINDIR/cunbatch is not used by the new batching scheme."
	echo "You should remove it when all of your neighbors have upgraded."
fi

cat >$LIBDIR/aliases.new <<EOF
net.chess		net.games.chess
net.trivia		net.games.trivia
net.rec.radio		net.ham-radio
net.term		net.info-terms
net.joke		net.jokes
net.vlsi		net.lsi
net.micro.16k		net.micro.ns32k
net.music.gdea		net.music.gdead
net.notes		net.news.notes
net.periph		net.periphs
net.puzzles		net.puzzle
net.unix.wizards	net.unix-wizards
net.sources.wanted	net.wanted.sources
net.consumers		misc.consumers
net.consumers.house	misc.consumers.house
net.house		misc.consumers.house
na.forsale		misc.forsale
net.forsale		misc.forsale
net.politics.terror	misc.headlines
net.invest		misc.invest
net.jobs		misc.jobs
net.kids		misc.kids
mod.legal		misc.legal
net.legal		misc.legal
net.followup		misc.misc
net.general		misc.misc
net.misc		misc.misc
net.suicide		misc.misc
net.taxes		misc.taxes
mod.test		misc.test
net.test		misc.test
net.wanted		misc.wanted
net.announce		mod.announce
net.announce.newusers	mod.announce.newusers
mod.map.uucp		mod.map
net.religion.christian	mod.religion.christian
net.religion.xian	mod.religion.christian
net.astro		sci.astro
net.astro.expert	sci.astro
net.bio			sci.bio
net.crypt		sci.crypt
net.analog		sci.electronics
net.nlang		sci.lang
net.math		sci.math
net.stat		sci.math.stat
net.math.stat		sci.math.stat
net.math.symbolic	sci.math.symbolic
net.med			sci.med
net.sci			sci.misc
net.physics		sci.physics
net.research		sci.research
net.space		sci.space
net.columbia		sci.space.shuttle
net.challenger		sci.space.shuttle
net.college		soc.college
net.nlang.africa	soc.culture.african
net.nlang.celts		soc.culture.celtic
net.nlang.greek		soc.culture.greek
net.nlang.india		soc.culture.indian
net.religion.jewish	soc.culture.jewish
net.social		soc.misc
mod.motss		soc.motss
net.motss		soc.motss
net.net-people		soc.net-people
net.roots		soc.roots
net.singles		soc.singles
net.women		soc.women
net.abortion		talk.abortion
net.bizarre		talk.bizarre
net.origins		talk.origins
net.philosophy		talk.philosophy.misc
net.politics		talk.politics.misc
net.politics.theory	talk.politics.theory
net.religion		talk.religion.misc
talk.religion		talk.religion.misc
net.rumor		talk.rumors
talk.rumor		talk.rumors
EOF
: if no aliases file, make one
if test ! -f $LIBDIR/aliases
then
	mv $LIBDIR/aliases.new $LIBDIR/aliases
else
	: see whats missing
	sort $LIBDIR/aliases | sed -e 's/  */	/g'  -e 's/		*/	/g' >/tmp/$$aliases
	sort $LIBDIR/aliases.new | sed -e 's/  */	/g'  -e 's/		*/	/g' >/tmp/$$aliases.new
	comm -23 /tmp/$$aliases.new /tmp/$$aliases >/tmp/$$comm
	if test -s /tmp/$$comm
	then
		echo "The following suggested aliases are missing or incorrect in your"
		echo "$LIBDIR/aliases file. It is suggested you add them."
		echo ""
		cat /tmp/$$comm
		echo ""
		echo "A suggested aliases file has been left in $LIBDIR/aliases.new"
		echo "for your convenience."
		rm /tmp/$$comm /tmp/$$aliases
	else
		rm /tmp/$$comm /tmp/$$aliases $LIBDIR/aliases.new
	fi
fi

: if no distributions file, make one
if test ! -f $LIBDIR/distributions
then
	cat >$LIBDIR/distributions <<EOF
local		Local to this site
regional	Everywhere in this general area
usa		Everywhere in the USA
na		Everywhere in North America
world		Everywhere on Usenet in the world
EOF
echo
echo You may want to add distributions to $LIBDIR/distributions if your
echo site particpates in a regional distribution such as '"ba"' or '"dc"'.
fi

chown $NEWSUSR $LIBDIR/[a-z]*
chgrp $NEWSGRP $LIBDIR/[a-z]*

echo
echo Reminder: uux must permit rnews if running over uucp.
rm -f /tmp/$$*
