\"
\"  Mazewar documentation.
\"  use 'nroff -ms' to prepare.
\"
.LG
.TL
MAZEWAR
.SM
.PP
.I Mazewar
is a multi-player maze game with 3-D graphics
displays on machines which support the graphics (currently only SUNs).
The game can be played in two modes, the 'ascii mode' and the 'sun mode.'
The sun mode has the addition of a three-dimensional dungeon view.
.SH
Ascii Mode
.PP
The ascii mode is the only mode available if compiled off of a sun.
It can also be forced by giving the -a (for \fIa\fPscii)
flag when on a SUN.
.PP
In this mode, the screen is dominated by a top view of the maze,
which takes up 3/4 of a 24x80 character screen.
Below the maze, is a list of the players and their stats.
.PP
On the maze, you appear as a 'pair of eyes' (composed of the 
characters '^^', '>>', 'vv', or '<<'), and all the other players 
appear as small numbers, when you can see them.
.SH
SUN Mode
.PP
You will see three display areas on your screen, a 3-D maze,
a top view of the maze, and a list of current players and their stats.
.PP
The top-left 3-D maze view shows you what you can see from
your current position in the maze.  Other players show up as tall
triangles.  If the player is facing you, you will se him as a wide
triangle with an eye, if you see his back you will see the same figure
without the eye.  From the side, the player will look like a thin
triangle, with an eye pointing in the direction he is facing.
.PP
The map view shows you your absolute position in the maze, and
any player you can see in the upper view.  This helps you orient yourself
in the maze, since it is easy to get lost in the 3-D view.
.PP
The side stats display shows the list of active players and their
vital statistics.  Your player is marked with an asterisk.  The player
numbers on the stats display correspond with the numbers on the lower
top maze view.
.SH
Movement
.PP
The default keys to move around in the maze are:
.ta .5i 1.25i
.nf
	w 	move forward
	space	move backward
	Q	quit
	a	turn left
	d	turn right
	x	turn around
	s	shoot
	j	peek around the corner to the left
	l	peek around the corner to the right
	k	look straight ahead (if you move this will happen)
.fi
.PP
All of the keys can be remapped to any action by setting the environment
variable MAZEWAR_KEYS to a string composed of '<char>=action,<char>=action,...'
Remapping keys does NOT unmap the default configuration, if you want
to unmap a key, use '<char>=undef.'
.PP
The available (and hopefully self-explanatory) actions are:
.nf
.ta .5i 2.5i 4.5i
	redraw	forward	shoot
	quit	turn-back	turn-left
	turn-right	peek-left	stop-peek
	peek-right	back-up	undef
.fi
.PP
The environment variable MAZEWAR_BEEP should be set to the 
string 'yes', if you want Mazewar to beep when you press an unmapped key.
Since this beep is rather annoying, this is NOT the default action.
.SH
Game Strategy
.PP
Other players will appear in front of you only if you are 
facing them.  When you see someone, it is best to start shooting.  
.PP
It takes only one shot to kill a player (bazookas?).  Killing
someone automatically gains you a few generic score points.  Getting
killed is accompanied with minus points.  Once you are killed, you will
be quickly resurrected in another part of the maze.
.SH
Authors
.PP
This game was written by Chris Guthrie and Nick Lai, and the
SUN graphics done by John Coker; 
all of University of California, Berkeley.
.sp
.nf
	chris@BERKELEY [...!ucbvax!chris],
	lai@BERKELEY [...!ucbvax!lai],
	jcoker@BERKELEY [...!ucbvax!jcoker].
.fi
