case $CONFIG in
   '') . config.sh ;;
esac
$echo "Extracting address.1 (with variable substitutions)"
$rm -f address.1
cat >address.1<<!GROK!THIS!
.RL "Baylor College of Medicine"
.TH ADDRESS 1
.SH NAME
address - display the path generated by \fBuumail\fR for an
RFC822/RFC976-format address.
.SH SYNOPSIS
address rfc-address [ ... ]
.SH DESCRIPTION
This program allows you to check the UUCP mail routing path that will
be generated by the UUCP mailer \fBuumail\fR if you specify an
RFC822/RFC976-format address \fBrfc-address\fR in the ``To:'' field of the mail header.
For each RFC-style address on the command line, \fBaddress\fR echoes the
address to the standard output, followed by a colon, followed by
the UUCP address that will be used to send the message to that address.

.SH "ADDRESS FORMAT"
Briefly, the RFC822/RFC976-format address is of the form
.nf
.sp 1
	<localaddress>@<hostname>.<domain>
.sp 1
.fi
where <hostname> is the name of the system you are sending the message
to, <domain> is a modifier for <hostname> identifying the network in
which the address is to be interpreted (EDU, COM, GOV, ORG, NET, etc.);
and <localaddress> is an address string to be interpreted on the host
machine.

On our system, the presently
valid <domains>s are EDU, COM, GOV, ORG, NET, UUCP, and ARPA.
Omitting
the <domain> causes the network to default to UUCP.  The <hostname>
should be the name of a remote machine to which the message is
directed; see \fI$database\fR for a list of all
known UUCP hostnames.  It is \fInot\fR necessary to specify a UUCP pathname
when using this format; the pathname is automatically determined for you
and substituted into the address before mailing.  The selected pathname
is determined using the \fBpathalias\fR database, and is supposed
to be optimal, taking into consideration information provided by
each site about how often they send mail out, etc.

.SH EXAMPLES
.HP 5
joe
.br
The message is sent to the user ``joe'' on the local system.
.HP 5
joe@ucbvax
.br
The message is sent to joe on the UUCP system named ``ucbvax''; this
address is automatically translated to a proper (and ostensibly
optimal) UUCP path.
.HP 5
joe@ucbvax.UUCP
.br
Same as joe@ucbvax
.HP 5
joe@ucbvax.ARPA
.br
The message is addressed to joe at ucbvax, using the ARPA network.
The message will be routed to the ARPAnet via a UUCP-ARPAnet gateway.
.HP 5
ucbvax!multics.mit.edu!joe
.br
The message is sent to ucbvax, who then uses the address
joe@multics.mit.edu to send the message on to multics.mit.edu via the
ARPAnet.  Since ucbvax is on the arpanet, this address will work correctly
(as long as there is someone named joe on the MIT multics machine).
.HP 5
ucbvax!multics.mit.edu!vanderbilt.mailnet!joe
.br
The message is sent via UUCP to ucbvax, who then sends the message
to multics.mit.edu via the arpanet; multics.mit.edu then sends the message
to joe@vanderbilt via MAILNET.  Since the above machines each have access
to the networks named in the address, this address will work correctly.
.SH FILES
$database - Pathalias database
.SH "SEE ALSO"
uupath(1), uumail(8), pathalias(1)
.br
.B RFC 822 "Standard for the Format of ARPA Internet Text Messages"
.br
.B RFC 976 "UUCP Mail Interchange Format Standard"
.SH AUTHOR
Stan Barber, Baylor College of Medicine
!GROK!THIS!

