.TH NEWSFEED 1 "12 November 1986"
.SH NAME
newsfeed \- simultaneous multi-site news feeder
.SH SYNOPSIS
.B newsfeed
[-max_size] base_file [list_of_hold_sites]
.SH DESCRIPTION
.I newsfeed
takes a list of news articles (with sitenames) in file
.I base_file
and batches them simultaneously for the given sites after changing to
the batching directory (whatever was compiled in).
Each line is a set of space\-separated strings,
the first string being the full pathname of a news article.
The remaining strings are sites to which that news article is being fed.
If there are no sites, the last component of
.I base_file
is used (old batch format).
.PP
If the
.I max_size
parameter is given, each batch is limited to that maximum size
(unless a single article is greater than that size).
Thus, a maximum batch size of 1 causes each article to be contained in its own
batch.
A maximum batch size of 0 means there is no upper limit.
The default is whatever is compiled in.
.PP
Any
.I hold_sites
given are saved to a file for later processing.
This may be used, for example, when those sites are down for extended periods.
.SH FILES
.ta \w'base_file.newlog  'u
base_file	input file
.br
base_file.input	temporary file for error recovery
.br
base_file.proc	batch being processed
.br
base_file.again	batch to be reprocessed
.br
base_file.cmd	command to queue the batch
.br
	(takes a list of sites as parameters)
.br
base_file.log	log file
.br
base_file.newlog	temporary log file
.br
base_file.hold	list of held articles and their sites
.SH "SEE ALSO"
newsfeedlist(1)
.SH AUTHOR
Stephen J. Muir, Lancaster University, England, UK
