/*
 * Binary batching
 */

#define BVERSION 0		/* version number */

#define LFTYPE 2		/* length of an (encoded) file type */
char ftypes[] = "nma" ;	/* file types */

#define BS 8			/* size of a byte */

#define NHRELAY 0
#define NHVERSION 1
#define NHPATH 2
#define NHFROM 3
#define NHNEWSGROUPS 4
#define NHSUBJECT 5
#define NHRESUBJECT 6
#define NHMESSAGEID 7
#define NHDATE 8
#define NHARTICLEID 9
#define NHPOSTED 10
#define NHEXPIRES 11
#define NHREF 12
#define NHCONTROL 13
#define NHSENDER 14
#define NHREPLYTO 15
#define NHFOLLOWUPTO 16
#define NHDIST 17
#define NHORG 18
#define NHLINES 19
#define NHKEYWORDS 20
#define NHAPPROVED 21
#define NHSUMMARY 22
#define NHPRIORITY 23
#define NHNFID 24
#define NHNFFROM 25
#define NHUNKNOWN 26
#define NHSEP 27
#define NHEND 28

char *hprefix[28] = {
	"Relay-Version: version ",
	"Posting-Version: version ",
	"Path: ",
	"From: ",
	"Newsgroups: ",
	"Subject: ",
	"Subject: Re: ",
	"Message-ID: <",
	"Date: ",
	"Article-I.D.: ",
	"Posted: ",
	"Expires: ",
	"References: ",
	"Control: ",
	"Sender: ",
	"Reply-To: ",
	"Followup-To: ",
	"Distribution: ",
	"Organization: ",
	"Lines: ",
	"Keywords: ",
	"Approved: ",
	"Summary: ",
	"Priority: ",
	"NF-ID: #",
	"NF-From: ",
	"",
	0
} ;

#ifdef UNBAT

struct decode {	/* decoding table */
      char cval ;	/* decoded character */
      char clen ;	/* length */
} ;

#else

struct encode {	/* encoding table */
      short cbits ;	/* character length */
      short clen ;	/* character length */
} ;

#endif

#ifdef UNBAT

#define EOFMARK 0
#define EXTCHAR 1

struct decode dtab[1024] = {
	{0040, 2},	{0151, 5},
	{0145, 4},	{0155, 6},
	{0040, 2},	{0154, 5},
	{0157, 4},	{0055, 8},
	{0040, 2},	{0162, 5},
	{0164, 4},	{0147, 6},
	{0040, 2},	{0012, 5},
	{0141, 5},	{0105, 9},
	{0040, 2},	{0163, 5},
	{0145, 4},	{0146, 6},
	{0040, 2},	{0144, 5},
	{0157, 4},	{0041, 9},
	{0040, 2},	{0150, 5},
	{0164, 4},	{0056, 7},
	{0040, 2},	{0165, 6},
	{0156, 5},	{0010, 10},
	{0040, 2},	{0151, 5},
	{0145, 4},	{0160, 6},
	{0040, 2},	{0154, 5},
	{0157, 4},	{0124, 8},
	{0040, 2},	{0162, 5},
	{0164, 4},	{0167, 7},
	{0040, 2},	{0012, 5},
	{0141, 5},	{0131, 9},
	{0040, 2},	{0163, 5},
	{0145, 4},	{0171, 6},
	{0040, 2},	{0144, 5},
	{0157, 4},	{0064, 9},
	{0040, 2},	{0150, 5},
	{0164, 4},	{0054, 7},
	{0040, 2},	{0143, 6},
	{0156, 5},	{0114, 10},
	{0040, 2},	{0151, 5},
	{0145, 4},	{0155, 6},
	{0040, 2},	{0154, 5},
	{0157, 4},	{0111, 8},
	{0040, 2},	{0162, 5},
	{0164, 4},	{0147, 6},
	{0040, 2},	{0012, 5},
	{0141, 5},	{0120, 9},
	{0040, 2},	{0163, 5},
	{0145, 4},	{0146, 6},
	{0040, 2},	{0144, 5},
	{0157, 4},	{0057, 9},
	{0040, 2},	{0150, 5},
	{0164, 4},	{0166, 7},
	{0040, 2},	{0165, 6},
	{0156, 5},	{0075, 10},
	{0040, 2},	{0151, 5},
	{0145, 4},	{0160, 6},
	{0040, 2},	{0154, 5},
	{0157, 4},	{0047, 8},
	{0040, 2},	{0162, 5},
	{0164, 4},	{0142, 7},
	{0040, 2},	{0012, 5},
	{0141, 5},	{0175, 9},
	{0040, 2},	{0163, 5},
	{0145, 4},	{0171, 6},
	{0040, 2},	{0144, 5},
	{0157, 4},	{0100, 9},
	{0040, 2},	{0150, 5},
	{0164, 4},	{0011, 7},
	{0040, 2},	{0143, 6},
	{0156, 5},	{0137, 10},
	{0040, 2},	{0151, 5},
	{0145, 4},	{0155, 6},
	{0040, 2},	{0154, 5},
	{0157, 4},	{0153, 8},
	{0040, 2},	{0162, 5},
	{0164, 4},	{0147, 6},
	{0040, 2},	{0012, 5},
	{0141, 5},	{0116, 9},
	{0040, 2},	{0163, 5},
	{0145, 4},	{0146, 6},
	{0040, 2},	{0144, 5},
	{0157, 4},	{0050, 9},
	{0040, 2},	{0150, 5},
	{0164, 4},	{0056, 7},
	{0040, 2},	{0165, 6},
	{0156, 5},	{0046, 10},
	{0040, 2},	{0151, 5},
	{0145, 4},	{0160, 6},
	{0040, 2},	{0154, 5},
	{0157, 4},	{0123, 8},
	{0040, 2},	{0162, 5},
	{0164, 4},	{0167, 7},
	{0040, 2},	{0012, 5},
	{0141, 5},	{0170, 9},
	{0040, 2},	{0163, 5},
	{0145, 4},	{0171, 6},
	{0040, 2},	{0144, 5},
	{0157, 4},	{0072, 9},
	{0040, 2},	{0150, 5},
	{0164, 4},	{0054, 7},
	{0040, 2},	{0143, 6},
	{0156, 5},	{0132, 10},
	{0040, 2},	{0151, 5},
	{0145, 4},	{0155, 6},
	{0040, 2},	{0154, 5},
	{0157, 4},	{0060, 8},
	{0040, 2},	{0162, 5},
	{0164, 4},	{0147, 6},
	{0040, 2},	{0012, 5},
	{0141, 5},	{0125, 9},
	{0040, 2},	{0163, 5},
	{0145, 4},	{0146, 6},
	{0040, 2},	{0144, 5},
	{0157, 4},	{0062, 9},
	{0040, 2},	{0150, 5},
	{0164, 4},	{0166, 7},
	{0040, 2},	{0165, 6},
	{0156, 5},	{0107, 10},
	{0040, 2},	{0151, 5},
	{0145, 4},	{0160, 6},
	{0040, 2},	{0154, 5},
	{0157, 4},	{0042, 9},
	{0040, 2},	{0162, 5},
	{0164, 4},	{0142, 7},
	{0040, 2},	{0012, 5},
	{0141, 5},	{0065, 10},
	{0040, 2},	{0163, 5},
	{0145, 4},	{0171, 6},
	{0040, 2},	{0144, 5},
	{0157, 4},	{0103, 9},
	{0040, 2},	{0150, 5},
	{0164, 4},	{0011, 7},
	{0040, 2},	{0143, 6},
	{0156, 5},	{0172, 10},
	{0040, 2},	{0151, 5},
	{0145, 4},	{0155, 6},
	{0040, 2},	{0154, 5},
	{0157, 4},	{0055, 8},
	{0040, 2},	{0162, 5},
	{0164, 4},	{0147, 6},
	{0040, 2},	{0012, 5},
	{0141, 5},	{0115, 9},
	{0040, 2},	{0163, 5},
	{0145, 4},	{0146, 6},
	{0040, 2},	{0144, 5},
	{0157, 4},	{0043, 9},
	{0040, 2},	{0150, 5},
	{0164, 4},	{0056, 7},
	{0040, 2},	{0165, 6},
	{0156, 5},	{0044, 10},
	{0040, 2},	{0151, 5},
	{0145, 4},	{0160, 6},
	{0040, 2},	{0154, 5},
	{0157, 4},	{0124, 8},
	{0040, 2},	{0162, 5},
	{0164, 4},	{0167, 7},
	{0040, 2},	{0012, 5},
	{0141, 5},	{0134, 9},
	{0040, 2},	{0163, 5},
	{0145, 4},	{0171, 6},
	{0040, 2},	{0144, 5},
	{0157, 4},	{0067, 9},
	{0040, 2},	{0150, 5},
	{0164, 4},	{0054, 7},
	{0040, 2},	{0143, 6},
	{0156, 5},	{0126, 10},
	{0040, 2},	{0151, 5},
	{0145, 4},	{0155, 6},
	{0040, 2},	{0154, 5},
	{0157, 4},	{0111, 8},
	{0040, 2},	{0162, 5},
	{0164, 4},	{0147, 6},
	{0040, 2},	{0012, 5},
	{0141, 5},	{0122, 9},
	{0040, 2},	{0163, 5},
	{0145, 4},	{0146, 6},
	{0040, 2},	{0144, 5},
	{0157, 4},	{0061, 9},
	{0040, 2},	{0150, 5},
	{0164, 4},	{0166, 7},
	{0040, 2},	{0165, 6},
	{0156, 5},	{0077, 10},
	{0040, 2},	{0151, 5},
	{0145, 4},	{0160, 6},
	{0040, 2},	{0154, 5},
	{0157, 4},	{0047, 8},
	{0040, 2},	{0162, 5},
	{0164, 4},	{0142, 7},
	{0040, 2},	{0012, 5},
	{0141, 5},	{0201, 9},
	{0040, 2},	{0163, 5},
	{0145, 4},	{0171, 6},
	{0040, 2},	{0144, 5},
	{0157, 4},	{0102, 9},
	{0040, 2},	{0150, 5},
	{0164, 4},	{0011, 7},
	{0040, 2},	{0143, 6},
	{0156, 5},	{0152, 10},
	{0040, 2},	{0151, 5},
	{0145, 4},	{0155, 6},
	{0040, 2},	{0154, 5},
	{0157, 4},	{0153, 8},
	{0040, 2},	{0162, 5},
	{0164, 4},	{0147, 6},
	{0040, 2},	{0012, 5},
	{0141, 5},	{0117, 9},
	{0040, 2},	{0163, 5},
	{0145, 4},	{0146, 6},
	{0040, 2},	{0144, 5},
	{0157, 4},	{0051, 9},
	{0040, 2},	{0150, 5},
	{0164, 4},	{0056, 7},
	{0040, 2},	{0165, 6},
	{0156, 5},	{0053, 10},
	{0040, 2},	{0151, 5},
	{0145, 4},	{0160, 6},
	{0040, 2},	{0154, 5},
	{0157, 4},	{0123, 8},
	{0040, 2},	{0162, 5},
	{0164, 4},	{0167, 7},
	{0040, 2},	{0012, 5},
	{0141, 5},	{0173, 9},
	{0040, 2},	{0163, 5},
	{0145, 4},	{0171, 6},
	{0040, 2},	{0144, 5},
	{0157, 4},	{0074, 9},
	{0040, 2},	{0150, 5},
	{0164, 4},	{0054, 7},
	{0040, 2},	{0143, 6},
	{0156, 5},	{0135, 10},
	{0040, 2},	{0151, 5},
	{0145, 4},	{0155, 6},
	{0040, 2},	{0154, 5},
	{0157, 4},	{0060, 8},
	{0040, 2},	{0162, 5},
	{0164, 4},	{0147, 6},
	{0040, 2},	{0012, 5},
	{0141, 5},	{0127, 9},
	{0040, 2},	{0163, 5},
	{0145, 4},	{0146, 6},
	{0040, 2},	{0144, 5},
	{0157, 4},	{0063, 9},
	{0040, 2},	{0150, 5},
	{0164, 4},	{0166, 7},
	{0040, 2},	{0165, 6},
	{0156, 5},	{0112, 10},
	{0040, 2},	{0151, 5},
	{0145, 4},	{0160, 6},
	{0040, 2},	{0154, 5},
	{0157, 4},	{0101, 9},
	{0040, 2},	{0162, 5},
	{0164, 4},	{0142, 7},
	{0040, 2},	{0012, 5},
	{0141, 5},	{0070, 10},
	{0040, 2},	{0163, 5},
	{0145, 4},	{0171, 6},
	{0040, 2},	{0144, 5},
	{0157, 4},	{0104, 9},
	{0040, 2},	{0150, 5},
	{0164, 4},	{0011, 7},
	{0040, 2},	{0143, 6},
	{0156, 5},	{0176, 10},
	{0040, 2},	{0151, 5},
	{0145, 4},	{0155, 6},
	{0040, 2},	{0154, 5},
	{0157, 4},	{0055, 8},
	{0040, 2},	{0162, 5},
	{0164, 4},	{0147, 6},
	{0040, 2},	{0012, 5},
	{0141, 5},	{0105, 9},
	{0040, 2},	{0163, 5},
	{0145, 4},	{0146, 6},
	{0040, 2},	{0144, 5},
	{0157, 4},	{0041, 9},
	{0040, 2},	{0150, 5},
	{0164, 4},	{0056, 7},
	{0040, 2},	{0165, 6},
	{0156, 5},	{0015, 10},
	{0040, 2},	{0151, 5},
	{0145, 4},	{0160, 6},
	{0040, 2},	{0154, 5},
	{0157, 4},	{0124, 8},
	{0040, 2},	{0162, 5},
	{0164, 4},	{0167, 7},
	{0040, 2},	{0012, 5},
	{0141, 5},	{0131, 9},
	{0040, 2},	{0163, 5},
	{0145, 4},	{0171, 6},
	{0040, 2},	{0144, 5},
	{0157, 4},	{0064, 9},
	{0040, 2},	{0150, 5},
	{0164, 4},	{0054, 7},
	{0040, 2},	{0143, 6},
	{0156, 5},	{0121, 10},
	{0040, 2},	{0151, 5},
	{0145, 4},	{0155, 6},
	{0040, 2},	{0154, 5},
	{0157, 4},	{0111, 8},
	{0040, 2},	{0162, 5},
	{0164, 4},	{0147, 6},
	{0040, 2},	{0012, 5},
	{0141, 5},	{0120, 9},
	{0040, 2},	{0163, 5},
	{0145, 4},	{0146, 6},
	{0040, 2},	{0144, 5},
	{0157, 4},	{0057, 9},
	{0040, 2},	{0150, 5},
	{0164, 4},	{0166, 7},
	{0040, 2},	{0165, 6},
	{0156, 5},	{0076, 10},
	{0040, 2},	{0151, 5},
	{0145, 4},	{0160, 6},
	{0040, 2},	{0154, 5},
	{0157, 4},	{0047, 8},
	{0040, 2},	{0162, 5},
	{0164, 4},	{0142, 7},
	{0040, 2},	{0012, 5},
	{0141, 5},	{0175, 9},
	{0040, 2},	{0163, 5},
	{0145, 4},	{0171, 6},
	{0040, 2},	{0144, 5},
	{0157, 4},	{0100, 9},
	{0040, 2},	{0150, 5},
	{0164, 4},	{0011, 7},
	{0040, 2},	{0143, 6},
	{0156, 5},	{0140, 10},
	{0040, 2},	{0151, 5},
	{0145, 4},	{0155, 6},
	{0040, 2},	{0154, 5},
	{0157, 4},	{0153, 8},
	{0040, 2},	{0162, 5},
	{0164, 4},	{0147, 6},
	{0040, 2},	{0012, 5},
	{0141, 5},	{0116, 9},
	{0040, 2},	{0163, 5},
	{0145, 4},	{0146, 6},
	{0040, 2},	{0144, 5},
	{0157, 4},	{0050, 9},
	{0040, 2},	{0150, 5},
	{0164, 4},	{0056, 7},
	{0040, 2},	{0165, 6},
	{0156, 5},	{0052, 10},
	{0040, 2},	{0151, 5},
	{0145, 4},	{0160, 6},
	{0040, 2},	{0154, 5},
	{0157, 4},	{0123, 8},
	{0040, 2},	{0162, 5},
	{0164, 4},	{0167, 7},
	{0040, 2},	{0012, 5},
	{0141, 5},	{0170, 9},
	{0040, 2},	{0163, 5},
	{0145, 4},	{0171, 6},
	{0040, 2},	{0144, 5},
	{0157, 4},	{0072, 9},
	{0040, 2},	{0150, 5},
	{0164, 4},	{0054, 7},
	{0040, 2},	{0143, 6},
	{0156, 5},	{0133, 10},
	{0040, 2},	{0151, 5},
	{0145, 4},	{0155, 6},
	{0040, 2},	{0154, 5},
	{0157, 4},	{0060, 8},
	{0040, 2},	{0162, 5},
	{0164, 4},	{0147, 6},
	{0040, 2},	{0012, 5},
	{0141, 5},	{0125, 9},
	{0040, 2},	{0163, 5},
	{0145, 4},	{0146, 6},
	{0040, 2},	{0144, 5},
	{0157, 4},	{0062, 9},
	{0040, 2},	{0150, 5},
	{0164, 4},	{0166, 7},
	{0040, 2},	{0165, 6},
	{0156, 5},	{0110, 10},
	{0040, 2},	{0151, 5},
	{0145, 4},	{0160, 6},
	{0040, 2},	{0154, 5},
	{0157, 4},	{0042, 9},
	{0040, 2},	{0162, 5},
	{0164, 4},	{0142, 7},
	{0040, 2},	{0012, 5},
	{0141, 5},	{0066, 10},
	{0040, 2},	{0163, 5},
	{0145, 4},	{0171, 6},
	{0040, 2},	{0144, 5},
	{0157, 4},	{0103, 9},
	{0040, 2},	{0150, 5},
	{0164, 4},	{0011, 7},
	{0040, 2},	{0143, 6},
	{0156, 5},	{0174, 10},
	{0040, 2},	{0151, 5},
	{0145, 4},	{0155, 6},
	{0040, 2},	{0154, 5},
	{0157, 4},	{0055, 8},
	{0040, 2},	{0162, 5},
	{0164, 4},	{0147, 6},
	{0040, 2},	{0012, 5},
	{0141, 5},	{0115, 9},
	{0040, 2},	{0163, 5},
	{0145, 4},	{0146, 6},
	{0040, 2},	{0144, 5},
	{0157, 4},	{0043, 9},
	{0040, 2},	{0150, 5},
	{0164, 4},	{0056, 7},
	{0040, 2},	{0165, 6},
	{0156, 5},	{0045, 10},
	{0040, 2},	{0151, 5},
	{0145, 4},	{0160, 6},
	{0040, 2},	{0154, 5},
	{0157, 4},	{0124, 8},
	{0040, 2},	{0162, 5},
	{0164, 4},	{0167, 7},
	{0040, 2},	{0012, 5},
	{0141, 5},	{0134, 9},
	{0040, 2},	{0163, 5},
	{0145, 4},	{0171, 6},
	{0040, 2},	{0144, 5},
	{0157, 4},	{0067, 9},
	{0040, 2},	{0150, 5},
	{0164, 4},	{0054, 7},
	{0040, 2},	{0143, 6},
	{0156, 5},	{0130, 10},
	{0040, 2},	{0151, 5},
	{0145, 4},	{0155, 6},
	{0040, 2},	{0154, 5},
	{0157, 4},	{0111, 8},
	{0040, 2},	{0162, 5},
	{0164, 4},	{0147, 6},
	{0040, 2},	{0012, 5},
	{0141, 5},	{0122, 9},
	{0040, 2},	{0163, 5},
	{0145, 4},	{0146, 6},
	{0040, 2},	{0144, 5},
	{0157, 4},	{0061, 9},
	{0040, 2},	{0150, 5},
	{0164, 4},	{0166, 7},
	{0040, 2},	{0165, 6},
	{0156, 5},	{0106, 10},
	{0040, 2},	{0151, 5},
	{0145, 4},	{0160, 6},
	{0040, 2},	{0154, 5},
	{0157, 4},	{0047, 8},
	{0040, 2},	{0162, 5},
	{0164, 4},	{0142, 7},
	{0040, 2},	{0012, 5},
	{0141, 5},	{0201, 9},
	{0040, 2},	{0163, 5},
	{0145, 4},	{0171, 6},
	{0040, 2},	{0144, 5},
	{0157, 4},	{0102, 9},
	{0040, 2},	{0150, 5},
	{0164, 4},	{0011, 7},
	{0040, 2},	{0143, 6},
	{0156, 5},	{0161, 10},
	{0040, 2},	{0151, 5},
	{0145, 4},	{0155, 6},
	{0040, 2},	{0154, 5},
	{0157, 4},	{0153, 8},
	{0040, 2},	{0162, 5},
	{0164, 4},	{0147, 6},
	{0040, 2},	{0012, 5},
	{0141, 5},	{0117, 9},
	{0040, 2},	{0163, 5},
	{0145, 4},	{0146, 6},
	{0040, 2},	{0144, 5},
	{0157, 4},	{0051, 9},
	{0040, 2},	{0150, 5},
	{0164, 4},	{0056, 7},
	{0040, 2},	{0165, 6},
	{0156, 5},	{0073, 10},
	{0040, 2},	{0151, 5},
	{0145, 4},	{0160, 6},
	{0040, 2},	{0154, 5},
	{0157, 4},	{0123, 8},
	{0040, 2},	{0162, 5},
	{0164, 4},	{0167, 7},
	{0040, 2},	{0012, 5},
	{0141, 5},	{0173, 9},
	{0040, 2},	{0163, 5},
	{0145, 4},	{0171, 6},
	{0040, 2},	{0144, 5},
	{0157, 4},	{0074, 9},
	{0040, 2},	{0150, 5},
	{0164, 4},	{0054, 7},
	{0040, 2},	{0143, 6},
	{0156, 5},	{0136, 10},
	{0040, 2},	{0151, 5},
	{0145, 4},	{0155, 6},
	{0040, 2},	{0154, 5},
	{0157, 4},	{0060, 8},
	{0040, 2},	{0162, 5},
	{0164, 4},	{0147, 6},
	{0040, 2},	{0012, 5},
	{0141, 5},	{0127, 9},
	{0040, 2},	{0163, 5},
	{0145, 4},	{0146, 6},
	{0040, 2},	{0144, 5},
	{0157, 4},	{0063, 9},
	{0040, 2},	{0150, 5},
	{0164, 4},	{0166, 7},
	{0040, 2},	{0165, 6},
	{0156, 5},	{0113, 10},
	{0040, 2},	{0151, 5},
	{0145, 4},	{0160, 6},
	{0040, 2},	{0154, 5},
	{0157, 4},	{0101, 9},
	{0040, 2},	{0162, 5},
	{0164, 4},	{0142, 7},
	{0040, 2},	{0012, 5},
	{0141, 5},	{0071, 10},
	{0040, 2},	{0163, 5},
	{0145, 4},	{0171, 6},
	{0040, 2},	{0144, 5},
	{0157, 4},	{0104, 9},
	{0040, 2},	{0150, 5},
	{0164, 4},	{0011, 7},
	{0040, 2},	{0143, 6},
	{0156, 5},	{0200, 10},
} ;

char extchar[32] = {
	0000,
	0001,
	0002,
	0003,
	0004,
	0005,
	0006,
	0007,
	0013,
	0014,
	0016,
	0017,
	0020,
	0021,
	0022,
	0023,
	0024,
	0025,
	0026,
	0027,
	0030,
	0031,
	0032,
	0033,
	0034,
	0035,
	0036,
	0037,
	0177,
} ;

#else

#define PKEOFMARK 01777
#define LEOFMARK 10

struct encode etab[128] = {
	{0557, 14},
	{01557, 14},
	{02557, 14},
	{03557, 14},
	{04557, 14},
	{05557, 14},
	{06557, 14},
	{07557, 14},
	{037, 10},
	{0173, 7},
	{015, 5},
	{010557, 14},
	{011557, 14},
	{01037, 10},
	{012557, 14},
	{013557, 14},
	{014557, 14},
	{015557, 14},
	{016557, 14},
	{017557, 14},
	{020557, 14},
	{021557, 14},
	{022557, 14},
	{023557, 14},
	{024557, 14},
	{025557, 14},
	{026557, 14},
	{027557, 14},
	{030557, 14},
	{031557, 14},
	{032557, 14},
	{033557, 14},
	{00, 2},
	{027, 9},
	{0347, 9},
	{0427, 9},
	{0437, 10},
	{01437, 10},
	{0237, 10},
	{0147, 8},
	{0227, 9},
	{0627, 9},
	{01237, 10},
	{0637, 10},
	{073, 7},
	{07, 8},
	{033, 7},
	{0127, 9},
	{0307, 8},
	{0527, 9},
	{0327, 9},
	{0727, 9},
	{067, 9},
	{0357, 10},
	{01357, 10},
	{0467, 9},
	{0757, 10},
	{01757, 10},
	{0267, 9},
	{01637, 10},
	{0667, 9},
	{0137, 10},
	{01137, 10},
	{0537, 10},
	{0167, 9},
	{0747, 9},
	{0567, 9},
	{0367, 9},
	{0767, 9},
	{017, 9},
	{01537, 10},
	{0337, 10},
	{01337, 10},
	{0107, 8},
	{0737, 10},
	{01737, 10},
	{077, 10},
	{0417, 9},
	{0217, 9},
	{0617, 9},
	{0117, 9},
	{01077, 10},
	{0517, 9},
	{0247, 8},
	{047, 8},
	{0317, 9},
	{0477, 10},
	{0717, 9},
	{01477, 10},
	{057, 9},
	{0277, 10},
	{01277, 10},
	{0457, 9},
	{0677, 10},
	{01677, 10},
	{0177, 10},
	{01177, 10},
	{016, 5},
	{0153, 7},
	{075, 6},
	{025, 5},
	{02, 4},
	{023, 6},
	{013, 6},
	{031, 5},
	{01, 5},
	{0577, 10},
	{0207, 8},
	{05, 5},
	{03, 6},
	{036, 5},
	{06, 4},
	{043, 6},
	{01577, 10},
	{011, 5},
	{021, 5},
	{012, 4},
	{035, 6},
	{0133, 7},
	{053, 7},
	{0257, 9},
	{063, 6},
	{0377, 10},
	{0657, 9},
	{01377, 10},
	{0157, 9},
	{0777, 10},
	{034557, 14},
} ;

#endif
