


ALARM(L)          UNKNOWN SECTION OF THE MANUAL          ALARM(L)



NAME
     alarm - a periodic alarmer for suntools

SYNOPSIS
     alarm [-h _m_i_n] [alarmdb]

DESCRIPTION
     _a_l_a_r_m reads an alarm database and signals the user  whenever
     one  of the alarms becomes active.  If alarmdb is not speci-
     fied, ~/.alarm will be used.

     The format of the lines in the alarm database is as follows:

          date    time    message

     Lines starting with a # and blank lines are ignored.  `date'
     can  be  any of the following.  Minimum abbreviations are in
     caps, and case is insignificant:

          Sundays       Mondays      Tuesdays       Wednesdays
          THursdays     Fridays      SAturdays

          Daily         Any

          month/day

     Specifying `month/day' creates a "one-shot" alarm; the  oth-
     ers  are periodic.  `time' is in the form hour:minute (based
     on a 24-hour clock; 0:00 - 23:59).   `message'  is  anything
     you  want.   The program will read in this file, and when an
     alarm is to go off, it will do one of the following:

          1)   if the window is closed (iconic),  the  icon  will
               flash  to  indicate  an alarm.  Open the window to
               acknowledge the alarm.  Now, since the  window  is
               open,

          2)   if the window is open, the  entire  line  will  be
               written out.

     If you change your alarm database (~/.alarm  or  `alarmdb'),
     you  have  to  tell  the program to re-read the file (if you
     wish).  To do this, run ~/.alarmreset, which the alarm  pro-
     gram creates when it starts up.

OPTIONS
     There is only one option:

     -h _m_i_n
          Specify the initial history value, in  minutes.   _a_l_a_r_m
          will  signal  alarms  in the last _m_i_n minutes when ini-
          tially starting up.  The default time is 60 minutes.



ITC Release 1.0          21 January 1986                        1






ALARM(L)          UNKNOWN SECTION OF THE MANUAL          ALARM(L)



ENVIRONMENT
     _a_l_a_r_m looks at the  environment  variable  ICONDIR  for  the
     directory  containing  the  icons.  The default directory is
     defined in the Makefile.

SAMPLE ~/.alarm FILE
     #
     #  alarm database for /usr/local/bin/alarm
     #
     #  copyright 1986 Exploding Penguin Software
     #

     #
     #  Weekly alarms
     #
     mon     10:50   GRIP meeting at 11:00
     wed     12:20   Tech meeting at 12:30.
     fri     11:50   Faculty meeting at 12:00

     #
     #  Daily alarms
     #
     daily   16:50   Time to go home!
     daily   17:00   What are you still doing here?

     #
     #  One-time alarms
     #
     1/22    15:50   Bentley seminar at 4:00.
     1/24    15:20   Seminar at 3:30.

BUGS
     Invalid dates and time are accepted  (4/38  =  5/8;  5:80  =
     6:20).   Error  checking  is  only done on the format of the
     input, not on the values contained therein.

     The program may or may not work correctly when Daylight Sav-
     ings  Time goes into effect.  It also may or may not work in
     different time zones.  These cases have not been tested.  If
     you have any problems, please contact the author.

FILES
     /usr/local/bin/alarm        The program
     $ICONDIR/alarm_off          Icon for quiescent state
     $ICONDIR/alarm_on           Icons for active state
     $ICONDIR/alarm_on2             (toggles between these two)
     ~/.alarm                    Alarm database
     ~/.alarmreset               Alarm signaller

AUTHOR
     Samuel Black (black@unc)




ITC Release 1.0          21 January 1986                        2



