.TH MONGO 1 local
.SH NAME
.PP
mongo - a simple interactive graphing program
.SH DESCRIPTION
.PP
Mongo allows the user to produce simple graphs composed of
lines, points and text, together with labeled axes. Input is
taken from files which have several columns (numeric fields
separated by white space) per line; one may plot the
contents of any column versus any other.
.PP
Hardcopy may be produced in two ways: either by screen dump 
or by direct output to a printer.
The first method yields graphs with an aspect ratio 
slightly more cramped vertically (at least on the AT&T 7300)
than the screen; the second gives a much more even aspect ratio.
.SH Commands
There are many commands; a brief description of each one follows:
.IP quit 20
Quit the program, clear the screen and set the window back to its
initial size. Any hardcopy plots produced via 
.I update
will be made at this time.
.IP clear 20
Clear the graphing area of the screen and any other attached graphics
device such as the printer. A formfeed character will be sent to the
printer and the page will be queued for printing upon exiting the program.
.IP "file data" 20
Open the file 
.I data
for data input. If it does not exist, the program will complain.
.IP "lines n1 n2" 20
Limit the lines of the file from which data will be read to start
at line 
.I n1
and end at line 
.I n2. 
Line numbers start at 1, not 0.
.IP "xc n" 20
Take data for the x coordinates from column number 
.I n 
in the file.
Column separators are any white space. Non-numeric data causes
bad things to happen, and will probably screw up all following
operations.
.IP "yc n" 20
Same as 
.I xc
above, but for the y coordinates.
.IP "limits [ x1 x2 y1 y2 ]" 20
If four arguments are present, set the limits of the plot to the
given values: the x-values range from a lower limit of 
.I x1 
to 
.I x2,
the y-values from 
.I y1 
to 
.I y2. 
If no arguments are given, set the
limits to the extremes of the data (so that all points should
appear in the plot).
.IP points 20
Place the current point markers (set by
.I ptype) 
at each one of the data points which are within the 
screen boundaries.
.IP "ptype [ value ]" 20
If an argument is given, set the current point type to the given
.I value; 
with no argument, report the current point type.
Possible types are POINT, PLUS, ASTERISK, CIRCLE, CROSS, DIAMOND.
The default is PLUS.
.IP connect 20
Draw lines connecting the current data points, clipping lines to
off-screen points at the plot boundaries. The type of line may
be selected via 
.I ltype.
.IP "ltype [ value ]" 20
If an argument is given, set the current line type to the given
.I value;
with no argument, report the current line type. Possible line types
are SOLID, LONG_DASH, DOT, DOT_DASH, MEDIUM_DASH and DASH_2_DOTS.
DOT is the default.
.IP box 20
Draw four solid lines on the screen, outlining the plot area.
.IP "axes [ xscale yscale ]" 20
Similar to 
.I box
above, but the axes (x on the bottom, y on the left) are tick-marked 
and labeled with the values of the respective variable. Each value
is in the form of a single digit, a decimal point 
and two decimal places; the scale factor is placed on the far end of 
the axis. If arguments
.I xscale
and
.I yscale
are given, they are used to scale the x axis and the y axis, respectively.
Otherwise, the axes are scaled by the program with reasonable values.
.IP "xaxis label" 20
Place the text string 
.I label,
which may be several words, horizontally below the x axis.
.IP "yaxis label" 20
Place the text string
.I label
vertically (reading upwards) to the left of the y axis.
.IP "title label" 20
Place the string
.I label
above the graph and centered on it.
.IP "position [ xp yp ]" 20
If two numeric arguments are given, move 
the current text position to the location 
.I "(xp, yp)"
on the graph. Both 
.I xp
and
.I yp
must be in the current graph coordinates (i.e. if x runs from 1 to 6
and y from 4 to 12, one might say
.I "position 2 11"
to move into the upper left-hand corner of the plot.
If no arguments, report the current text position.
.IP "label text" 20
Place the string
.I text,
which may be more than one word, at the current text position on the
graph. If the current position is not inside the plot boundaries,
do nothing.
.IP reverse 20
Applies only to the graphics window of the screen. Reverse the color of
the screen so that what was previously black is white and the white is
black.
.PP
The following commands are used only with attached external hardcopy devices
such as printer.
.IP printer 20
Open the printer workstation for hardcopy plots. All subsequent commands
issued will be sent to the printer as well as the screen until
.I noprinter
command is issued.
.IP noprinter 20
Close the printer workstation.
.IP dump 20
Take a screen dump. The content of the graphics window is sent to the
printer.
.IP update 20
All graphics commands which have been given since the last
.I update
or
.I clear
are sent to the external device; thus, successive calls to 
.I update 
will separate hardcopy plots on the external device.
Note, however, that actual hardcopy is not produced at this
time, but only queued; actual printing takes place after the
workstation is closed via the 
.I quit
command.

.SH BUGS
.PP
The
.I dump
command is device dependent.
.PP
Hardcopy is not produced immediately after each
.I update
or
.I clear,
but only after the workstation is closed via
.I quit.
This seems to be a GSS_Drivers "feature," but it might be possible
to flush output to external devices via some system call - it certainly
would be nice.
.PP
In the current version, the windows, once created, cannot be moved or
resized.
.SH AUTHORS
.PP
Ann Takata and Michael Richmond. Send mail to astrovax!richmon.

