/* The array charvec contains vectors for drawing the printable
 * ASCII character set, plus five special characters.
 *
 * Lines with an x coordinate of -2 indicate the beginning of
 * a character with decimal value of the corresponding y coordinate.
 * The first coordinate is moved to ( with pen up), the rest
 * are drawn (with pen down), unless a point of -1, -1 is encountered.
 * This means the next point is a move.
 *
 * These vectors are for characters to be drawn in the first quadrant
 * of a rectangular coordinate system.  Rotations can be achieved by applying
 * the appropriate trigonometric functions.
 *
 * The array vecptrs contains pointers into charvec --
 *
 * the vectors for the nth ASCII character start at charvec[vecptrs[n-32]].
 *
 * xdim and ydim are the size of the character cell. xdim should be
 * sufficiently large to include spacing between characters.
 *
 */

int charvec [][2]{
	-2, 32,
	-2, 33,
	 1, 2,
	 1, 3,
	 0, 3,
	 0, 2,
	 1, 2,
	-1, -1,
	 1, 10,
	 0, 10,
	 0, 4,
	 1, 10,
	-2, 34,
	 0, 10,
	 1, 8,
	 1, 10,
	 0, 10,
	-1, -1,
	 3, 10,
	 2, 10,
	 2, 8,
	 3, 10,
	-2, 35,
	 0, 2,
	 2, 10,
	-1, -1,
	 2, 2,
	 4, 10,
	-1, -1,
	 0, 7,
	 4, 7,
	-1, -1,
	 0, 5,
	 4, 5,
	-2, 36,
	 2, 2,
	 2, 10,
	-1, -1,
	 0, 4,
	 1, 3,
	 3, 3,
	 4, 4,
	 4, 5,
	 3, 6,
	 1, 6,
	 0, 7,
	 0, 8,
	 1, 9,
	 3, 9,
	 4, 8,
	-2, 37,
	 1, 10,
	 0, 9,
	 1, 8,
	 2, 9,
	 1, 10,
	 4, 10,
	 0, 2,
	 3, 2,
	 2, 3,
	 3, 4,
	 4, 3,
	 3, 2,
	-2, 38,
	 4, 2,
	 0, 8,
	 0, 9,
	 1, 10,
	 2, 10,
	 3, 9,
	 3, 8,
	 0, 5,
	 0, 3,
	 1, 2,
	 2, 2,
	 4, 6,
	-2, 39,
	 1, 10,
	 0, 8,
	 0, 10,
	 1, 10,
	-2, 40,
	 1, 10,
	 0, 8,
	 0, 4,
	 1, 2,
	-2, 41,
	 0, 10,
	 1, 8,
	 1, 4,
	 0, 2,
	-2, 42,
	 2, 3,
	 2, 9,
	-1, -1,
	 4, 8,
	 0, 4,
	-1, -1,
	 0, 8,
	 4, 4,
	-2, 43,
	 2, 3,
	 2, 9,
	-1, -1,
	 0, 6,
	 4, 6,
	-2, 44,
	 1, 3,
	 0, 3,
	 0, 1,
	 1, 3,
	-2, 45,
	 0, 6,
	 4, 6,
	-2, 46,
	 1, 3,
	 0, 3,
	 0, 2,
	 1, 2,
	 1, 3,
	-2, 47,
	 0, 2,
	 3, 10,
	-2, 48,
	 4, 9,
	 3, 10,
	 1, 10,
	 0, 9,
	 0, 3,
	 1, 2,
	 3, 2,
	 4, 3,
	 4, 9,
	-2, 49,
	 0, 8,
	 1, 10,
	 1, 2,
	-2, 50,
	 0, 9,
	 1, 10,
	 3, 10,
	 4, 9,
	 4, 6,
	 3, 5,
	 1, 5,
	 0, 4,
	 0, 2,
	 4, 2,
	-2, 51,
	 0, 9,
	 1, 10,
	 3, 10,
	 4, 9,
	 4, 7,
	 3, 6,
	 1, 6,
	 3, 6,
	 4, 5,
	 4, 3,
	 3, 2,
	 1, 2,
	 0, 3,
	-2, 52,
	 3, 2,
	 3, 10,
	 0, 4,
	 4, 4,
	-2, 53,
	 0, 3,
	 1, 2,
	 3, 2,
	 4, 3,
	 4, 6,
	 3, 7,
	 1, 7,
	 0, 6,
	 0, 10,
	 4, 10,
	-2, 54,
	 0, 5,
	 1, 6,
	 3, 6,
	 4, 5,
	 4, 3,
	 3, 2,
	 1, 2,
	 0, 3,
	 0, 9,
	 1, 10,
	 3, 10,
	 4, 9,
	-2, 55,
	 0, 10,
	 4, 10,
	 0, 2,
	-2, 56,
	 1, 6,
	 3, 6,
	 4, 7,
	 4, 9,
	 3, 10,
	 1, 10,
	 0, 9,
	 0, 7,
	 1, 6,
	 0, 5,
	 0, 3,
	 1, 2,
	 3, 2,
	 4, 3,
	 4, 5,
	 3, 6,
	-2, 57,
	 0, 3,
	 1, 2,
	 3, 2,
	 4, 3,
	 4, 9,
	 3, 10,
	 1, 10,
	 0, 9,
	 0, 7,
	 1, 6,
	 3, 6,
	 4, 7,
	-2, 58,
	 1, 3,
	 0, 3,
	 0, 2,
	 1, 2,
	 1, 3,
	-1, -1,
	 1, 6,
	 0, 6,
	 0, 7,
	 1, 7,
	 1, 6,
	-2, 59,
	 1, 3,
	 0, 3,
	 0, 1,
	 1, 3,
	-1, -1,
	 1, 6,
	 0, 6,
	 0, 7,
	 1, 7,
	 1, 6,
	-2, 60,
	 4, 9,
	 0, 6,
	 4, 3,
	-2, 61,
	 0, 5,
	 4, 5,
	-1, -1,
	 0, 7,
	 4, 7,
	-2, 62,
	 0, 9,
	 4, 6,
	 0, 3,
	-2, 63,
	 0, 9,
	 1, 10,
	 3, 10,
	 4, 9,
	 4, 7,
	 1, 4,
	-1, -1,
	 2, 3,
	 2, 2,
	 1, 2,
	 1, 3,
	 2, 3,
	-2, 64,
	 3, 7,
	 2, 8,
	 1, 7,
	 1, 5,
	 2, 4,
	 3, 5,
	 3, 8,
	-1, -1,
	 3, 5,
	 4, 4,
	 4, 8,
	 3, 9,
	 1, 9,
	 0, 8,
	 0, 4,
	 1, 3,
	 4, 3,
	-2, 65,
	 1, 6,
	 3, 6,
	-1, -1,
	 0, 2,
	 2, 10,
	 4, 2,
	-2, 66,
	 0, 6,
	 3, 6,
	 4, 7,
	 4, 9,
	 3, 10,
	 0, 10,
	 0, 2,
	 3, 2,
	 4, 3,
	 4, 5,
	 3, 6,
	-2, 67,
	 4, 9,
	 3, 10,
	 1, 10,
	 0, 9,
	 0, 3,
	 1, 2,
	 3, 2,
	 4, 3,
	-2, 68,
	 4, 9,
	 3, 10,
	 0, 10,
	 0, 2,
	 3, 2,
	 4, 3,
	 4, 9,
	-2, 69,
	 0, 6,
	 2, 6,
	-1, -1,
	 4, 10,
	 0, 10,
	 0, 2,
	 4, 2,
	-2, 70,
	 0, 6,
	 2, 6,
	-1, -1,
	 0, 2,
	 0, 10,
	 4, 10,
	-2, 71,
	 2, 5,
	 4, 5,
	 4, 3,
	 3, 2,
	 1, 2,
	 0, 3,
	 0, 9,
	 1, 10,
	 3, 10,
	 4, 9,
	-2, 72,
	 0, 2,
	 0, 10,
	-1, -1,
	 0, 6,
	 4, 6,
	-1, -1,
	 4, 2,
	 4, 10,
	-2, 73,
	 0, 10,
	 2, 10,
	-1, -1,
	 1, 10,
	 1, 2,
	-1, -1,
	 0, 2,
	 2, 2,
	-2, 74,
	 0, 5,
	 0, 3,
	 1, 2,
	 3, 2,
	 4, 3,
	 4, 10,
	-2, 75,
	 0, 2,
	 0, 10,
	-1, -1,
	 0, 6,
	 4, 10,
	-1, -1,
	 1, 7,
	 4, 2,
	-2, 76,
	 0, 10,
	 0, 2,
	 4, 2,
	-2, 77,
	 0, 2,
	 0, 10,
	 2, 6,
	 4, 10,
	 4, 2,
	-2, 78,
	 0, 2,
	 0, 10,
	 4, 2,
	 4, 10,
	-2, 79,
	 4, 9,
	 3, 10,
	 1, 10,
	 0, 9,
	 0, 3,
	 1, 2,
	 3, 2,
	 4, 3,
	 4, 9,
	-2, 80,
	 0, 2,
	 0, 10,
	 3, 10,
	 4, 9,
	 4, 7,
	 3, 6,
	 0, 6,
	-2, 81,
	 4, 3,
	 4, 9,
	 3, 10,
	 1, 10,
	 0, 9,
	 0, 3,
	 1, 2,
	 3, 2,
	 4, 3,
	-1, -1,
	 3, 4,
	 4, 2,
	-2, 82,
	 0, 2,
	 0, 10,
	 3, 10,
	 4, 9,
	 4, 7,
	 3, 6,
	 0, 6,
	-1, -1,
	 3, 6,
	 4, 2,
	-2, 83,
	 0, 3,
	 1, 2,
	 3, 2,
	 4, 3,
	 4, 5,
	 3, 6,
	 1, 6,
	 0, 7,
	 0, 9,
	 1, 10,
	 3, 10,
	 4, 9,
	-2, 84,
	 2, 2,
	 2, 10,
	-1, -1,
	 0, 10,
	 4, 10,
	-2, 85,
	 0, 10,
	 0, 3,
	 1, 2,
	 3, 2,
	 4, 3,
	 4, 10,
	-2, 86,
	 0, 10,
	 2, 2,
	 4, 10,
	-2, 87,
	 0, 10,
	 1, 2,
	 2, 6,
	 3, 2,
	 4, 10,
	-2, 88,
	 0, 10,
	 4, 2,
	-1, -1,
	 0, 2,
	 4, 10,
	-2, 89,
	 0, 10,
	 2, 6,
	-1, -1,
	 2, 2,
	 2, 6,
	 4, 10,
	-2, 90,
	 0, 10,
	 4, 10,
	 0, 2,
	 4, 2,
	-2, 91,
	 2, 10,
	 0, 10,
	 0, 2,
	 2, 2,
	-2, 92,
	 0, 10,
	 3, 2,
	-2, 93,
	 0, 10,
	 2, 10,
	 2, 2,
	 0, 2,
	-2, 94,
	 1, 3,
	 1, 9,
	-1, -1,
	 0, 7,
	 1, 9,
	 2, 7,
	-2, 95,
	 1, 7,
	 0, 6,
	 1, 5,
	-1, -1,
	 0, 6,
	 4, 6,
	-2, 96,
	 2, 8,
	 1, 10,
	 0, 9,
	 2, 8,
	-2, 97,
	 3, 6,
	 2, 7,
	 1, 7,
	 0, 6,
	 0, 3,
	 1, 2,
	 2, 2,
	 3, 3,
	 3, 2,
	 3, 7,
	-2, 98,
	 0, 10,
	 0, 2,
	 0, 3,
	 1, 2,
	 2, 2,
	 3, 3,
	 3, 6,
	 2, 7,
	 1, 7,
	 0, 6,
	-2, 99,
	 3, 6,
	 2, 7,
	 1, 7,
	 0, 6,
	 0, 3,
	 1, 2,
	 2, 2,
	 3, 3,
	-2, 100,
	 3, 10,
	 3, 2,
	 3, 3,
	 2, 2,
	 1, 2,
	 0, 3,
	 0, 6,
	 1, 7,
	 2, 7,
	 3, 6,
	-2, 101,
	 0, 5,
	 3, 5,
	 3, 6,
	 2, 7,
	 1, 7,
	 0, 6,
	 0, 3,
	 1, 2,
	 2, 2,
	 3, 3,
	-2, 102,
	 0, 7,
	 2, 7,
	-1, -1,
	 0, 2,
	 0, 9,
	 1, 10,
	 2, 10,
	 3, 9,
	-2, 103,
	 3, 7,
	 3, 1,
	 2, 0,
	 1, 0,
	 0, 1,
	-1, -1,
	 3, 6,
	 2, 7,
	 1, 7,
	 0, 6,
	 0, 3,
	 1, 2,
	 2, 2,
	 3, 3,
	-2, 104,
	 0, 10,
	 0, 2,
	-1, -1,
	 0, 6,
	 1, 7,
	 2, 7,
	 3, 6,
	 3, 2,
	-2, 105,
	 0, 9,
	 0, 9,
	-1, -1,
	 0, 7,
	 0, 2,
	-2, 106,
	 0, 1,
	 1, 0,
	 2, 1,
	 2, 7,
	-1, -1,
	 2, 9,
	 2, 9,
	-2, 107,
	 0, 10,
	 0, 2,
	-1, -1,
	 0, 4,
	 3, 7,
	-1, -1,
	 1, 5,
	 3, 2,
	-2, 108,
	 0, 10,
	 0, 2,
	-2, 109,
	 0, 2,
	 0, 7,
	 0, 6,
	 1, 7,
	 2, 6,
	 2, 2,
	-1, -1,
	 2, 6,
	 3, 7,
	 4, 6,
	 4, 2,
	-2, 110,
	 0, 2,
	 0, 7,
	 0, 6,
	 1, 7,
	 2, 7,
	 3, 6,
	 3, 2,
	-2, 111,
	 3, 6,
	 2, 7,
	 1, 7,
	 0, 6,
	 0, 3,
	 1, 2,
	 2, 2,
	 3, 3,
	 3, 6,
	-2, 112,
	 0, 7,
	 0, 0,
	 0, 3,
	 1, 2,
	 2, 2,
	 3, 3,
	 3, 6,
	 2, 7,
	 1, 7,
	 0, 6,
	-2, 113,
	 3, 0,
	 3, 7,
	 3, 6,
	 2, 7,
	 1, 7,
	 0, 6,
	 0, 3,
	 1, 2,
	 2, 2,
	 3, 3,
	-2, 114,
	 0, 2,
	 0, 7,
	 0, 6,
	 1, 7,
	 2, 7,
	-2, 115,
	 0, 3,
	 1, 2,
	 2, 2,
	 3, 3,
	 3, 4,
	 2, 5,
	 1, 5,
	 0, 6,
	 1, 7,
	 2, 7,
	 3, 6,
	-2, 116,
	 0, 7,
	 3, 7,
	-1, -1,
	 1, 10,
	 1, 3,
	 2, 2,
	 3, 3,
	-2, 117,
	 0, 7,
	 0, 3,
	 1, 2,
	 2, 2,
	 3, 3,
	 3, 2,
	 3, 7,
	-2, 118,
	 0, 7,
	 1, 2,
	 2, 2,
	 3, 7,
	-2, 119,
	 0, 7,
	 1, 2,
	 2, 5,
	 3, 2,
	 4, 7,
	-2, 120,
	 0, 7,
	 3, 2,
	-1, -1,
	 0, 2,
	 3, 7,
	-2, 121,
	 0, 7,
	 0, 3,
	 1, 2,
	 2, 2,
	 3, 3,
	 3, 7,
	 3, 1,
	 2, 0,
	 1, 0,
	 0, 1,
	-2, 122,
	 0, 7,
	 3, 7,
	 0, 2,
	 3, 2,
	-2, 123,
	 2, 11,
	 1, 10,
	 1, 7,
	 0, 6,
	 1, 5,
	 1, 2,
	 2, 1,
	-2, 124,
	 0, 10,
	 0, 7,
	-1, -1,
	 0, 5,
	 0, 2,
	-2, 125,
	 0, 1,
	 1, 2,
	 1, 5,
	 2, 6,
	 1, 7,
	 1, 10,
	 0, 11,
	-2, 126,
	 0, 8,
	 1, 9,
	 2, 8,
	 3, 9,
	-2, 127,
	-2, 128,
	 4, 4,
	 0, 4,
	 2, 9,
	 4, 4,
	-2, 129,
	 0, 9,
	 4, 3,
	-1, -1,
	 0, 3,
	 4, 9,
	-2, 130,
	 4, 6,
	 2, 3,
	 0, 6,
	 2, 9,
	 4, 6,
	-2, 131,
	 4, 7,
	 0, 7,
	 3, 3,
	 2, 9,
	 1, 3,
	 4, 7,
	-2, 132,
	 4, 9,
	 0, 9,
	 0, 3,
	 4, 3,
	 4, 9,
	-2, 133,
	 4, 7,
	 2, 9,
	 0, 7,
	 1, 4,
	 3, 4,
	 4, 7,
	-2, 134,
	 2, 3,
	 2, 9,
	-1, -1,
	 0, 6,
	 4, 6,
	-2, 135,
	 4, 9,
	 2, 8,
	 0, 9,
	 1, 6,
	 0, 3,
	 2, 4,
	 4, 3,
	 3, 6,
	 4, 9,
	-2, 136,
	 2, 9,
	 1, 6,
	 2, 3,
	 3, 6,
	 2, 9,
	-1, -1,
	 4, 6,
	 2, 7,
	 0, 6,
	 2, 5,
	 4, 6,
	-2, 137,
	 3, 9,
	 0, 6,
	 3, 3,
	 3, 9,
	-1, -1,
	 4, 6,
	 1, 9,
	 1, 3,
	 4, 6
};

int xdim 6;
int ydim 10;

int vecptrs[]{
	0, 1, 12, 22, 34, 50, 63, 76, 81, 86,
	91, 100, 106, 111, 114, 120, 123, 133, 137, 148,
	162, 167, 178, 191, 195, 212, 225, 237, 248, 252,
	258, 262, 275, 293, 300, 312, 321, 329, 337, 344,
	355, 364, 373, 380, 389, 393, 399, 404, 414, 422,
	435, 446, 459, 465, 472, 476, 482, 488, 495, 500,
	505, 508, 513, 520, 527, 532, 543, 554, 563, 574,
	585, 594, 609, 618, 624, 632, 641, 644, 656, 664,
	674, 685, 696, 702, 714, 722, 730, 735, 741, 747,
	758, 763, 771, 777, 785, 790, 791, 796, 802, 808,
	815, 821, 828, 834, 844, 856
};
