#-h-  cdefio                      255  ascii   10/14/81  13:27:06
 ## common block to hold pushed-back input characters
 #  put on a file called 'cdefio'
 #  used by ratfor, macro, roff

 common /cdefio/ bp, buf(BUFSIZE)
   integer bp      # next available character; init = 0
   character buf   # pushed-back characters
#-t-  cdefio                      255  ascii   10/14/81  13:27:06
#-h-  cexp                        272  ascii   10/14/81  13:27:06
 ## common for exptoi
 # put on a file called 'cexp'
 # Used by macro and dc tools
 common/cexp/ top, tokst(MAXSTACK), kindst(MAXSTACK)
 integer top	# evaluation stack pointer
 integer tokst	# eval stack part 1: tokens
 integer kindst # eval stack part 2: kinds of tokens
#-t-  cexp                        272  ascii   10/14/81  13:27:06
#-h-  cfiles                      243  ascii   10/14/81  13:27:06
 ## common block used to hold list of input files
 #  put on a file called 'cfiles'
 #  used by macro, roff

 common /cfiles/ infile(NFILES), level
   integer infile	# stack of file descriptors
   integer level	# current file is infile(level)
#-t-  cfiles                      243  ascii   10/14/81  13:27:06
#-h-  ctab                        129  ascii   10/14/81  13:27:06
 # common block for macro symbol table
 # place on file 'ctab'

 common /ctab/ mactbl
   pointer mactbl

 DS_DECL (mem, MEMSIZE)
#-t-  ctab                        129  ascii   10/14/81  13:27:06
#-h-  cmacro                      314  ascii   10/14/81  13:27:06
 ## common block to hold macro evaluation stack
 #  put on a file called 'cmacro'
 #  used by ratfor and by the macro tool

 common /cmacro/ cp, ep, evalst(EVALSIZE)
   integer cp         # current call stack pointer
   integer ep         # next free position in evalst
   character evalst      # evaluation stack
#-t-  cmacro                      314  ascii   10/14/81  13:27:06
#-h-  macro.r                   27078  ascii   10/14/81  13:27:08
#-h-  macro                      1893  local   12/19/80  16:11:39
# macro - expand macros in named files or standard input
 # include ratdef
define(MAXDEF,2500)     #max chars in a definition
define(MAXTOK,200)      #max chars in a token (word)
define(CALLSIZE,20)
define(ARGSIZE,100)
define(ARGFLAG,DOLLAR)
define(NFILES,arith(MAXOFILES,-,4))
define(DEFTYPE,-10)
define(IFTYPE,-11)
define(INCTYPE,-12)
define(SUBTYPE,-13)
define(EXPTYPE,-14)
define(ICLTYPE,-15)
define(LENTYPE,-16)
define(EVALSIZE,2500)
define(BUFSIZE,2500)
define(MEMSIZE,4000)

 #### definitions for arithmetic evaluation
 define(OP,1)
 define(OPND,2)
 define(SEP,3)
 define(OPDONE,1)
 define(OPGO,2)
 define(OPLP,3)
 define(OPRP,4)
 define(OPOR,5)
 define(OPAND,6)
 define(OPNOT,7)
 define(OPEQ,8)
 define(OPNE,9)
 define(OPGT,10)
 define(OPGE,11)
 define(OPLT,12)
 define(OPLE,13)
 define(OPADD,14)
 define(OPSUB,15)
 define(OPMUL,16)
 define(OPDIV,17)
 define(OPNEG,18)
 define(OPMOD,19)
 define(OPEXP,20)
 define(OPPLUS,21)
 define(MAXOP,21)
 define(OPERR,-1)
 define(MAXSTACK,30)  # evaluation stack

 DRIVER(macro)
   character arg(MAXLINE)
   integer open, getarg
   integer fd, i, nfiles, qflag
   data qflag /NO/   # default is no quoting at level 0

   call query ("usage:  macro [-0] [files].")
   call minit
   for (i = 1; getarg(i, arg, MAXNAME) ^= EOF; i = i + 1)
      if (arg(1) == MINUS & arg(2) == DIG0)
         qflag = YES
      else if (arg(1) == MINUS & arg(2) ^= EOS)
         call error("usage: macro [-0] [files].")
      else {
         nfiles = nfiles + 1
         if (arg(1) == MINUS)
            fd = STDIN
         else
            fd = open(arg, READ)
         if (fd == ERR) {
            call putlin(arg, ERROUT)
            call error(": can't open.")
            }
         call domacr(fd, qflag)
         if (fd ^= STDIN)
            call close(fd)
         }
   if (nfiles == 0)     # no args, do STDIN
      call domacr(STDIN, qflag)
  DRETURN
   end
#-t-  macro                      1893  local   12/19/80  16:11:39
#-h-  binop                      1253  local   12/19/80  16:11:40
 ## binop - evaluates top 3 items on eval stack
 subroutine binop

 integer l, r, result, op
 include cexp

 r = tokst(top)
 op = tokst(top-1)
 l = tokst(top-2)
 top = top - 2
 switch (op)
        {
        case OPOR: if (l != 0 | r != 0) result = 1
                   else result = 0
        case OPAND:if (l != 0 & r != 0) result = 1
                   else result = 0
        case OPNOT: if (r == 0) result = 1
                    else result = 0
        case OPEQ:  if (l == r) result = 1
                    else result = 0
        case OPNE:  if (l != r) result = 1
                    else result = 0
        case OPGT:  if (l > r) result = 1
                    else result = 0
        case OPGE:  if (l >= r) result = 1
                    else result = 0
        case OPLT:  if (l < r) result = 1
                    else result = 0
        case OPLE:  if (l <= r) result = 1
                    else result = 0
        case OPADD: result = l + r
        case OPSUB:  result = l - r
        case OPNEG:  result = (-r)
        case OPMUL:  result = l * r
        case OPDIV:  result = l / r
        case OPMOD:  result = mod(l,r)
        case OPEXP:  result = l**r
        case OPPLUS: result = (+r)
        }
 tokst(top) = result
 return
 end
#-t-  binop                      1253  local   12/19/80  16:11:40
#-h-  ctonum                      816  local   12/19/80  16:11:41
# ctonum - string to number with radix control
 integer function ctonum(buf,i,dradix)
 character buf(ARB), tmp(MAXLINE)
 integer ctoi
 integer i, j, c, n, val, radix, dradix
 string digits "0123456789abcdefABCDEF"

 for (n=0;;i=i+1)
        {       #collect digits
        c = index(digits,buf(i))
        if (c==0) break
        if (c > 16) c = c-6     # convert to lower case
        n = n+1
        tmp(n) = c-1            # save digit value
        }
 if (buf(i) == UNDERLINE)
        {       # get new radix, radix radix is 10.
        radix = 0
        i = i+1
        radix = ctoi(buf,i)
        }
 else radix = dradix
 val = 0
 for (j=1; j<=n; j = j+1)
        {
        c = tmp(j)
        if (c >= radix)
                call remark("number error")
        val = val * radix + c
        }
 return(val)
 end
#-t-  ctonum                      816  local   12/19/80  16:11:41
#-h-  dodef                       350  local   12/19/80  16:11:41
# dodef - install definition in table
   subroutine dodef(argstk, i, j)
   integer a2, a3, argstk(ARGSIZE), i, j, c
   character ngetc
   include cmacro

   if (j - i > 2) {
      a2 = argstk(i+2)
      a3 = argstk(i+3)
      call entdef(evalst(a2), evalst(a3))   # subarrays
      }
   if (ngetc(c) ^= NEWLINE)
      call putbak(c)
   return
   end
#-t-  dodef                       350  local   12/19/80  16:11:41
#-h-  doexpr                      361  local   12/19/80  16:11:42
# doexpr - evaluate infix expression
   subroutine doexpr(argstk, i, j)
   integer exptoi
   integer argstk(ARGSIZE), i, j, k
   include cmacro

   k = argstk(i+2)
   call pbnum(exptoi(evalst, k, 10))
   if (evalst(k) ^= EOS) {
      k = argstk(i+2)
      call putlin(evalst(k), ERROUT)
      call remark(": invalid infix expression.")
      }
   return
   end
#-t-  doexpr                      361  local   12/19/80  16:11:42
#-h-  doif                        408  local   12/19/80  16:11:42
# doif - select one of two arguments
   subroutine doif(argstk, i, j)
   integer equal
   integer a2, a3, a4, a5, argstk(ARGSIZE), i, j
   include cmacro

   if (j - i < 5)
      return
   a2 = argstk(i+2)
   a3 = argstk(i+3)
   a4 = argstk(i+4)
   a5 = argstk(i+5)
   if (equal(evalst(a2), evalst(a3)) == YES)   # subarrays
      call pbstr(evalst(a4))
   else
      call pbstr(evalst(a5))
   return
   end
#-t-  doif                        408  local   12/19/80  16:11:42
#-h-  doincl                      454  local   12/19/80  16:11:42
# doincl - include named file
   subroutine doincl(argstk, i, j)
   integer argstk(ARGSIZE), i, j
   integer k, open
   include cfiles
   include cmacro

   if (level + 1 > NFILES)
      call error("includs nested too deeply.")
   k = argstk(i+2)
   infile(level+1) = open(evalst(k), READ)
   if (infile(level+1) == ERR) {
      call putlin(evalst(k), ERROUT)
      call remark(": can't includ.")
      }
   else
      level = level + 1
   return
   end
#-t-  doincl                      454  local   12/19/80  16:11:42
#-h-  doincr                      321  local   12/19/80  16:11:43
# doincr - increment argument by 1
   subroutine doincr(argstk, i, j)
   integer ctoi, index
   integer argstk(ARGSIZE), i, j, k, m
   include cmacro

   k = argstk(i+2)
   m = index(evalst(k), MINUS)
   if (m == 0)
        call pbnum(ctoi(evalst,k) + 1)
   else
        call pbnum(1-ctoi(evalst,k + m))
   return
   end
#-t-  doincr                      321  local   12/19/80  16:11:43
#-h-  dolen                       212  local   12/19/80  16:11:44
# dolen - return length of argument
   subroutine dolen(argstk, i, j)
   integer length
   integer argstk(ARGSIZE), i, j, k
   include cmacro

   k = argstk(i+2)
   call pbnum(length(evalst(k)))
   return
   end
#-t-  dolen                       212  local   12/19/80  16:11:44
#-h-  domacr                     2621  local   12/19/80  16:11:45
# domacr - expand macros with arguments; read from fd, qflag YES do []
   subroutine domacr(fd, qflag)
   integer fd, qflag
   character gettok
   character defn(MAXDEF), t, token(MAXTOK)
   integer ludef, push
   integer ap, argstk(ARGSIZE), callst(CALLSIZE), nlb, plev(CALLSIZE)
   include cmacro
   include cdefio
   include cfiles
   string balp "()"

   cp = 0
   ap = 1
   ep = 1
   bp = 0
   level = 1
   infile(1) = fd
   for (t=gettok(token, MAXTOK); t ^= EOF; t=gettok(token, MAXTOK)) {
      if (t == ALPHA) {
         if (ludef(token, defn) == NO)
            call puttok(token)
         else {            # defined; put it in eval stack
            cp = cp + 1
            if (cp > CALLSIZE)
               call error("call stack overflow.")
            callst(cp) = ap
            ap = push(ep, argstk, ap)
            call puttok(defn)   # stack definition
            call putchr(EOS)
            ap = push(ep, argstk, ap)
            call puttok(token)   # stack name
            call putchr(EOS)
            ap = push(ep, argstk, ap)
            t = gettok(token, MAXTOK)   # peek at next
            call pbstr(token)
            if (t ^= LPAREN)   # add ( ) if not present
               call pbstr(balp)
            plev(cp) = 0
            }
         }
      else if (t == LBRACK & (cp > 0 | qflag == YES)) {
         nlb = 1               # strip one level of [ ]
         repeat {
            t = gettok(token, MAXTOK)
            if (t == LBRACK)
               nlb = nlb + 1
            else if (t == RBRACK) {
               nlb = nlb - 1
               if (nlb == 0)
                  break
               }
            else if (t == EOF)
               call error("EOF in string.")
            call puttok(token)
            }
         }
      else if (cp == 0)         # not in a macro at all
         call puttok(token)
      else if (t == LPAREN) {
         if (plev(cp) > 0)
            call puttok(token)
         plev(cp) = plev(cp) + 1
         }
      else if (t == RPAREN) {
         plev(cp) = plev(cp) - 1
         if (plev(cp) > 0)
            call puttok(token)
         else {            # end of argument list
            call putchr(EOS)
            call eval(argstk, callst(cp), ap-1)
            ap = callst(cp)   # pop eval stack
            ep = argstk(ap)
            cp = cp - 1
            }
         }
      else if (t == COMMA & plev(cp) == 1) {   # new arg
         call putchr(EOS)
         ap = push(ep, argstk, ap)
         }
      else
         call puttok(token)      # just stack it
      }
   if (cp ^= 0)
      call error("unexpected EOF.")
   return
   end
#-t-  domacr                     2621  local   12/19/80  16:11:45
#-h-  dosub                       667  local   12/19/80  16:11:45
# dosub - select substring
   subroutine dosub(argstk, i, j)
   integer ctoi, length, min
   integer ap, argstk(ARGSIZE), fc, i, j, k, nc
   include cmacro

   if (j - i < 3)
      return
   if (j - i < 4)
      nc = MAXTOK
   else {
      k = argstk(i+4)
      nc = ctoi(evalst, k)      # number of characters
      }
   k = argstk(i+3)         # origin
   ap = argstk(i+2)         # target string
   fc = ap + ctoi(evalst, k) - 1   # first char of substring
   if (fc >= ap & fc < ap + length(evalst(ap))) {   # subarrays
      k = fc + min(nc, length(evalst(fc))) - 1
      for ( ; k >= fc; k = k - 1)
         call putbak(evalst(k))
      }
   return
   end
#-t-  dosub                       667  local   12/19/80  16:11:45
#-h-  entdef                      543  local   12/19/80  16:11:46
# entdef - enter name and definition in macro table

   subroutine entdef (name, defn)
   character name (ARB), defn (ARB)

   include ctab

   integer i
   integer length, lookup

   pointer locn
   pointer dsget

   if (lookup (name, locn, mactbl) == YES)
      call dsfree (locn)      # clobber old definition, if any

   locn = dsget (length (defn) + 1)
   call enter (name, locn, mactbl)
   i = 1
   while (defn (i) != EOS) {
      mem (locn) = defn (i)
      locn = locn + 1
      i = i + 1
      }
   mem (locn) = EOS

   return
   end
#-t-  entdef                      543  local   12/19/80  16:11:46
#-h-  eval                       1305  local   12/19/80  16:11:46
# eval - expand args i through j: evaluate builtin or push back defn
   subroutine eval(argstk, i, j)
   integer index, length
   integer argno, argstk(ARGSIZE), i, j, k, m, n, t, td
   include cmacro
   string digits "0123456789"

   t = argstk(i)
   td = evalst(t)
   if (td == DEFTYPE)
      call dodef(argstk, i, j)
   else if (td == INCTYPE)
      call doincr(argstk, i, j)
   else if (td == SUBTYPE)
      call dosub(argstk, i, j)
   else if (td == IFTYPE)
      call doif(argstk, i, j)
   else if (td == EXPTYPE)
      call doexpr(argstk, i, j)
   else if (td == ICLTYPE)
      call doincl(argstk, i, j)
   else if (td == LENTYPE)
      call dolen(argstk, i, j)
   else {
      for (k = t+length(evalst(t))-1; k > t; k = k - 1)
         if (evalst(k-1) ^= ARGFLAG)
            call putbak(evalst(k))
         else {
            argno = index(digits, evalst(k)) - 1
            if (argno < 0)
               call putbak(evalst(k))
            else if (argno < j-i) {
               n = i + argno + 1
               m = argstk(n)
               call pbstr(evalst(m))
               k = k - 1   # skip over $
               }
            else
               k = k - 1   # skip over $
            }
      if (k == t)         # do last character
         call putbak(evalst(k))
      }
   return
   end
#-t-  eval                       1305  local   12/19/80  16:11:46
#-h-  exptoi                     3616  local   12/19/80  16:11:47
 ## exptoi - evalutate arithmetic expression
 integer function exptoi (exp, ptr, radix)

 integer exptok, stackx
 character exp(ARB)
 integer ptr, radix
 integer k, tok, kind, preced(MAXOP)
 include cexp

 # precedence of respective operators
 data preced(1), preced(2), preced(3), preced(4), preced(5),
      preced(6), preced(7), preced(8), preced(9), preced(10),
      preced(11), preced(12), preced(13), preced(14), preced(15),
      preced(16), preced(17), preced(18),
      preced(19), preced(20), preced(21) / 0,  0,   # EOS, start_expr
        1,  1,          # (  )
        2,  2,          # |  &
        3,              # ! (or ^ or ~)
        4,4,4,4,4,4,    # == != > >= < <=
        5,  5,          # +  -
        6,  6,          # *  /
        8,  6,  7, 8      /# neg, mod, expon, plus


 k = ptr
 top = 1
 tokst(top) = OPGO
 kindst(top) = SEP

 while (exptok(exp, k, tok, kind, radix) == YES) #loop thru legal toks
        {
        if (kind == OPND)
                {
                if (kindst(top) == OPND)
                        return(0)
                }
        else if (kind == OP)
                {
                if (kindst(top) == OP)
                        return(0)
                else if (kindst(top) == SEP)
                        {       #check for unary +,- or !
                        if (tok != OPADD & tok != OPSUB & tok != OPNOT)
                                return(0)
                        if (stackx(0, OPND) == ERR)
                                return(0)
                        if (tok == OPADD)
                                tok = OPPLUS
                        else if (tok == OPSUB)
                                tok = OPNEG
                        }
                else    #kindst(top) == OPND
                        {
                        if (kindst(top-1) == OP)
                                {
                                while(preced(tokst(top-1)) >= preced(tok))
                                        call binop
                                }
                        }
                }
        else # (kind == SEP)
                {
                if (tok != OPLP)        #if tok == ( or tok == EOS
                        {
                        if (kindst(top) != OPND)
                                return(0)
                        while(preced(tokst(top-1)) > preced(tok))
                                {
                                if (kindst(top-1) == OP)
                                        call binop
                                else
                                        return(0)  # no right paren
                                }
                        if (preced(tokst(top-1)) == preced(tok))
                                {
                                if (tok == OPDONE)
                                        {
                                        ptr = k    #normal return
                                        return(tokst(top))
                                        }
                                else    #remove matching LPAREN
                                        {
                                        tok = tokst(top)
                                        kind = kindst(top)
                                        top = top -2
                                        }
                                }
                        else    #unbalanced parens
                                return(0)
                        }
                }
        # stack new tok, kind
        if (stackx(tok, kind) == ERR)
                return(0)
        }
 return(0)
 end
#-t-  exptoi                     3616  local   12/19/80  16:11:47
#-h-  exptok                     3672  local   12/19/80  16:11:48
 ## exptok - get expression token for evaluation
 integer function exptok(exp, k, tok, kind, radix)
 character exp(ARB), defn(MAXTOK), name(MAXTOK)
 integer k      #index, updated unless EOS
 integer tok    #return value, token found
 integer kind   #return value, kind of token
 integer radix  #default radix for numbers
 integer ctonum, ludef
 character type
 character c, cn
 include cexp
 string digits "0123456789abcdefABCDEF"

 c = type(exp(k))
 if (radix > 10)
        {
        if (index(digits,exp(k)) > 0) c = DIGIT
        }
 if (c == DIGIT)
        {
        tok = ctonum(exp, k, radix)
        kind = OPND
        return(YES)
        }
 else if (c == LETTER)
        {               #found stored variable name
        call movnam(exp, k, name, 1)
        k = k + length(name)
        if (ludef(name, defn) == YES)
                {
                i = 1
                tok = ctonum(defn, i, radix)
                kind = OPND
                return(YES)
                }
        else
                return(NO)
        }
 else           #c is symbol
        {
        cn = exp(k+1)
        kind = OP
        switch(c)
                {
                case TILDE:  if (cn == EQUALS)
                                {
                                tok = OPNE
                                k = k + 1
                                }
                         else tok = OPNOT
                case CARET:  if (cn == EQUALS)
                                {
                                tok = OPNE
                                k = k + 1
                                }
                         else tok = OPNOT
                case BANG:  if (cn == EQUALS)
                                {
                                tok = OPNE
                                k = k + 1
                                }
                         else tok = OPNOT
                case LESS:  if (cn == EQUALS)
                                {
                                tok = OPLE
                                k = k + 1
                                }
                         else tok = OPLT
                case GREATER:  if (cn == EQUALS)
                                {
                                tok = OPGE
                                k = k + 1
                                }
                         else tok = OPGT
                case EQUALS:  if (cn == EQUALS)
                                {
                                tok = OPEQ
                                k = k + 1
                                }
                         else tok = OPERR
                case BAR:  tok = OPOR
                case AMPER: tok  = OPAND
                case PLUS:  tok = OPADD
                case MINUS: tok = OPSUB
                case STAR:  if (cn == STAR)
                                {
                                tok = OPEXP
                                k = k + 1
                                }
                            else tok = OPMUL
                case SLASH: tok = OPDIV
                case PERCENT: tok = OPMOD
                case LPAREN: {
                             kind = SEP
                             tok = OPLP
                             }
                case RPAREN: {
                             kind = SEP
                             tok = OPRP
                             }
                case EOS:    {
                             kind = SEP
                             tok = OPDONE
                             }
                default:     tok = OPERR
                }

 if (tok == OPERR)
        return(NO)
 if (tok != OPDONE)
        k = k + 1
 return(YES)
 }
 end
#-t-  exptok                     3672  local   12/19/80  16:11:48
#-h-  gettok                      641  local   12/19/80  16:12:03
# gettok - get alphanumeric string or single non-alpha for define
   character function gettok(token, toksiz)
   character ngetc, type
   integer i, toksiz
   character token(toksiz)

   gettok = type(ngetc(token(1)))
   if (gettok ^= LETTER) {
      token(2) = EOS
      return
      }
   for (i = 2; i < toksiz; i = i + 1) {   # alphanumeric token
      gettok = type(ngetc(token(i)))
      if (gettok ^= LETTER & gettok ^= DIGIT & gettok ^= PERIOD &
          gettok ^= UNDERLINE)
         break
      }
   if (i >= toksiz)
      call error("token too long.")
   call putbak(token(i))
   gettok = ALPHA
   token(i) = EOS
   return
   end
#-t-  gettok                      641  local   12/19/80  16:12:03
#-h-  ludef                       456  local   12/19/80  16:12:03
# ludef - look up a macro name, return its definition (if found)

   integer function ludef (name, defn)
   character name (ARB), defn (ARB)

   include ctab

   integer i
   integer lookup

   pointer locn

   if (lookup (name, locn, mactbl) == NO) {
      defn (1) = EOS
      return (NO)
      }

   i = 1
   while (mem (locn) != EOS) {
      defn (i) = mem (locn)
      locn = locn + 1
      i = i + 1
      }
   defn (i) = EOS

   return (YES)
   end
#-t-  ludef                       456  local   12/19/80  16:12:03
#-h-  minit                      1451  local   12/19/80  16:12:03
# minit - initialize symbol table with built-in macros
   subroutine minit

   include ctab

   pointer mktabl

   integer deftyp(2)
   integer inctyp(2)
   integer subtyp(2)
   integer iftyp(2)
   integer exptyp(2)
   integer icltyp(2)
   integer lentyp(2)
   string defnam "define"
   string incnam "incr"
   string subnam "substr"
   string ifnam "ifelse"
   string expnam "expr"
   string iclnam "includ"
   string lennam "len"
   data deftyp(1) /DEFTYPE/, deftyp(2) /EOS/
   data inctyp(1) /INCTYPE/, inctyp(2) /EOS/
   data subtyp(1) /SUBTYPE/, subtyp(2) /EOS/
   data iftyp(1) /IFTYPE/, iftyp(2) /EOS/
   data exptyp(1) /EXPTYPE/, exptyp(2) /EOS/
   data icltyp(1) /ICLTYPE/, icltyp(2) /EOS/
   data lentyp(1) /LENTYPE/, lentyp(2) /EOS/

   call dsinit (MEMSIZE)
   mactbl = mktabl (1)
                        #install both upper and lower cases
   call entdef(defnam, deftyp)
   call upper(defnam)
   call entdef(defnam, deftyp)
   call entdef(incnam, inctyp)
   call upper(incnam)
   call entdef(incnam, inctyp)
   call entdef(subnam, subtyp)
   call upper(subnam)
   call entdef(subnam, subtyp)
   call entdef(ifnam, iftyp)
   call upper(ifnam)
   call entdef(ifnam, iftyp)
   call entdef(expnam, exptyp)
   call upper(expnam)
   call entdef(expnam, exptyp)
   call entdef(iclnam, icltyp)
   call upper(iclnam)
   call entdef(iclnam, icltyp)
   call entdef(lennam, lentyp)
   call upper(lennam)
   call entdef(lennam, lentyp)
 return
   end
#-t-  minit                      1451  local   12/19/80  16:12:03
#-h-  movnam                      371  local   12/19/80  16:12:04
 ## movnam - move in(i) to out(j) until non-alphanumeric found
 subroutine movnam (in, i, out, j)
 character in(ARB), out(ARB)
 integer i, j, k1, k2
 character type
 character c

 k1 = i
 k2 = j
 for(c=type(in(k1)); c == LETTER | c == DIGIT; c=type(in(k1)))
        {
        out(k2) = in(k1)
        k1 = k1 + 1
        k2 = k2 + 1
        }
 out(k2) = EOS
 return
 end
#-t-  movnam                      371  local   12/19/80  16:12:04
#-h-  ngetc                       479  local   12/19/80  16:12:05
# ngetc - get a (possibly pushed back) character
   character function ngetc(c)
   character getch
   character c
   include cdefio
   include cfiles

   if (bp > 0)
      c = buf(bp)
   else {
      bp = 1
      for (; level > 0; level = level - 1) {
         if (getch(c, infile(level)) ^= EOF)
            break
         if (level > 1)
            call close(infile(level))
         }
      buf(bp) = c
      }
   if (c ^= EOF)
      bp = bp - 1
   ngetc = c
   return
   end
#-t-  ngetc                       479  local   12/19/80  16:12:05
#-h-  pbnum                       206  local   12/19/80  16:12:05
# pbnum - convert number to string, push back on input
   subroutine pbnum(n)
   integer itoc
   character buf(MAXCHARS)
   integer junk

  junk = itoc(n, buf, MAXCHARS)
   call pbstr(buf)
   return
   end
#-t-  pbnum                       206  local   12/19/80  16:12:05
#-h-  pbstr                       203  local   12/19/80  16:12:05
# pbstr - push string back onto input
   subroutine pbstr(in)
   character in(MAXLINE)
   integer length
   integer i

   for (i = length(in); i > 0; i = i - 1)
      call putbak(in(i))
   return
   end
#-t-  pbstr                       203  local   12/19/80  16:12:05
#-h-  push                        243  local   12/19/80  16:12:06
# push - push ep onto argstk, return new pointer ap
   integer function push(ep, argstk, ap)
   integer ap, argstk(ARGSIZE), ep

   if (ap > ARGSIZE)
      call error("arg stack overflow.")
   argstk(ap) = ep
   push = ap + 1
   return
   end
#-t-  push                        243  local   12/19/80  16:12:06
#-h-  putbak                      221  local   12/19/80  16:12:06
# putbak - push character back onto input
   subroutine putbak(c)
   character c
   include cdefio

   bp = bp + 1
   if (bp > BUFSIZE)
      call error("too many characters pushed back.")
   buf(bp) = c
   return
   end
#-t-  putbak                      221  local   12/19/80  16:12:06
#-h-  putchr                      304  local   12/19/80  16:12:06
# putchr - put single char on output or into evaluation stack
   subroutine putchr(c)
   character c
   include cmacro

   if (cp == 0)
      call putc(c)
   else {
      if (ep > EVALSIZE)
         call error("evaluation stack overflow.")
      evalst(ep) = c
      ep = ep + 1
      }
   return
   end
#-t-  putchr                      304  local   12/19/80  16:12:06
#-h-  puttok                      198  local   12/01/80  15:54:34
# puttok-put token into eval stack

    subroutine puttok (str)
    character str (MAXTOK)

    integer i

    for (i = 1; str (i) != EOS; i = i + 1)
       call putchr (str (i))
    return
    end
#-h-  stackx                      320  local   12/19/80  16:12:07
 ## stackx - put next expression on arith evaluation stack
 integer function stackx(tok, kind)
 integer tok, kind

 include cexp

 if (top >= MAXSTACK)
        {
        call remark ("arith evaluation stack overflow.")
        return (ERR)
        }
 top = top + 1
 tokst(top) = tok
 kindst(top) = kind
 return(OK)
 end
#-t-  stackx                      320  local   12/19/80  16:12:07
#-t-  macro.r                   27078  ascii   10/14/81  13:27:08
