# include "mfile2"
/*
 * The functions in this file handle construction of addresses and constants
 */
# define BITMASK(n)	((1L<<n)-1)
# define LAC	'!'
# define LITERAL	'$'
# define LONG_FORMAT	"%DL"
# define NAME_FORMAT	"%.8s"
# define NORM_FORMAT	"%D"
# define OCTAL_FORMAT	"0%O"
/*
 * Print a constant address
 */
adrcon(val)
	CONSZ	val;
{
	printf(NORM_FORMAT, val);
}
/*
 * Output a constant for the code tables
 */
conput(p)
	register NODE	*p;
{
	comput(p);
}
/*
 * Output addresses for the upper portion of a long
 */
upput(p)
	register NODE	*p;
{
	CONSZ	save;
	register TWORD	tsave;
	if(p->op == FLD)
		p = p->left;
	save = p->lval;
	switch(p->op){
		case NAME:
		case OREG:
			p->lval++;
			break;
		case ICON:
			/*
			 * Blasted longs on the /6
			 */
			tsave = p->type;
			p->lval &= BITMASK(SZINT-1);
			p->type = INT;	/* that's good enough */
			adrput(p);
			p->type = tsave;
			goto restore;
		default:
			cerror("illegal upper address op %s", opst[p->op]);
	}
	adrput(p);
restore:
	p->lval = save;
}
/*
 * Output addresses for the node p
 */
adrput(p)
	register NODE	*p;
{
	register SHAPESZ	ty;

	if(p->op == FLD)
		p = p->left;
	switch(p->op){
		case NAME:
			putchar(LAC);
			break;
		case ICON:
			if (bptype(p->type) && p->name[0] != '\0')
				putchar('#');
			else
				putchar(LITERAL);
			break;
		case REG:
			printf("%s", rnames[p->rval]);
			return;
		case OREG:
			putchar(LAC);
			break;
		case UNARY MUL:
			ty = shumul(p);
			if (ty == STIREG || ty == STJREG) {
				printf("%c0,%s", LAC, rnames[p->left->rval]);
				return;
			}
			printf("*%c", LAC);
			p = p->left;
			break;
		default:
			cerror("illegal address");
			/* NOTREACHED */
	}
	comput(p);
}
/*
 * Output a constant address that may contain a name as well as a number
 */
acon(p)
register NODE *p;
{
	if(p->name[0] == '\0')
		adrcon(p->lval);
	else if(p->lval == 0)
		printf(NAME_FORMAT, p->name);
	else {
		printf(NAME_FORMAT, p->name);
		if (p->lval > 0)
			putchar('+');
		printf(NORM_FORMAT, p->lval);
	}
}
/*
 * Common code for adrput() and conput()
 */
static comput(p)
	register NODE	*p;
{
	register	o,
			bytes;
	CONSZ		words;
	switch(p->op) {
		case NAME:
			acon(p);
			return;
		case ICON:
			if (bptype(p->type)) {
				/*
				 * Handle bac addresses
				 */
				if (p->lval < 0) {
					bytes = 2+((p->lval+1)%3);
					words = ((p->lval+1)/3)-1;
				} else {
					bytes = p->lval%3;
					words = p->lval/3;
				}
				if (p->name[0] == '\0')
					printf(OCTAL_FORMAT, p->lval);
				else {
					printf(NAME_FORMAT, p->name);
					if (words) {
						if (words > 0)
							putchar('+');
						printf(NORM_FORMAT, words);
					}
					printf(",%d", bytes);
				}
			} else {
				if (p->name[0] == '\0') {
				 	if (p->type == LONG || p->type == ULONG)
						printf(LONG_FORMAT, p->lval);
					else
						adrcon(p->lval);
				} else
					acon(p);
			}
			return;
		case REG:
			printf("%s", rnames[p->rval]);
			return;
		case OREG:
			if(p->rval == Rk)
				if(p->name[0] != '\0')
					werror("bad arg temp");
			acon(p);
			printf(",%s", rnames[p->rval]);
			return;
		case UNARY MUL:		/* should be only for dacs */
			printf("*%c", LAC);
			comput(p->left);
			return;
		default:
			cerror("illegal comput operator %s", opst[p->op]);
	}
}
