/*
 *	OPQ - OPCTL
 *
 *		test to determine if a particular job is printing
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/dir.h>
#include <sys/stat.h>
#include "local.h"
#include "spool.h"

extern struct pr prt[];
extern struct pr *lastpr;
extern char jobf[];

#define	CMP(a,b)	(strncmp(a, b, sizeof(b)) == 0)

struct pr *
active(n)
register n;
{
	PR pr;

	for (printers)
		if (pr->pjob == n)
			return(pr);
	return((struct pr *)0);
}

getactive()
{
	struct job j;
	PR pr;
	register fd;

#ifdef	LOCK
	if ((fd = open(LPDLOCK, 0)) >= 0) {
		close(fd);
		return;
	}
#else
	if (access(LOCKFILE, 0) < 0)
		return;
#endif

	if ((fd = open(jobf, 0)) < 0)
		return;

	while (read(fd, &j, sizeof(j)) == sizeof(j)) {
		if (j.jnum == 0)
			continue;
		for (printers) {
			if (CMP(pr->class, j.jclass) && CMP(pr->prnm, j.pname)) {
				pr->pjob = j.jnum;
				break;
			}
		}
	}
	close(fd);
}
