#include	"mch.c"

statnode(np)
{
	register int *p, *p1, *p2;
	int *p3, l1, l2, l3;
	struct symtab *sp;
	if ((p = np) == 0)
		return;
	clrflgs();
	p1 = *++p;
	p2 = *++p;
	p3 = *++p;
	switch(*(p =- 3)) {
		case SLIST	:
			statnode(p1);
			statnode(p2);
			return;
		case S_IF	:
			switch(*p2) {
				case S_RETUR :
					if (*++p2) {
						l1 = nxtlab++;
						maincexp(p1, l1, FALSE);
						getretv(*p2);
						outlab(l1);
						if (p3)
							statnode(p3);
						return;
					} else
						l2 = lreturn;
					break;
				case S_LOOP :
					l2 = lloop;
					break;
				case S_BREAK :
					l2 = lbreak;
					break;
				case S_GOTO :
					l2 = gotonode(*++p2);
					break;
				default :
					l1 = nxtlab++;
					maincexp(p1, l1, FALSE);
					statnode(p2);
					if (p3) {
						outbranch(0, l2=nxtlab++);
						outlab(l1);
						statnode(p3);
						outlab(l2);
					} else
						outlab(l1);
					return;
			}
			if (!l2)
				mcerror("Incorrect use of loop/break");
			maincexp(p1, l2, TRUE);
			if (p3)
				statnode(p3);
			return;
		case S_FOR	:
			savlabs(&l1, &l2);
			if (p1) mainexp(p1);
			outlab(lloop);
			if (p2) maincexp(p2, lbreak, FALSE);
			if (p3 == 0) {
				statnode(*(p+4));
				outbranch(0, lloop);
			} else {
				l3 = lloop;
				lloop = nxtlab++;
				statnode(*(p+4));
				outlab(lloop);
				mainexp(p3);
				outbranch(0, l3);
			}
			outlab(lbreak);
			reslabs(l1, l2);
			return;
		case S_WHILE	:
			savlabs(&l1, &l2);
			outlab(lloop);
			maincexp(p1, lbreak, FALSE);
			statnode(p2);
			outbranch(0, lloop);
			outlab(lbreak);
			reslabs(l1, l2);
			return;
		case S_BREAK	:
			chklab(lbreak);
			return;
		case S_DO	:
			savlabs(&l1, &l2);
			outlab(l3 = nxtlab++);
			statnode(p1);
			outlab(lloop);
			maincexp(p2, l3, TRUE);
			outlab(lbreak);
			reslabs(l1, l2);
			return;
		case S_RETUR	:
			if (p1)
				getretv(p1);
			else
				outbranch(0, lreturn);
			return;
		case S_SWITC	:
			l1 = lbreak;
			lbreak = nxtlab++;
			tmark(p1);
			exprnode(p1);
			chkacca(ldaflg);
			swstat(p2);
			lbreak = l1;
			return;
		case S_CASE	:
			if (casp == 0)
				mcerror("Incorrect use of case");
			else {
				if (casp < castab+CASLEN) {
					casp->cas_lab = nxtlab;
					(casp++)->cas_val = p1;
					outlab(nxtlab++);
				} else
					mcerror("Too many cases");
			}
			statnode(p2);
			return;
		case S_DEFAU	:
			outlab(ldefault = nxtlab++);
			if (casp == 0)
				mcerror("Incorrect use of default");
			statnode(p1);
			return;
		case S_GOTO	:
			outbranch(0, gotonode(p1));
			return;
		case S_LOOP	:
			chklab(lloop);
			return;
		case LABNODE	:
			if ((sp = p1)->s_value == 0)
				sp->s_value = nxtlab++;
				outlab(sp->s_value);
			statnode(p2);
			return;
		case ASEMINS	:
			prasems(++p, p2);
			return;
		default		:
			mainexp(p);
	}
}


clrflgs()
{
	ldbflg = indflg = ldaflg = lastop = 0;
}

condjmp(op, label, cond)
{
	register char *format;
	if (cond)
		if (op & 1)
			op++;
		else
			op--;
/*may now generate jumps as if cond is false*/
	if (cevm) { 
		switch(op) {
			case NEQ :
				format = "\tjne\t1f\n\ttstb\n\tjeq\tL%d\n";
				break;
			case EQEQ :
				format = "\tjne\tL%d\n\ttstb\n\tjne\tL%d\n";
				break;
			case GE :
				format = cevm & 2 ?  "\tjcs\tL%d\n"  :
							"\tjlt\tL%d\n";
				break;
			case GT :
				format = cevm & 2 ? "\tjcs\tL%d\n\tjne\t1f\n\ttstb\n\tjeq\tL%d\n":
						"\tjlt\tL%d\n\tjne\t1f\n\ttstb\n\tjeq\tL%d\n";
				break;
			case LE :
				format = cevm & 2 ? "\tjhi\tL%d\n\tjcs\t1f\n\ttstb\n\tjne\tL%d\n":
						"\tjgt\tL%d\n\tjlt\t1f\n\ttstb\n\tjne\tL%d\n";
				break;
			case LT :
				format = cevm & 2 ? "\tjcs\t1f\n\tjbr\tL%d\n" :
						"\tjlt\t1f\n\tjbr\tL%d\n";
				break;
			default :
				finmsg("Compiler error(condjmp)");
		}
		printf(format, label, label);
		printf("1\n");
	} else 
		outbranch(op, label, FALSE);
}

outlab(l)
{
	lastsp = -1;
	printf("L%d\n", l);
}

outbranch(op, label, c)
{
	register char *cs;
	cs = (op ? jbrstr(op, c) : "jbr");
	printf("\t%s\tL%d\n", cs, label);
}

chklab(l)
{
	if (!l)
		mcerror("Incorrect use of loop/break");
	else
		outbranch(0, l);
}

exprnode(p)
int *p;
{
	register op, *p1, *p2;
	int l1;
	if ((op = *p & MASK) == 0)
		return;
	setcevm(p);
	p1 = *(p+1);
	p2 = *(p+2);
	switch(op) {
		case	CONST	:
		case	STRING	:
			load(op, p1);
			return;
		case	INCRA	:
		case	DECRA	:
			if (lvalue(*p1)) {
				load(*p1, *(p1+1));
				if ((op = *p1 & MASK) == UIND)
					p1 = *++p1;
				if (terminal(p1))
					outcode(p, *p1, *(p1+1), 0);
				else
					outcode(p, -2);
			}
			return;
		case	INCRB	:
		case	DECRB	:
			if (lvalue(*p1)) {
				outcode(p, *p1, *(p1+1), 0);
				if (terminal(p1)) 
					load(*p1, *(p1+1));
				else
					load(-2);
			}
			return;
		case	UCOMPL	:
			exprnode(p1);
			putm("comb");
			if (setcevm(p))
				putm("coma");
			break;
		case	UAND	:
			if (lvalue(*p1))
				ldadres(*p1, *(p1+1));
			return;
		case	UMINUS	:
			exprnode(p1);
			negate(setcevm(p));
			return;
		case	ULNEG	:
		case	LOGOR	:
		case	LOGAND	:
		case	EQEQ	:
		case	NEQ	:
		case	GE	:
		case	GT	:
		case	LT	:
		case	LE	:
			maincexp(p, l1 = nxtlab++, TRUE);
			putm("clrb\n\tclra");
			outbranch(0, nxtlab);
			outlab(l1);
			putm("ldab\t%1\n\tclra");
			outlab(nxtlab++);
			ldbflg = ldaflg = 1;
			return;
		case	PRCALL	:
			call(p1, p2);
			return;
		default	:
			if (op >= PLUS && op <= LSHIFT) {
				if (*p1 == CONST && *p2 == CONST) {
					*(p+1) = fold(op, *++p1, *++p2);
					*p = CONST;
					exprnode(p);
				} else
					diadop(p, p1, p2);
			} else
				if (op >= EQ && op <= EQLSH)
					asgnode(p, p1, p2);
				else
					if (lvalue(op))
						load(op, p1);
		}
}


diadop(opp, lexp, rexp)
{
	register *p, *p1, *p2;
	int t1, t2;
	p = opp;
	t1 = terminal((p1 = lexp));
	t2 = terminal((p2 = rexp));
	if (t1 && t2) {
		load(*p1, *(p1+1));
		outcode(p, *p2, *(p2+1), 1);
	} else
		if (t1) {
			switch(opp = (*p & MASK)) {
				case PLUS : case OR : case AND :
				case MUL : case UPARR : case MINUS :
					exprnode(p2);
					outcode(p, *p1, *(p1+1), 1);
					if (opp == MINUS)
						negate(cevm);
					return;
				default :
					load(*p1, *(p1+1));
					stkpsh();
					exprnode(p2);
					outcode(p, -1);
			}
		} else
			if (t2) {
				exprnode(p1);
				outcode(p, *p2, *(p2+1), 1);
			} else {
				if ((*p & MASK) == MINUS) {
					exprnode(p2);
					stkpsh();
					exprnode(p1);
				} else {
					exprnode(p1);
					stkpsh();
					exprnode(p2);
				}
				outcode(p, -1);
			}
}


gotonode(np)
{
	register struct symtab *sp;
	if ((sp=np)->s_class != LABEL)
		{ yyline = sp->s_dsiz; mcerror("label required");}
	if (sp->s_value == 0)
		sp->s_value = nxtlab++;
	return(sp->s_value);
}


condexp(p, labl, cond)
int *p;
{
	register op, *p1, *p2;
	int nxl, neqflg;
	setcevm(p);
	ldbflg = neqflg = 0;
	p1 = *(p+1);
	p2 = *(p+2);
	switch((op = *p & MASK)) {
		case	ULNEG	:
			condexp(p1, labl, !cond);
			return;
		case	LOGOR	:
			if (cond) {
				condexp(p1, labl, TRUE);
				condexp(p2, labl, TRUE);
			} else {
				condexp(p1, nxl = nxtlab++, TRUE);
				condexp(p2, labl, FALSE);
				outlab(nxl);
			}
			return;
		case	LOGAND	:
			if (cond) {
				condexp(p1, nxl = nxtlab++, FALSE);
				condexp(p2, labl, TRUE);
				outlab(nxl);
			} else {
				condexp(p1, labl, FALSE);
				condexp(p2, labl, FALSE);
			}
			return;
		default	:
			if (op < LT || op > NEQ) {
				exprnode(p);
				condjmp(NEQ, labl, cond);

			} else {
				compare(op, p1, labl, cond);
			}
		}
}


compare(rop, pm, labl, cond)
int  *pm;
{
/* do subtraction for comparison. rop=relational operator
	pm=subtraction node */
	register *p1, *p2, op;
	op = rop;
	p1 = *(pm+1);
	p2 = *(pm+2);
	if (terminal(p1) && !terminal(p2)) {
		/* reverse relation and operands of the subtraction */
		if (op & 1)
			++op;
		else
			--op;
		*(pm+1)= p2;
		*(pm+2)= p1;
	}
	exprnode(pm);	/* do the subtraction */
	condjmp(op, labl, cond);
}
