#
/*
 */

/*
 *	DZ-11 driver
 */
#include "../param.h"
#include "../conf.h"
#include "../user.h"
#include "../tty.h"
#include "../proc.h"

/* base address */
#define	DZADDR	0160100
#define NDZ11	8

/* dz11 bits */
/* rcsr - normal use of this register */
#define MSCAN	040
#define RXINTEN	0100
#define RXDONE	0200
#define TXLINE	03400
#define SIINTEN	010000
#define SIDONE	020000
#define TXINTEN	040000
#define TXDONE	0100000

/* rbuf - read only bits (NO byte operations, BIT or TST) */
#define	RXCHAR	0377
#define RXLINE	03400
#define RXPAR	010000
#define RXFRA	020000
#define RXOVR	040000
#define RXVALID	0100000

/* lpr bits   write only (NO byte operations, BIS or BIC) */
#define LPRLINE	07
#define LPRLENG	030
#define LPRSTOP	040
#define LPRPAR	0100
#define LPRODD	0200
#define LPRSPE	07400
#define LPRRXON 010000
/* default settings 8 bits, 2 stop bits, no parity, RX on */
#define LPRNORM LPRRXON | LPRSTOP | LPRLENG

struct	tty dz11[NDZ11];
int	dzerr[16];

struct dzregr {
	int dzrcsr;
	int dzrbuf;
	int dztcsr;
	int dztbuf;
} ;

int	dzstab[] {
	017,	/* 0 baud - 017 not used on dz11 */
	000,	/* 50 baud */
	001,	/* 75 baud */
	002,	/* 110 baud */
	003,	/* 134.5 baud */
	004,	/* 150 baud */
	017,	/* 200 baud - not avail in dz11 */
	005,	/* 300 baud */
	006,	/* 600 baud */
	007,	/* 1200 baud */
	010,	/* 1800 baud */
	012,	/* 2400 baud */
	014,	/* 4800 baud */
	016,	/* 9600 baud */
	013,	/* X0 - use 3600 on dz */
	015,	/* X1 - use 7200 on dz */
} ;
dzopen(dev, flag)
{
	extern	dzstart();
	register char *addr;
	register struct tty *tp;
	register int	dzbit;

dzerr[0]++;dzerr[1]++;
	if(dev.d_minor >= NDZ11) {
		u.u_error = ENXIO;
		return;
	}

	tp = &dz11[dev.d_minor];
	addr = DZADDR + (dev.d_minor&070);
	dzbit = 1 << (dev.d_minor & 07);
	tp->t_addr = dzstart;
	tp->t_dev = dev;

	if ((tp->t_state&ISOPEN) == 0) {
		tp->t_state =| WOPEN|SSTART|CARR_ON;
		tp->t_flags = XTABS|LCASE|ECHO|CRMOD;
		tp->t_erase = CERASE;
		tp->t_kill = CKILL;
		tp->t_speeds = CSPEED;
		dzparam(tp);
	}
	addr->dzrcsr =| MSCAN|RXINTEN|TXINTEN;
	tp->t_state =& ~WOPEN;
	tp->t_state =| ISOPEN;

	if (u.u_procp->p_ttyp == 0) {
		u.u_procp->p_ttyp = tp;
	}
}

dzclose(dev)
{
	register struct tty *tp;

dzerr[0]++;dzerr[2]++;
	tp = &dz11[dev.d_minor];
	wflushtty(tp);
	tp->t_state = 0;
}

dzread(dev)
{
dzerr[0]++;dzerr[3]++;
	ttread(&dz11[dev.d_minor]);
}

dzwrite(dev)
{
dzerr[0]++;dzerr[4]++;
	ttwrite(&dz11[dev.d_minor]);
}

dzoutp(dev)
{
	register int c, *addr;
	register struct tty *tp;
	int	dzbit;
	extern ttrstrt();

dzerr[0]++;dzerr[5]++;
	addr = DZADDR + (dev.d_minor << 3);

	c = (addr->dzrcsr&TXLINE)>>8;
	dzbit = 1<<c;
	tp = &dz11[(dev.d_minor<<3) + c];

	if (((tp->t_state&TIMEOUT)==0) && ((c=getc(&tp->t_outq)) >= 0)) {
		if (tp->t_flags&RAW) {
			addr->dztbuf = c;
			goto out;
		}
		else {
			if (c<=0177) {
				addr->dztbuf = c | (partab[c]&0200);
				goto out;
			}
			else {
				timeout(ttrstrt, tp, c&0177);
				tp->t_state =| TIMEOUT;
			}
		}
	}
	addr->dztcsr =& ~dzbit;
out:	if (tp->t_outq.c_cc==TTLOWAT && tp->t_state&ASLEEP) {
		tp->t_state =& ~ASLEEP;
		wakeup(&tp->t_outq);
	}
}
dzinp(dev)
{
	register int c, *addr;
	register struct tty *tp;

dzerr[0]++;dzerr[6]++;
	addr = DZADDR + (dev.d_minor << 3);
	while ( (c=addr->dzrbuf) & RXVALID) {
		tp = &dz11[(dev.d_minor<<3) + ((c & RXLINE)>>8)];
		ttyinput(c & RXCHAR, tp);
		}
}

dzsgtty(dev, v)
int *v;
{
	register struct tty *tp;

dzerr[0]++;dzerr[7]++;
	tp = &dz11[dev.d_minor];
	if (ttystty(tp, v)) return;
	dzparam(tp);
}
dzstart(atp)
struct tty	*atp;
{
	register struct tty *tp;
	register int dzbit,*addr;
	int	sps;

dzerr[0]++;dzerr[8]++;
	tp=atp;
	addr = DZADDR + (tp->t_dev&070);
	dzbit = 1 << (tp->t_dev & 07);

	sps = PS->integ;
	spl5();
	addr->dztcsr =| dzbit;
	PS->integ = sps;
}
dzparam(atp)
{
	register int *addr;
	register struct tty *tp;

dzerr[0]++;dzerr[9]++;
	tp=atp;
	spl5();
	addr = DZADDR + (tp->t_dev&070);
	addr->dzrbuf = LPRNORM|(dzstab[tp->t_speeds&017]<<8)|(tp->t_dev&07);
	spl0();
}
