/*
 *	rxinit
 *	Program to create a file system on of floppy disc - rx
 *	Peter Collinson
 *	May 1977
 */

char mtab[]	"/etc/mtab";
char rxproto[]	"/etc/rxproto";
char rxdev[]	"/dev/rx0";

struct
{	char path[32];
	char dev[32];
};

char buf[64];

main(argc, argv)
int argc; char **argv;
{
	int fd;

	if(argc>1)
	{	argv++;
		if(**argv == '0' || **argv== '1')
			rxdev[7] = **argv;
		else
		{	printf("rx%c cannot be used\n", **argv);
			exit();
		}
	}

	/* Check for device mounted */

	if((fd = open(mtab, 0)) <0)
	{	printf("Cannot open mtab\n");
		exit();
	}

	while(read(fd, buf, 64) > 0)
	{	if(buf->dev[0] == 'r' &&
		   buf->dev[1] == 'x' &&
		   buf->dev[2] == rxdev[7])
		{
			printf("%s already mounted\n", rxdev);
			exit();
		}
	}
	close(fd);

	/* All OK - ask for confirmation */

	printf("Initialising %s:\t", rxdev);
	read(1, buf, 64);
	if(buf[0] == 'y')
	{	printf("Entering mkfs\n");
		flush();
		execl("/etc/mkfs", "mkfs", rxdev, rxproto, 0);
	}
	exit();
}

/* Current UKC rxproto file is
/usr/mdec/uboot
499 5
d--777 0 3
$
*/
