/ explor -- graphic language

.globl	.init
.globl	.iff
.globl	.ge
.globl	.gt
.globl	.le
.globl	.lt
.globl	.eq
.globl	.ne
.globl	.chv
.globl	.add
.globl	.sub
.globl	.mpy
.globl	.div
.globl	.set
.globl	.wbt
.globl	.choose
.globl	.hox
.globl	.box
.globl	.pox
.globl	.crc
.globl	.prc
.globl	.brc
.globl	.xl
.globl	.axl
.globl	.xli
.globl	.camera
.globl	.modrun
.globl	.modwrp

.text
.init:
	tst	(sp)+
	sys	time
	mov	r1,ranx
	mov	$1,r4
	jsr	r5,(r5)

term:
	sys	exit

/ 	jsr	r5,.iff
/		and1
/		and2
/		op
/		goto

.iff:
	cmp	*(r5)+,*(r5)+
	jmp	*(r5)+

.ge:
	bge	1f
	br	2f

.gt:
	bgt	1f
	br	2f

.le:
	ble	1f
	br	2f

.lt:
	blt	1f
	br	2f

.eq:
	beq	1f
2:
	mov	(r5),r5
	rts	r5

.ne:
	beq	2b
1:
	tst	(r5)+
	rts	r5

/	jsr	r5,.chv
/		var
/		op
/		from
/		to

.chv:
	tst	6(r5)
	blt	1f
	jsr	pc,rand
	mov	*6(r5),r2
	sub	*4(r5),r2
	inc	r2
	mul	r2,r0
	ashc	r4,r0
	add	*4(r5),r0
	br	2f
1:
	mov	*4(r5),r0
2:
	mov	(r5)+,r1
	mov	(r5)+,r2
	cmp	(r5)+,(r5)+
	jmp	(r2)

.add:
	add	r0,(r1)
	rts	r5

.sub:
	sub	r0,(r1)
	rts	r5

.mpy:
	mov	(r1),r3
	mul	r0,r3
	mov	r3,(r1)
	rts	r5

.div:
	mov	(r1),r3
	sxt	r2
	div	r0,r2
	mov	r2,(r1)
	rts	r5

.set:
	mov	r0,(r1)
	rts	r5

.wbt:
	jsr	pc,wbt; 0
	jsr	pc,wbt; 1
	jsr	pc,wbt; 2
	rts	r5

wbt:
	mov	(r5)+,r2
	mov	*(sp),r1
1:
	movb	(r2)+,r0
	beq	1f
	jsr	pc,atob
	movb	r1,wbtvec(r0)
	br	1b
1:
	add	$2,(sp)
	rts	pc

.choose:
	inc	(r5)
	mov	(r5)+,r3
	clr	r2
	mov	(r5)+,r0
	blt	1f
	bne	3f
	inc	r0
3:
	div	r0,r2
	tst	r3
	beq	3f
2:
	mov	2(r5),r5
	rts	r5
1:
	neg	r0
	div	r0,r2
	tst	r3
	beq	2b
3:
	jsr	pc,rand
	mov	(r5),r2
	blt	1f
	bne	3f
	inc	r2
3:
	mul	r2,r0
	ashc	r4,r0
	tst	r0
	bne	2b
	br	3f
1:
	neg	r2
	mul	r2,r0
	ashc	r4,r0
	tst	r0
	beq	2b
3:
	cmp	(r5)+,(r5)+
	rts	r5

.hox:
	mov	$skip,dobox+2
	mov	$xl,doxf+2
	clr	bxx
	clr	bxy
	mov	$MAXX-1,bxw
	mov	$MAXY-1,bxt
	mov	r4,r0
	mov	r0,bxc
	mov	r0,bxr
	rts	r5

.box:
	mov	$nprob,dobox+2
	br	1f

.pox:
	mov	$pprob,dobox+2
1:
	mov	$xl,doxf+2
	mov	(r5)+,bxp
	mov	*(r5)+,bxx
	mov	*(r5)+,bxy
	mov	*(r5)+,r0
	mov	r0,bxw
	asr	r0
	sub	r0,bxx
	mov	*(r5)+,r0
	mov	r0,bxt
	asr	r0
	sub	r0,bxy
	br	2f

.crc:
	mov	$nprob,dobox+2
	br	1f

.brc:
	mov	$nprob,dobox+2
	br	1f

.prc:
	mov	$pprob,dobox+2
1:
	mov	$cxl,doxf+2
	mov	(r5)+,bxp
	mov	*(r5)+,bxx
	mov	*(r5)+,bxy
	mov	*(r5)+,r0
	sub	r0,bxx
	sub	r0,bxy
	mov	r0,cr
	mov	r0,r3
	mul	r0,r3
	mov	r3,crsq
	asl	r0
	mov	r0,bxw
	mov	r0,bxt
2:
	mov	*(r5)+,bxh
	mov	*(r5)+,bxv
	mov	*(r5)+,bxc
	mov	*(r5)+,bxr
	rts	r5

.xl:
	mov	(r5)+,r0
	cmp	r0,r4
	beq	1f
	clr	r0
1:
	mov	r0,ptp
	jsr	pc,ixtab
4:
	dec	bxr
	blt	4f
	mov	bxx,cxx
	mov	bxc,-(sp)
3:
	dec	(sp)
	blt	3f

dobox:
	jsr	pc,*$..
		br 0f
	mov	bxy,y
	mov	bxt,-(sp)
2:
	dec	(sp)
	blt	2f
	mov	cxx,x
	mov	bxw,-(sp)
1:
	dec	(sp)
	blt	1f

doxf:
	jsr	pc,*$..
	inc	x
	br	1b
1:
	tst	(sp)+
	inc	y
	br	2b
2:
	tst	(sp)+
0:
	add	bxh,cxx
	br	3b
3:
	tst	(sp)+
	add	bxv,bxy
	br	4b
4:
	rts	r5

.axl:
	mov	$numvec,r0
	cmp	doxf+2,$xl
	beq	2f
	mov	$caxl,doxf+2
	br	1f
2:
	mov	$axl,doxf+2
1:
	clr	(r0)+
	cmp	r0,$numvec+8.
	blo	1b
	mov	(r5)+,r1
1:
	movb	(r1)+,r0
	beq	1f
	bic	$!7,r0
	incb	numvec(r0)
	br	1b
1:
	mov	(r5)+,r1
	mov	$dirvec,r2
1:
	movb	(r1)+,r0
	beq	1f
	mov	$dirsq,r3
2:
	cmp	r0,(r3)+
	beq	2f
	cmp	(r3)+,(r3)+
	tst	(r3)
	bne	2b
	br	1b
2:
	mov	(r3)+,(r2)+
	mov	(r3)+,(r2)+
	cmp	r2,$dirvec+32.
	blo	1b
1:
	mov	$2,(r2)+
	mov	$chrvec,r0
1:
	clr	(r0)+
	cmp	r0,$chrvec+36.
	blo	1b
	mov	(r5)+,r1
1:
	movb	(r1)+,r0
	beq	1f
	jsr	pc,atob
	incb	chrvec(r0)
	br	1b
1:
	rts	r5

.xli:
	mov	*(r5)+,-(sp)
	mov	(r5)+,ptp
	jsr	pc,ixtab
	mov	(sp)+,r2
1:
	movb	(r2),r3
	beq	1f
	cmp	r3,$'.
	beq	2f
	jsr	pc,rand
	mul	ptp,r0
	ashc	r4,r0
	tst	r0
	bne	2f
	mov	r3,r0
	jsr	pc,atob
	movb	xlvec(r0),r0
	jsr	pc,btoa
	movb	r0,(r2)
2:
	inc	r2
	br	1b
1:
	rts	r5

.camera:
	mov	(r5)+,frc
	tst	.modrun
	beq	1f
2:
	dec	frc
	blt	2f
	clr	y
3:
	clr	x
4:
	jsr	pc,page
	movb	(r0),r0
	jsr	pc,btoa
	cmp	r0,$'0
	bne	5f
	mov	$' ,r0
5:
	jsr	pc,putch
	inc	x
	cmp	x,$PRX
	blo	4b
	mov	$'\n,r0
	jsr	pc,putch
	inc	y
	cmp	y,$PRY
	blo	3b
	mov	$'-,r0
	jsr	pc,putch
	mov	$'\n,r0
	jsr	pc,putch
	br	2b
2:
	rts	r5
1:
	dec	frc
	blt	1f
	jsr	pc,erase
	clr	y
2:
	clr	x
3:
	jsr	pc,page
	movb	(r0),r0
	movb	wbtvec(r0),r0
	beq	btw
	dec	r0
	beq	btb
	jsr	pc,rand
	asl	r0
	bmi	btb
btw:
	jsr	pc,point
btb:
	inc	x
	cmp	x,$MAXX
	blo	3b
	inc	y
	cmp	y,$MAXY
	blo	2b
	br	1b
1:
	jsr	pc,eframe
	rts	r5

putch:
	cmp	r0,$' /
	bne	2f
	inc	nspace
	rts	pc
2:
	mov	r0,-(sp)
	cmp	r0,$'\n
	bne	2f
	clr	nspace
2:
	dec	nspace
	blt	2f
	mov	$' ,r0
	jsr	pc,1f
	br	2b
2:
	mov	(sp)+,r0
	clr	nspace
1:
	mov	r0,1f
	mov	r4,r0
	sys	write; 1f; 1
	rts	pc
1:	0

nprob:
	jsr	pc,rand
	mul	bxp,r0
	ashc	r4,r0
	tst	r0
	bne	1f

skip:
	add	$2,(sp)
1:
	rts	pc

pprob:
	rts	pc

ixtab:
	clr	r0
1:
	movb	r0,xlvec(r0)
	inc	r0
	cmp	r0,$36.
	blo	1b
	mov	(r5)+,r1
	clr	r2
	cmpb	(r1)+,$'.
	beq	1f
	dec	r1
2:
	movb	(r1)+,r0
	beq	3f
	cmp	r0,$'.
	beq	2f
	cmp	r2,$36.
	bhis	3f
	jsr	pc,atob
	mov	r0,r3
	movb	r0,xlvec(r2)
	inc	r2
	br	2b
2:
	cmp	r2,$36.
	bhis	3f
	movb	r3,xlvec(r2)
	inc	r2
	br	2b
1:
	movb	(r1)+,r0
	beq	3f
	jsr	pc,atob
	mov	r0,r3
	movb	(r1)+,r0
	beq	3f
	jsr	pc,atob
	cmp	r2,$36.
	bhis	3f
	movb	r0,xlvec(r3)
	br	1b
3:
	rts	pc

caxl:
	jsr	pc,incirc

axl:
	clr	frc
	mov	$dirvec,r1
1:
	mov	(r1)+,r3
	cmp	r3,$2
	beq	1f
	add	r3,x
	add	(r1),y
	jsr	pc,page
	movb	(r0),r0
	sub	r3,x
	sub	(r1)+,y
	tstb	chrvec(r0)
	beq	1b
	inc	frc
	br	1b
1:
	mov	frc,r0
	tstb	numvec(r0)
	bne	xl
	rts	pc

dirsq:
	'a; 0; 1
	'n; 1; 1
	'r; 1; 0
	'e; 1;-1
	'b; 0;-1
	's;-1;-1
	'l;-1; 0
	'w;-1; 1
	0

cxl:
	jsr	pc,incirc

xl:
	tst	ptp
	beq	1f
	jsr	pc,rand
	mul	ptp,r0
	ashc	r4,r0
	tst	r0
	bne	2f
1:
	jsr	pc,page
	movb	(r0),r1
	movb	xlvec(r1),(r0)
2:
	rts	pc

incirc:
	mov	cxx,r3
	add	cr,r3
	sub	x,r3
	mul	r3,r3
	mov	bxy,r1
	add	cr,r1
	sub	y,r1
	mul	r1,r1
	add	r3,r1
	cmp	r1,crsq
	blos	1f
	tst	(sp)+
1:
	rts	pc

btoa:
	cmp	r0,$10.
	bhis	1f
	add	$'0,r0
	rts	pc
1:
	add	$'a-10.,r0
	rts	pc

atob:
	cmp	r0,$'9
	bhi	1f
	sub	$'0,r0
	br	2f
1:
	sub	$'a-10.,r0
2:
	cmp	r0,$36.
	blo	1f
	clr	r0
1:
	rts	pc

	rts	pc

rand:
	mov	r1,-(sp)
	mov	ranx,r1
	mpy	$13077.,r1
	add	$6925.,r1
	mov	r1,r0
	mov	r0,ranx
	bic	$100000,r0
	mov	(sp)+,r1
	rts	pc

.bss
ranx:	.=.+2
x:	.=.+2
y:	.=.+2
frc:	.=.+2
nspace:	.=.+2
wbtvec:	.=.+36.
xlvec:	.=.+36.
ptp:	.=.+2
bxp:	.=.+2
crsq:	.=.+2
cr:	.=.+2
bxx:	.=.+2
bxy:	.=.+2
bxw:	.=.+2
bxt:	.=.+2
bxh:	.=.+2
bxv:	.=.+2
bxc:	.=.+2
bxr:	.=.+2
cxx:	.=.+2
numvec:	.=.+8.
dirvec:	.=.+34.
chrvec:	.=.+36.
.modrun:.=.+2
.modwrp:.=.+2
.text

MAXX = 128.
MAXY = 95.
PRX = 44.
PRY = 38.

page:
	mov	r1,-(sp)
	mov	x,r0
	cmp	r0,$MAXX
	bhis	1f
	mov	y,r1
	cmp	r1,$MAXY
	bhis	1f
	mpy	$MAXX,r1
	add	r1,r0
	add	$array,r0
	mov	(sp)+,r1
	rts	pc
1:
	mov	$border,r0
	mov	(sp)+,r1
	rts	pc

.bss
border:	.=.+2
array:	.=.+[MAXX*MAXY]
.text
