#
#include "../param.h"
#include "../tty.h"
#include "../lnk.h"
#include "../user.h"
#include "../conf.h"
#include "../file.h"
#include "../proc.h"

struct link lnk;
struct tty dh11[];

lnkinput(ac, atp)
struct tty *atp;
{
	register int i, f, c;

	f = 0;
	c = ac&0377;
	if ((i = lnk.l_istate)==INISTATE) {
	/* initial state */
		if (c <= TENSTATE)
			lnk.l_istate = c;
		else {
			if (c == 0240+PIPSTATE) {	/* EOF on PIPE */
				lnk.l_openf[PIPSTATE-1] = 0;
				wakeup(&lnk.l_iq[PIPSTATE-2]);
				return;
			}
			if (c&0100) {
				f--;
				c =& ~0100;
			}
			if (c >= 0200+UNXSTATE && c <= 0200+TENSTATE)
				if ((lnk.l_otime[(c&03)-1] = f)==0)
					lnkcts( c =& ~0200);
		}
		return;
	}
	lnk.l_itime[i-1] = 0;	/* clr timer - no need to re-xmit ack */
	if (lnk.l_openf[i-1] <= 0)
		goto out;
	switch (i) {
	/* next char. is input for unix-pseudo (typed on 10 kbd.) */
	case UNXSTATE:
		ttyinput(c, atp);
		break;
	/* next char. is for pipe */
	case PIPSTATE:
	/* next char.is output for ten-pseudo (typeout or echo from ten) */
	case TENSTATE:
		i =- 2;		/* correct index - pipe=0, ten=1 */
		putc(c, &lnk.l_iq[i]);
		if (lnk.l_iq[i].c_cc >= LNKIHIWAT) {
			lnk.l_iwaitf[i]++;
			f = 0100;
		} else
			if (lnk.l_iwaitf[i]) {
				lnk.l_iwaitf[i] = 0;
				wakeup(&lnk.l_iq[i]);
			}
		i =+ 2;
	}
	f =| 0200;
	f =| i;
	lnk.l_ichar[i-1] = f;
	lnkrfn(i);
out:
	lnk.l_istate = 0;
}


lnkcts(state)
{
	register int c, i;

	i = state;
	switch(i) {

	/* ok to send next char. of unix-pseudo output
	 * to the TEN for typeout
	 */
	case UNXSTATE:
		if (lnktty.t_state&HALTOP)
			return;
		while ((c = getc(&lnktty.t_outq)) >= 0200); /* filter delays */
		if (c < 0)
			return;
		if(lnktty.t_outq.c_cc <= TTLOWAT && lnktty.t_state&ASLEEP) {
			lnktty.t_state =& ~ASLEEP;
			wakeup(&lnktty.t_outq);
		}
		break;

	/* ok to pipe next char. to TEN */
	case PIPSTATE:

	/* ok to send next char. of ten-pseudo input
	 * to the TEN for typein
	 */
	case TENSTATE:
		i =- 2;		/* index - pipe=0, ten=1 */
		if ((c = getc(&lnk.l_oq[i])) < 0)
			return;
		if (lnk.l_oq[i].c_cc <= LNKOLOWAT && lnk.l_owaitf[i]) {
			lnk.l_owaitf[i] = 0;
			wakeup(&lnk.l_oq[i]);
		}
		i =+ 2;
	}
	lnk.l_ochar[i-1] = c;
	lnksend(i);
}

lnkrfn(state)
{
	register int i;

	i = state;
	putc(lnk.l_ichar[i-1], &lnk.l_outq);
	lnkxfr();
	lnk.l_itime[i-1] = LITIME;
}

lnksend(state)
{
	register int i;

	i = state;
	putc(i, &lnk.l_outq);
	putc(lnk.l_ochar[i-1], &lnk.l_outq);
	lnkxfr();
	lnk.l_otime[i-1] = LOTIME;
}

lnktimer(dummy)
{
	register int i;

	for (i=0; i<3; i++) {
		if (lnk.l_otime[i]>0 && --lnk.l_otime[i]==0)
			lnksend(i+1);
		if (lnk.l_itime[i]>0 && --lnk.l_itime[i]==0)
			lnkrfn(i+1);
	}
	timeout(lnktimer, 0, HZ);
}

lnkxfr()
{
	register int *dhp, c;
	register char *cp;
	int sps;

	sps = PS->integ;
	spl5();
	if (lnktty.t_state&BUSY)
		goto out;
	cp = dh_clist[LNKLIN];
	while ((c = getc(&lnk.l_outq))>=0 && cp<dh_clist[LNKLIN+1])
		*cp++ = c;
	if ((cp =- dh_clist[LNKLIN])==0)
		goto out;
	dhp = dhaddr[LNKLIN/16];
	dhp->dhcsr.lobyte = (LNKLIN&017) | IENABLE;
	dhp->dhcar = dh_clist[LNKLIN];
	dhp->dhbcr = -cp;
	dhp->dhbar =| (1 << (LNKLIN&017));
	dhsar[LNKLIN/16] =| (1 << (LNKLIN&017));
	lnktty.t_state =| BUSY;
out:
	PS->integ = sps;
}

ttlnkread(dev)
{

	ttread(&lnktty);
}

lnkread(dev)
{
	register int i, c, n;

	i = dev.d_minor;
	n = i-1;
	spl5();
	while(lnk.l_iq[n].c_cc==0) {
		if (lnk.l_openf[i]==0)	/* EOF (only on PIPE) */
			goto out;
		lnk.l_iwaitf[n]++;
		sleep(&lnk.l_iq[n], LNKIPRI);
	}
	spl0();
	while((c = getc(&lnk.l_iq[n])) >= 0)
		if (passc(c) < 0)
			break;
	spl5();
	if (lnk.l_iq[n].c_cc <= LNKILOWAT && lnk.l_iwaitf[n]) {
		lnk.l_iwaitf[n] = 0;
		lnk.l_ichar[i] =& ~0100;
		lnkrfn(i+1);
	}
out:
	spl0();
}

ttlnkwrite(dev)
{

	ttwrite(&lnktty);
}

lnkwrite(dev)
{
	register int i, c, n;

	i = dev.d_minor;
	if (i==(OPIPSTATE-1))
		i = PIPSTATE-1;		/* correct for pipe */
	n = i-1;
	while((c = cpass()) >= 0) {
		putc(c, &lnk.l_oq[n]);
		spl5();
		while(lnk.l_oq[n].c_cc > LNKOHIWAT) {
			lnk.l_owaitf[n]++;
			lnkstart(i+1);
			sleep(&lnk.l_oq[n], LNKOPRI);
		}
		spl0();
	}
	lnkstart(i+1);
}

lnkstart(state)
{
	register int sps;

	sps = PS->integ;
	spl5();
	if (lnk.l_otime[state-1] == 0)
		lnkcts(state);
	PS->integ = sps;
}

ttlnkopen(dev, flags)
{

	if (dev.d_minor != LNKLIN || lnk.l_openf[UNXSTATE-1] < 0) {
		u.u_error = ENXIO;
		return;
	}
	/* ##stt 3/2/77 new style proc group */
	if (!lnktty.t_grp) lnktty.t_grp = getpgrp(dev);
	/* ##stt 3/2/77 allow multiple opens on ttlnk */
	lnk.l_openf[UNXSTATE-1] = 0;
	lnkopen(UNXSTATE-1);
}

lnkopen(dev, flags)
{
	extern unxstart();
	register int i;

	if ((i = dev.d_minor) > (OPIPSTATE-1) || lnk.l_openf[i]) {
		u.u_error = ENXIO;
		return;
	}
	if (i==(PIPSTATE-1) && flags&FWRITE ||	/* no write on read-only */
	    i==(OPIPSTATE-1) && flags&FREAD) {	/* & no read on write-only */
		u.u_error = ENODEV;
		return;
	}
	if (lnk.l_startf==0) {
		lnk.l_startf++;
		dhopen(LNKLIN);
		lnktty.t_speeds = LNKSPEED | (LNKSPEED<<8);
		dhparam(&lnktty);
		lnktty.t_addr = unxstart;
		timeout(lnktimer, 0, HZ);
	}
	lnk.l_openf[i]++;
	if (i!=(OPIPSTATE-1)) {
		lnk.l_ichar[i] = 0201+i;
		lnk.l_itime[i]++;
	}
}

ttlnkclose(dev)
{

	lnkclose(UNXSTATE-1);
}

lnkclose(dev)
{
	register int i, n;

	i = dev.d_minor;
	lnk.l_openf[i] = -1;	/* disable further input */
	if (i < (OPIPSTATE-1))
		lnk.l_itime[i] = 0;
	switch(i) {
	case UNXSTATE-1:
		wflushtty(&lnktty);
		break;
	case PIPSTATE-1:		/* pipe from TEN */
		while (getc(&lnk.l_iq[0]) >= 0);
		lnk.l_iwaitf[0] = 0;
		break;
	case TENSTATE-1:
		while (getc(&lnk.l_iq[1]) >= 0);
		lnk.l_iwaitf[1] = 0;
	case OPIPSTATE-1:			/* pipe to TEN */
		n = (i-1)&01;
		spl5();
		while (lnk.l_oq[n].c_cc) {
			lnk.l_owaitf[n]++;
			sleep(&lnk.l_oq[n], LNKOPRI);
		}
		spl0();
		if (n==0) {		/* send EOF if pipe */
			putc(0240+PIPSTATE, &lnk.l_outq);
			lnkxfr();
		}
		lnk.l_owaitf[n] = 0;
	}
	lnk.l_openf[i] = 0;
}

ttlnksgtty(dev, av)
{

	ttystty(&lnktty, av);
}

unxstart(atp)
{

	lnkstart(UNXSTATE);
}
