#
/*	new tty input routine
 *
 *		first version march 75	bsb
 *		cleanup january 76	bsb
 */

#include "../tty.h"
#include "../param.h"
#define HOGCLOSE 5 /* ttyhog grace period */


struct cblock {
	struct cblock *c_next;
	char info[6];
};

struct cblock *cfreelist;
int	cblkuse, maxcbu;

/* modes for all the known chars */

#define	NORM_MD	0	/* normal everyday char */
#define	UCAS_MD	1	/* upper case normal char */
#define	CTRL_MD	2	/* non - break ctrl char */
#define	RUB_MD	3	/* rubout or ^a */
#define	ERAS_MD	4	/* ^u */
#define	RTYP_MD	5	/* ^r */
#define	INT_MD	6	/* ^c */
#define	QUIT_MD	7	/* ^b */
#define	NULL_MD	8	/* <break> */
#define	CR_MD	9	/* <cr> */
#define	LF_MD	10	/* <lf> */
#define	EOT_MD	11	/* ^d */
#define	BELL_MD	12	/* ^g */
#define	SINK_MD	13	/* ^o */
#define	ESC_MD	14	/* <esc> */
#define	FF_MD	15	/* <ff> ^l */
#define	UPRO_MD	16	/* ^ */
#define	ALT_MD	17	/* <alt> 0175 */
#define	SLSH_MD	18	/* \ quote char */

/**/

char	chtype[] {

	/* Control characters */
NULL_MD,	RUB_MD ,	QUIT_MD,	INT_MD,
EOT_MD, 	CTRL_MD,	CTRL_MD,	BELL_MD,
NORM_MD,	NORM_MD,	LF_MD,  	CTRL_MD,
FF_MD,  	CR_MD,  	CTRL_MD,	SINK_MD,
CTRL_MD,	CTRL_MD,	RTYP_MD,	0,
CTRL_MD,	ERAS_MD,	CTRL_MD,	CTRL_MD,
CTRL_MD,	CTRL_MD,	CTRL_MD,	ESC_MD,
CTRL_MD,	CTRL_MD,	CTRL_MD,	CTRL_MD,
	/* specials */
NORM_MD,	NORM_MD,	NORM_MD,	NORM_MD,	/*  !"# */
NORM_MD,	NORM_MD,	NORM_MD,	NORM_MD,	/* $%&' */
NORM_MD,	NORM_MD,	NORM_MD,	NORM_MD,	/* ()*+ */
NORM_MD,	NORM_MD,	NORM_MD,	NORM_MD,	/* ,-./ */
	/* numbers & specials */
NORM_MD,	NORM_MD,	NORM_MD,	NORM_MD,
NORM_MD,	NORM_MD,	NORM_MD,	NORM_MD,
NORM_MD,	NORM_MD,	NORM_MD,	NORM_MD,	/* 89:; */
NORM_MD,	NORM_MD,	NORM_MD,	NORM_MD,	/* <=>? */
	/* @ + upper case characters */
NORM_MD,	UCAS_MD,	UCAS_MD,	UCAS_MD,	/* @ABC */
UCAS_MD,	UCAS_MD,	UCAS_MD,	UCAS_MD,
UCAS_MD,	UCAS_MD,	UCAS_MD,	UCAS_MD,
UCAS_MD,	UCAS_MD,	UCAS_MD,	UCAS_MD,
UCAS_MD,	UCAS_MD,	UCAS_MD,	UCAS_MD,
UCAS_MD,	UCAS_MD,	UCAS_MD,	UCAS_MD,
UCAS_MD,	UCAS_MD,	UCAS_MD,	NORM_MD,	/* XYZ[ */
	/* specials */
SLSH_MD,	NORM_MD,	UPRO_MD,	NORM_MD,	/* \]^_ */
	/* ' + lower case characters */
NORM_MD,	NORM_MD,	NORM_MD,	NORM_MD,	/* 'abc */
NORM_MD,	NORM_MD,	NORM_MD,	NORM_MD,
NORM_MD,	NORM_MD,	NORM_MD,	NORM_MD,
NORM_MD,	NORM_MD,	NORM_MD,	NORM_MD,
NORM_MD,	NORM_MD,	NORM_MD,	NORM_MD,
NORM_MD,	NORM_MD,	NORM_MD,	NORM_MD,
NORM_MD,	NORM_MD,	NORM_MD,	NORM_MD,	/* xyz{ */
	/* specials */
NORM_MD,	ALT_MD, 	NORM_MD,	RUB_MD, 	/* |}~<dl> */

	};
/**/

/* and now for the functional codes which drive this
 * convoluted touring machine
 */

#define	DONE_FN	0	/* chain end */
#define	ECHO_FN	1	/* echo char as seen */
#define	STOR_FN	2	/* store char in input buffer */
#define	BRK_FN	3	/* store brk in input buffer (0377) */
#define	CTRL_FN	4	/* echo <^> <char + '`'> */
#define	CTRS_FN	5	/* echo <^> <char + '`'> <nl> */
#define	RUB_FN	6	/* rubout or ^a */
#define	ERAS_FN	7	/* ^u */
#define	SINK_FN	8	/* ^o */
#define	RTYP_FN	9	/* ^r */
#define	INT_FN	10	/* ^c */
#define	QUIT_FN	11	/* ^b */
#define	NULL_FN	12	/* break */
#define	FF_FN	13	/* <ff> */
#define	CR_FN	14	/* <cr> */
#define	SECH_FN	15	/* echo nxt chain entry */
#define	BELL_FN	16	/* <bell> ^g */
#define	ESC_FN	17	/* <esc> */
#define	UCAS_FN	18	/* upper case conversion to lower maybe */
#define	ALT_FN	19	/* <alt> 0175 */
#define	BKSL_FN	20	/* initial \ checker */
#define	BKSC_FN	21	/* clear backslash */
#define	UPRO_FN	22	/* ^ */
#define	CR1_FN	23	/* additional <cr> handler */
#define	SLSH_FN	24	/* \ quote handler */
#define	SLSX_FN	25	/* \ ancillary func */

/**/

/* chain names are "cn" followed by the mode to which they
 *  apply. extras for various functions (based on differences
 *  due to tty mode) are named mode followed by pp, dd, te for
 *  the applicable mode.
 */

char	cnnorm[] { STOR_FN, BKSL_FN, ECHO_FN, DONE_FN };
char	cnucas[] { UCAS_FN, STOR_FN, BKSL_FN, ECHO_FN, DONE_FN };
char	cnctrl[] { STOR_FN, BKSL_FN, CTRL_FN, DONE_FN };
char	cnrub[]  { RUB_FN };
char	cneras[] { BKSC_FN, CTRS_FN, ERAS_FN, DONE_FN };
char	cnrtyp[] { BKSC_FN, CTRS_FN, RTYP_FN };
char	cnint[]  { BKSC_FN, INT_FN, CTRS_FN, DONE_FN };
char	cnquit[] { BKSC_FN, QUIT_FN, CTRS_FN, DONE_FN };
char	cnnull[] { NULL_FN };
char	cncr[]   { CR_FN };
char	cnlf[]   { STOR_FN, BKSL_FN, ECHO_FN, BRK_FN };
char	cneot[]  { BKSL_FN, BRK_FN };
char	cnbell[] { BKSL_FN, BELL_FN };
char	cnsink[] { SINK_FN, CTRL_FN, DONE_FN };
char	cnesc[]  { BKSL_FN, ESC_FN };
char	cnff[]   { BKSL_FN, FF_FN };
char	cnupro[] { UPRO_FN };
char	cnalt[]  { BKSL_FN, ALT_FN };
char	cnslsh[] { BKSL_FN, SLSH_FN, ECHO_FN, DONE_FN };

/* use these chains when an esc (033) is seen */

char	escno[]  { STOR_FN, SECH_FN, '$', DONE_FN };
char	escpp[]  { STOR_FN, SECH_FN, '$', BRK_FN };
#define	escte	escpp
char	escdd[]  { STOR_FN, BRK_FN };

/* use these chains when an up arrow (^) is seen */

#define	uprono	cnnorm
#define	upropp	cnnorm
#define	uprote	cnlf
#define	uprodd	cnlf

/* use these chains when a bell <bell> (^g) is seen */

char	bellno[] { STOR_FN, CTRL_FN, ECHO_FN, DONE_FN };
char	bellpp[] { STOR_FN, CTRL_FN, ECHO_FN, BRK_FN };
#define	bellte	bellpp
#define	belldd	bellpp

/* now for special chains for whatever needs... */

char	rawchain[] { STOR_FN, ECHO_FN, BRK_FN };
char	cncrx[]  { STOR_FN, BKSL_FN, ECHO_FN, CR1_FN };
char	slshnorm[] { STOR_FN, BKSL_FN, SLSX_FN, ECHO_FN, DONE_FN };
/**/

/* here is the main dispatch table for chains based
 *  upon mode. second level dispatch is performed by the
 *  appropriate functions where necessary.
 */

int	nochain[] {

	cnnorm,
	cnucas,
	cnctrl,
	cnrub,
	cneras,
	cnrtyp,
	cnint,
	cnquit,
	cnnull,
	cncr,
	cnlf,
	cneot,
	cnbell,
	cnsink,
	cnesc,
	cnff,
	cnupro,
	cnalt,
	cnslsh,
};

int	escchain[] {

	escno,
	escpp,
	escte,
	escdd
};

int	uprochain[] {

	uprono,
	upropp,
	uprote,
	uprodd
};

int	bellchain[] {

	bellno,
	bellpp,
	bellte,
	belldd
};

/* define re-type echo dispatch */
#define ECH_NRML 0	/* re-type echo for normal */
#define ECH_CTRL 1	/* re-type echo with '^' */
#define ECH_ESCP 2	/* re-type echo for escape char */
#define ECH_BELL 3	/* re-type echo for bell */
char tt_ech[] {
	ECH_NRML,
	ECH_NRML,
	ECH_CTRL,
	ECH_CTRL,
	ECH_CTRL,
	ECH_CTRL,
	ECH_CTRL,
	ECH_CTRL,
	ECH_CTRL,
	ECH_NRML,
	ECH_NRML,
	ECH_CTRL,
	ECH_BELL,
	ECH_CTRL,
	ECH_ESCP,
	ECH_NRML,
	ECH_NRML,
	ECH_NRML,
	ECH_NRML,
};
/**/

#define	NEXT	goto swt

/* and finally to the actual job of walking through
 * the maze. this is the tty input function driven by the
 * above touring machine functions.
 */

ttyinput(ac, atp)
struct tty *atp;
{
	register struct tty *tp;
	char *md;
	register int c, t_flags;
	int ttmode, startf, savec;

	tp = atp;
	startf = 0;
	t_flags = tp->t_flags;
	c = ac;
	if(t_flags&RAW) {
		c =& 0377;
		tp->t_state =& ~(HALTOP|BKSLF);
		md = rawchain;
		if(t_flags&LCASE && (c =& 0177) >= 'A' && c <= 'Z')
			c =+ 'a' - 'A';
		else if (c == 0377) c = 0177;	/*##stt rubout in u/lc */
		NEXT;
	}
	c =& 0177;
	ttmode = (t_flags & (PPL|TECO))>>PPLPOS;
	if(tp->t_state & SLASHS) {
		savec = c;
		md = "({)}!|'`^~";
		/*##stt 8/7/76 force upper case on alpha */
		if (c >= 'a' && c <= 'z') c =+ 'A'-'a';
		else do
			if(c == *md++) {
				c = *md;
				break;
			} else
				md++;
		  while(*md);
		md = slshnorm;
	} else {
		if(c == CHALTOP) {
			tp->t_state =^ HALTOP;
			if((tp->t_state&HALTOP) == 0)
				goto donestart;
			ttstop(tp);
			return;
		}
		md = nochain[chtype[c]];
	}
	tp->t_state =& ~(HALTOP|SLASHS);

swt:	switch(*md++) {

	case DONE_FN:
done:			if(startf)
donestart:			ttstart(tp);
			return;

	case ECHO_FN:	if(t_flags&ECHO) {
				ttyoutput(c, tp);
				startf++;
			}
			NEXT;

	case STOR_FN:	if(tp->t_rawq.c_cc > TTYHOG-HOGCLOSE) {
				ttyoutput(07, tp);	/* bell */
				/* tty grace period ##stt 8/7/76 */
				if(tp->t_rawq.c_cc > TTYHOG) goto donestart;
				startf++;
			}
			if(putc(c, &tp->t_rawq) == 0) {
				if(tp->t_beglin == 0)
					tp->t_beglin = tp->t_rawq.c_cl-1;
				tp->t_lincnt++;
			}
			NEXT;

	case BRK_FN:
brkfn:
			if(putc(0377, &tp->t_rawq) == 0) {
				tp->t_delct++;
				tp->t_lincnt = 0;
				tp->t_beglin = 0;
				wakeup(&tp->t_delct);
			} else {
				--tp->t_lincnt;
				if((c = reducq(&tp->t_rawq)) < 0 || c == 0377)
					tp->t_beglin = 0;
				return;
			}
			goto donestart;

	case CTRL_FN:	if(t_flags&ECHO) {
				ttyoutput('^', tp);
				ttyoutput(c + '@', tp);
				startf++;
			}
			NEXT;

	case CTRS_FN:	if(t_flags&ECHO) {
				ttyoutput('^', tp);
				ttyoutput(c + '@', tp);
				if((t_flags&CRMOD) == 0)
					ttyoutput('\r', tp);
				ttyoutput('\n', tp);
				startf++;
			}
			NEXT;

	case RUB_FN:	if((tp->t_state&BKSLF) == 0) {
				if(t_flags&ECHO) {
					ttyoutput('\\', tp);
					startf++;
				}
				tp->t_state =| BKSLF;
			}
			if(tp->t_beglin == 0) {
				if(ttmode) {
					c = 0177;
					md = escdd;
					NEXT;
				}
				goto done;
			} else {
				if(t_flags&ECHO) {
					/*##stt 8/7/76 retype echo */
					ttyrtecho(*(tp->t_rawq.c_cl-1), tp);
				}
				reducq(&tp->t_rawq);
				if(--tp->t_lincnt == 0)
					tp->t_beglin = 0;
				goto donestart;
			}

	case ERAS_FN:	if(ttmode) {
				md = escdd;
				NEXT;
			}
			tty_erase(tp);
			NEXT;

	case SINK_FN:	tp->t_state =^ OPSUPRS;
			if(tp->t_state&OPSUPRS) {
				ttstop(tp);
				tp->t_char = 0;
				while(getc(&tp->t_outq) >= 0);
			}
			NEXT;

	case RTYP_FN:	if(ttmode) {
				md = escdd;
				NEXT;
			}
			if (!(t_flags&ECHO)) goto done;	/*##stt noecho */
			if(t_flags = tp->t_beglin) {
				c = (tp->t_lincnt&0377);
				tp->t_rawq.c_cl = t_flags;
				for(;;) {
					/*##stt 8/7/76 retype echo */
					ttyrtecho(*(tp->t_rawq.c_cl++), tp);
					if(--c == 0) break;
					if((tp->t_rawq.c_cl&07) == 0)
		tp->t_rawq.c_cl = ((tp->t_rawq.c_cl-010)->integ)+2;
				}
			}
			goto donestart;

	case INT_FN:	flushtty(tp);
			signal(tp->t_grp, SIGINT);
			NEXT;

	case QUIT_FN:	flushtty(tp);
			signal(tp->t_grp, SIGQIT);
			NEXT;

	case NULL_FN:	signal(tp->t_grp, SIGBRK);
			return;

	case FF_FN:	md = cnnorm;
			NEXT;

	case CR_FN:	if ((t_flags&CRMOD) == 0) {
				if (ttmode)
					md = cncrx;
				else
					md = cnnorm;
				NEXT;
			}
	case CR1_FN:	c = '\n';
			md = cnlf;
			NEXT;

	case SECH_FN:	if(t_flags&ECHO) {
				ttyoutput(*md++, tp);
				startf++;
			}
			NEXT;

	case BELL_FN:	md = bellchain[ttmode];
			NEXT;

	case ESC_FN:
escfn:			md = escchain[ttmode];
			NEXT;

	case UCAS_FN:	if(t_flags&LCASE) c =+ 'a' - 'A';
			NEXT;

	case ALT_FN:	if(t_flags&ALTESC) {
				c = 033;
				goto escfn;
			}
			md = cnnorm;
			NEXT;

	case BKSL_FN:	if(tp->t_state&BKSLF) {
				if(t_flags&ECHO) {
					ttyoutput('\\', tp);
					startf++;
				}
				tp->t_state =& ~BKSLF;
			}
			NEXT;

	case BKSC_FN:	tp->t_state =& ~BKSLF;
			NEXT;

	case UPRO_FN:	md = uprochain[ttmode];
			NEXT;

	case SLSH_FN:	if (t_flags&NOSLASH)
				md = cnnorm;	/* no slash escaping */
			else
				tp->t_state =| SLASHS;
			NEXT;

	case SLSX_FN:	c = savec;
			NEXT;

	}
}

/* ##stt 8/7/76 retype echo for char-delete and retype */
ttyrtecho(c,tp)
char c;
struct tty *tp;
{
	switch(tt_ech[chtype[c]]) {
	case ECH_BELL:
		ttyoutput(c, tp);
	case ECH_CTRL:
		ttyoutput('^', tp);
		c =+ '@';
	case ECH_NRML:
		ttyoutput(c, tp);
		break;
	case ECH_ESCP:
		ttyoutput('$', tp);
		break;
	}
}

/* ##stt 4/8/77 put erase in separate routine */
tty_erase(atp)
struct tty *atp;
{
	register char *p;
	register int s;
	register struct cblock *cbp;

	p = atp;
	if(s = p->t_beglin) {
		p->t_beglin = 0;
		p->t_rawq.c_cc =- (p->t_lincnt&0377);
		p->t_lincnt = 0;
		p->t_rawq.c_cl = s;
		cbp = ((s-1)&~07);
		if(p->t_rawq.c_cc == 0) {
			p->t_rawq.c_cl = 0;
			p->t_rawq.c_cf = 0;
		} else if ((cbp = cbp->c_next) == 0) {
			return;
		}
		s = PS->integ;
		spl6();
		do {
			p = cbp->c_next;
			cbp->c_next = cfreelist;
			cfreelist = cbp;
			cblkuse--;
		} while(cbp = p);
		PS->integ = s;
	}
}
