#
c
c combine two areas.  i.e. transliterate contents of x,y,w,h according
c to 4 rules depending on contents of cells of area centered at kx,ky
      subroutine combn (ix,iy,iw,ih,ipct,kx,ky,iway,ir0,ir1,ir2,ir3)
#include "common.h"
           integer ftrul(4,4),idiv(8),ixx(8),ixy(8),iyx(8),iyy(8)
           logical frzzt,ok
           data frzzt /.true./
           data idiv(1),idiv(2),idiv(3),idiv(4) /16384,4096,1024,256/
           data idiv(5),idiv(6),idiv(7),idiv(8) /64,16,4,1/
c     ixy is +1,0, or -1 depending on whether +1 in y on affected area
c     x,y,w,h corresp. to +1, 0, or -1 from pickup area (8 orientations)
           data ixx(1),ixx(2),ixx(3),ixx(4) / 1, 0,-1, 0/
           data ixx(5),ixx(6),ixx(7),ixx(8) /-1, 0, 1, 0/
           data ixy(1),ixy(2),ixy(3),ixy(4) / 0,-1, 0, 1/
           data ixy(5),ixy(6),ixy(7),ixy(8) / 0, 1, 0,-1/
           data iyx(1),iyx(2),iyx(3),iyx(4) / 0, 1, 0,-1/
           data iyx(5),iyx(6),iyx(7),iyx(8) / 0, 1, 0,-1/
           data iyy(1),iyy(2),iyy(3),iyy(4) / 1, 0,-1, 0/
           data iyy(5),iyy(6),iyy(7),iyy(8) / 1, 0,-1, 0/
        if(frzzt)call klear(frzzt)
c     rectify bounds, check validity of parameters
        call rctfy (ix,iy,iw,ih,il,ir,ib,it,ok)
           if(.not.ok)return
           if(min0(ir0,ir1,ir2,ir3).lt.0)return
           if(max0(ir0,ir1,ir2,ir3).gt.3333)return
           if(iway.lt.1.or.iway.gt.8.or.ipct.lt.1)return
c     initialize random skipping
        iprob = 2*ipct-ipct/51
        ipont = ne(1,199)
        iskip = ne(0,197)
        idlsk = ne(0,195)
c     initialize from-to transliteration matrix
        ftrul (1,1) = ir0
        ftrul (2,1) = ir1
        ftrul (3,1) = ir2
        ftrul (4,1) = ir3
        do 10 j = 1,4
           irule = ftrul(j,1)
           ftrul (j,1) = mod(mod(irule/1000,10),4)
           ftrul (j,2) = mod(mod(irule/ 100,10),4)
           ftrul (j,3) = mod(mod(irule/  10,10),4)
  10       ftrul (j,4) = mod(mod(irule     ,10),4)
c     do affected area column by column left to right
        do 20 j = il,ir
           ibyte = mod(j-1,7)+1
           index = nperw*(ib-1)+(j+6)/7
           iskip = mod(iskip+idlsk,198)
c     start cursor(ixf,iyf) as displacement from kx,ky according to iway
           ixf = kx-(ix-j)*ixx(iway)-(iy-ib)*ixy(iway)
           iyf = ky-(iy-ib)*iyy(iway)-(ix-j)*iyx(iway)
           idivv = idiv(ibyte)
           mpy = idiv(ibyte+1)
c     process the column
           do 20 k = ib,it
              if(ipct.ge.100)go to 15
              mdarg = ipont+iskip
              ipont = mdarg-(mdarg/199)*199+1
              if(iran(ipont).ge.iprob)go to 18
  15       if(ixf.lt.1.or.ixf.gt.nperl.or.iyf.lt.1.or.iyf.gt.nperl)go to 18
c     do process the cell. fetch both, look up, replace if different
              ibt = ixf-1
              ibytf = ibt-(ibt/7)*7+1
              indxf = nperw*(iyf-1)+(ixf+6)/7
              mdarg = line(indxf) /idiv(ibytf+1)
              numf = mdarg-(mdarg/4)*4
              i7 = line(index)
              mdarg = i7/mpy
              numt = mdarg-(mdarg/4)*4
              newn = ftrul(numf+1,numt+1)
              if(newn.eq.numt)go to 18
              line(index) = ((i7/idivv)*4+newn)*mpy+i7-(i7/mpy)*mpy
c     for next pass of inner loop, prepare to index, jog ixf,iyf cursor
  18          index = index+nperw
              ixf = ixf+ixy(iway)
              iyf = iyf+iyy(iway)
  20    continue
      return
      end
