#include	"damdefs.h"

/* read move; the intended format is
	nn-mm
   or
	nnxmm
   or
	nnxmm(q1,...,qt)
 */

extern int	dirt,prall,possct,captmax,captct,timew,timeb;
extern int	optp,rdif,prbwait,disp,playw,playb,me;
extern int	*mp,*mpf,conv[],bord[],moves[],mvnr;
extern char	*dsparr[],*emparr[],*fularr[],prtarr[];

#define	LINSIZ	82
char line[LINSIZ];
char	ch,*ach;

rdlin(){
register char c,*lp;
	lp = line;
	while((c = getchar()) != '\n'){
		if(!c) error("end of input");
		if(lp == line+LINSIZ-1){
			lp--;
			c = -1;
		}
		*lp++ = c;
	}
	*lp = 0;
	ach = line;
}

newchar(){
	return(ch = *ach++);
}

answer(){
ask:
	rdlin();
	switch(newchar()){
	case 'j':
	case 'y':
		return(1);
	case 'n':
		return(0);
	default:
		pmesg("answer 'y' or 'n'\n");
		goto ask;
	}
}

skipspaces(){
	while((ch == ' ') || (ch == '\t')) newchar();
}

rnum(){
int num;
	num = 0;
	skipspaces();
	while((ch >= '0') && (ch <= '9')) {
		num = 10*num + (ch - '0');
		newchar();
	}
	return(num);
}

readnum(){
int	num;
	num = rnum();
	skipspaces();
	if((num < 0) || (num > 50)) num = 0;
	return(conv[num]);
}

check(cc) char cc; {
	if(ch != cc){
		putcr('\'');
		putsym(ch);
		pmesg("' where '");
		putsym(cc);
		pmesg("' expected\n");
		ch = -1;		/* some error occurred */
	} else if(ch) newchar();
}

putsym(cc) char cc; {
	if(!cc) pmesg("\\n");
	else if(cc < ' ') pmesg("\\0%o",cc);
	else putcr(cc);
}

rdcomd(ac) char *ac; {
register char *sp,*sp2;
register int i;
int ct;
	if(*ac == '!') ac++;
	ach = ac;	/* read from argstring instead of array line */
	switch(newchar()){
	case 'w':
		playw = PDP;
		break;
	case 'b':
	case 'z':
		playb = PDP;
		break;
	case 'I':
		playw = playb = USER;
		break;
	case 'h':
		while(1){
			rdlin();
			if(*ach == '.') break;
			rdcomd(ach);
		}
		break;
	case 'm':
		if(newchar() == '-'){
			newchar();
			i = mvnr-rnum()-2;
		} else	i = rnum();
		check(0);
		if(ch == -1) goto ask;
		if(i<0 || i+2>mvnr){
			pmesg("impossible\n");
			goto ask;
		}
		backup(i);
		prbord();
		break;
	case 'p':
		newchar();
		if(ch) optp = rnum();
		prall++;
		prbord();
		break;
	case 'r':
		newchar();
		/*
		 * r: set rdif
		 * rf: read pos from file
		 * rt: read pos from terminal
		 */
		if(ch == 'f') readfile();
		else if(ch == 't') readpos();
		else {
			rdif = rnum();
			pmesg("rdif = %d\n",rdif);
		}
		break;
	case 's':
		newchar();
		prbwait = rnum();
		if(prbwait>30) prbwait = 30;
		pmesg("sleep after prbord for %d seconds\n",
			prbwait);
		break;
	case 't':
		pmesg("time used:\n");
		pmesg("  W %4d sec\n",timew);
		pmesg("  B %4d sec\n",timeb);
		break;
	case 'c':
		/* this does not count for a move */
		crown();
		break;
	case 'd':
		pbundef();	/* force printing new stones */
		newchar();
		skipspaces();
		if((i = readstone()) || (ch == '"')){
			skipspaces();
			check('"');
			if(ch == -1) goto ask;
			sp = dsparr[i];
			while(ch != '"'){
				if(sp - dsparr[i] < 12) *sp++ = ch;
				else {
					pmesg("string too long\n");
					goto fins;
				}
				if(!ch){
					pmesg("bad string\n");
					goto fins;
				}
				newchar();
			}
			newchar();
			check(0);
		fins:
			*sp++ = 0;
			break;
		} else if(ch == 'e'){
			newchar();
			i = rnum();
			for(ct=0; ct++!=i; ) if(!emparr[ct]){
pmesg("we dont have such empty fields\n");
				goto ask;
			}
			sp = dsparr[0];
			sp2 = emparr[i];
			while(*sp++ = *sp2++);
		} else {
			i = 4*rnum();
			for(ct=0; ct++!=i; ) if(!fularr[ct]){
pmesg("this set of stones is not available\n");
				goto ask;
			}
			for(ct=0; ct<4; ct++){
				sp = dsparr[ct+1];
				sp2 = fularr[i+ct];
				while(*sp++ = *sp2++);
			}
		}
		break;
	case 'e':
		pmesg("I win\n");
		reset();
	case 'i':
		if(disp) home();
		prinfo();
		prall++;
		break;
	case 'x':
		error("the game is over");
	default:
		pmesg("unknown command\n");
		goto ask;
	}
	return;
ask:
	return;
}

readmove(color) int color; {
register int *mp1;	/* essential ! */
int *mp2,*ump,*ump0,umove[22],ct,f1,f2,i;
char cc;

listmoves:
	mpf = moves;
	move(me);
	if(possct == 0){
		pmesg("you lose\n");
		reset();
	} else if(possct == 1){
		pmesg("forced: ");
		prmove(mpf);
		/*  return(mpf);  */
	}
	dirt--;
ask:
	pmesg("?");
	rdlin();
	/* read options */
	if(newchar() == '!'){
		dirt++;
		rdcomd(ach);
		if(!mpf) goto listmoves; /* the position has changed */
		goto ask;
	}
	/* read actual moves */
	ump0 = ump = &umove[0];
	while(ch){
		if(ump-ump0 >= 22) ump--;
		if((*ump++ = readnum()) == 0) {
			pmesg("bad field\n");
			goto ask;
		}
		switch(ump - ump0){
		case 1:
			if(ch == '.') {
				newchar();
				ump--;
			}
			else if(ch)
				check(captmax ? 'x' : '-');
			break;
		case 2:
			if(!captmax) check(0);
			else if(ch) check('(');
			break;
		default:
			if(ch == ',') {
				newchar();
				break;
			}
			check(')');
			if(ch == -1) goto ask;
			check(0);
		}
		if(ch == -1) goto ask;	/* some error occurred */
	}
	if(ump == ump0) {
		if(possct == 1) return(mpf);
		else goto ask;
	}
	captct = (ump - ump0) - 2;
	if(captct > 0){
		if(captct != captmax){
			pmesg("incorrect number of captured stones\n");
			goto ask;
		}
	} else if(captct == -1) {
		/* incomplete move, see whether it is to or from */
		if(bord[umove[0]] == EMPTY){	/* to */
			umove[1] = umove[0];
			umove[0] = -1;
		} else	umove[1] = -1;		/* from */
		captct = 0;
	}
	/* now determine which move he selected from the list
	   created by 'move(c);'
	 */
	ump = 0;
	for(mp1 = mpf; mp1 < mp; mp1 =+ ct){
		ump0 = &umove[0];
		mp2 = mp1;
		f1 = *mp1++;
		f2 = *mp1++;
		ct = *mp1++;
		if(((f1 & 0177) ^ *ump0++) > 0) continue;
		if(((f2 & 0177) ^ *ump0++) > 0) continue;
		if(captct) while(ct--)
			if((*mp1++ & 0177) != *ump0++) continue;
		if(ump){
			pmesg("ambiguous move\n");
			goto ask;
		} else ump = mp2;
	}
	if(!ump) {
		pmesg("illegal move\n");
		goto ask;
	}
	prmove(ump);
	return(ump);
}

/* read w, z, W, Z, wd, bk and return index (0 by default) */
int valstone[5]{
	EMPTY,WHITE,BLACK,WHITE|DAM,BLACK|DAM
};

readstone(){
int c;
	switch(ch|040){
	case 'w':
		c = 1;
		break;
	case 'b':
	case 'z':
		c = 2;
		break;
	default:
		return(0);
	}
	if(ch & 040){
		newchar();
		if(ch == 'd' || ch == 'k') goto dam;
	} else {
	dam:
		newchar();
		c =+ 2;
	}
	return(c);
}

/*
 * Read position; each line looks like
 * w: 31-48,49,50
 * the description ends with a dot.
 */
int rdbord[66];

readpos(){
register int i,j;
int c;
	rdbord[0] = -1;	/* remember that readpos was executed */
	for(i=1; i<66; i++) rdbord[i] = EMPTY;
	do {
		rdlin();
		if(newchar() == '.') break;
		if(!(i = readstone())){
			pmesg("bad colour, ");
			goto bad;
		}
		c = valstone[i];
		check(':');
		if(ch == -1) goto bad;
	nxt:
		if(!(i = readnum())){
			pmesg("bad field, ");
			goto bad;
		}
		if(ch == '-'){
			newchar();
			if(!(j = readnum())){
				pmesg("bad 2nd field, ");
				goto bad;
			}
		} else j = i;
		while(i <= j) rdbord[i++] = c;
		if(ch){
			if(ch == '.') break;
			check(',');
			if(ch == -1){
				pmesg("bad separator, ");
				goto bad;
			}
			goto nxt;
		}
	} while(1);
	for(i=6; i<60; i++)
		if(bord[i] != EDGE) bord[i] = rdbord[i];
	mpf = 0;
	prbord();
	return;
bad:
	pmesg("old board retained\n");
	return;
}

readfile(){
int f,f0;
	/* ach points to the f of 'rf' */
	newchar();
	skipspaces();
	ach--;
	f0 = dup(0);
	close(0);
	f = open(ach,0);
	if(f < 0) pmesg("cannot open %s\n",ach);
	else if(f) error("f nonzero");
	else {
		readpos();
		close(f);
	}
	if(f = dup(f0)) error("df nonzero");
	close(f0);
}
