

) {
			hpstart();
			return;
		}
		bp->b_flags =| B_ERROR;
	}
	hptab.d_errcnt = 0;
	hptab.d_actf = bp->av_forw;
	bp->b_resid = HPADDR->hpwc;
	iodone(bp);
	hpstart();
}

hpread(dev)
{

	if(hpphys(dev))
	physio(hpstrategy, &hpbuf, dev, B_READ);
}

hpwrite(dev)
{

	if(hpphys(dev))
	physio(hpstrategy, &hpbuf, dev, B_WRITE);
}

hpphys(dev)
{
	register c;

	c = lshift(u.u_offset, -9);
	c =+ ldiv(u.u_count+511, 512);
	if(c > hp_sizes[dev.d_minor & 07].nblocks) {
		u.u_error = ENXIO;
		return(0);
	}
	return(1);
}#

/*
 *      Ramtek GX-100B driver.
 *          Incorporates both tty and raw i/o routines,  so that the
 *          device could be used in the same manner as a tty when in
 *          'cooked' alphanumeric mode, and could read directly from
 *          the  user's buffer under any other circumstances.  There
 *          are separate buffers for commands and alphanumeric data,
 *          which are then strung together on rtek for output.
 *
 *          Any noticeable, obvious, or subtle bugs should be sent to
 *          the author:
 *
 *              Joseph S. D. Yao
 *              Science Applications, Inc.
 *              1911 Fort Myer Drive, # 1200
 *              Rosslyn VA 22209
 *              (703) 527-7571
 *
 *      (doesn't yet work multi-user or keyboard-in)
 *
 */

#include "/usr/sys/param.h"
#include "/usr/sys/tty.h"
#include "/usr/sys/buf.h"
#include "/usr/sys/user.h"

struct {
	int drwc;
	int drba;
	int drst;
	int drdb;
};

#define RTADDR  0172410

/* bits in the DR command-status word */
#define GO      01
#define TRANSMIT 00
#define RECEIVE 02
#define SETUP   04
#define STATUS  06
#define ATTN_ENAB 010
#define IENABLE 0100
#define DONE    0200
#define ATTN    020000
#define NEXM    040000
#define ERROR   0100000

/* bits in the Ramtek command-status word */
#define MUXIEN  010
#define DSE     01000
#define MUXINTS DSE | 02000 | 04400
#define MUX_REG0 DSE | 000000 | 04400
#define MUX_REG1 DSE | 010000 | 04400
#define VIDEO   DSE | 0000 | MUXIEN
#define COLOURS DSE | 0200 | MUXIEN
#define MUXI    0170000
#define MUX0I   010000
#define K0      02

/* flags for the first word in a stty */
#define t_rtmod t_speeds

#define AN      00      /* alphanumeric */
#define TD      01      /* transverse data */
#define RD      02      /* raster data */
#define CD      03      /* complex data */
#define GV      04      /* graphic vector */
#define GP      05      /* graphic plot */
#define GC      06      /* graphic cartesian */
#define GE      07      /* graphic element */
#define CMODES  07
#define FP      010     /* fixed point */
#define WD      020     /* double width */
#define HT      040     /* double height */
#define FW      0100    /* full-word (sixteen bits) */
#define AD      0200    /* add (not replace) mode */
#define BK      0400    /* reverse background */
#define IX      01000   /* indexed addressing */
#define COLORTA 02000   /* color table (not LCM bit) */
#define RAWALPH 04000   /* raw RAMTEK alphanumerics (not LCM bit) */
#define DEBUG   0100000 /* debug (not LCM bit) */

/* internal flags, rtek.rt_flags */
#define CPC     01
#define CPL     02
#define ESCF    04
#define RT_BUSY 010

/* color-table and video-display instructions */
#define LTA     010000 |        /* load color table address */

#define SDC     04000 |         /* set display channel */
#define SSC     06000 |         /* set subchannel */
#define ERS     012000          /* erase the screen */
#define LCM     016000 |        /* load control mode */
#define LER     020000 |        /* load element relative */
#define LE1     022000 |        /* load element 1 */
#define LE2     024000 |        /* load element 2 */
#define LEX     026000 |        /* load element index */
#define LLR     030000 |        /* load line relative */
#define LL1     032000 |        /* load line 1 */
#define LL2     034000 |        /* load line 2 */
#define LLX     036000 |        /* load line index */
#define SCR     040000 |        /* scroll */
#define SSM     046000 |        /* set subchannel mask(s) */

/* various constants */
#define ever    (;;)
#define CHEIGHT 12
#define CWIDTH  7
#define SCREENX 640
#define SCREENY 480
#define RMARGIN 40
#define LMARGIN 40
#define NTABS   20
#define RTBSIZ  64

struct tty rtt[];                       /* tty.h */
struct buf rt_rbuf, rt_cbuf, rt_xbuf;   /* buf.h */
/* raw input, character input, and internal commands */

struct {
	int rt_cc;              /* character count(pixels) */
	int rt_lc;              /* line count(pixels) */
	int *rt_p;              /* pointer into rt_buf */
	int rt_tabs[NTABS];     /* holds the tab locations */
	int rt_buf[RTBSIZ];     /* holds the characters to be output */
	struct buf *rt_actf;    /* list of buffers to be output */
	struct buf *rt_actl;    /* end of said list */
	char rt_flags;          /* special internal flags */
	char rt_height;         /* current character height */
	char rt_width;          /* current character width */
	char rt_extra;          /* junk character */
} rtek;

/* initial color tables: spectrum and grey-shade */
int rt_cols[] {
	LTA 0,
	0,      /* black */
	017,    /* deep blue */
	0360,   /* green */
	0377,   /* light blue */
	07400,  /* red */
	07417,  /* magenta */
	07760,  /* yellow */
	07777,  /* white */
	0,      /* grey scale -- black */
	01042,  /* grey 2 */
	02104,  /* grey 4 */
	03146,  /* grey 6 */
	04210,  /* grey 8 */
	05252,  /* grey 10 */
	06314,  /* grey 12 */
	07356,  /* grey 14 (off white) */
	LTA 0,
};

/* initialising commands */
int rt_open[] {
	SDC 01,         /* select  t h e  monitor */
	SSC 07,         /* white */
	SSM 00,         /* no colors eliminated (yet) */
	LCM IX | BK,    /* alpha screen, 40 X 80, black on white */
	LEX LMARGIN,    /* 40-pixel margins left and right */
	LLX 00,         /* zero-pixel margin top and bottom */
	ERS,            /* blank the screen */
	LE1 00,         /* set to top-of-screen */
	LL1 00,
};

/* functions used from other files */
extern spl5();					/* conf/m45.s */
extern iowait(), iodone(), physio();		/* dmr/bio.c */
extern sleep(), wakeup();			/* ken/slp.c */
extern wflushtty(), ttread(), ttystty();	/* dmr/tty.c */

/*
 * rtio does the input/output for the various devices
 * after setting the destination, if necessary.
 */
rtio(where,wcount,buffer,transbits)
int where;      /* if not -1 or -2, the new Ramtek command word */
int wcount;     /* the  n e g a t i v e  of the number of words tx'd */
int *buffer;    /* the array with the words to be tx'd */
int transbits;  /* any odd bits to be set in the DR status register */
{
	static place;
	auto drstsave;
register i, *j;

if(rtt->t_rtmod & DEBUG) {
	printf("rtio(%o,%o,%o,%o)\n",where,wcount,buffer,transbits);
	j = buffer;
	if((transbits & RECEIVE) == 0 &&
	   (rtek.rt_actf->b_flags & B_PHYS) == 0)
		for(i = wcount;i++;j++) {
			printn(*j,8);
			putchar(' ');
			putchar(*j);
			putchar('\n');
		}
}
	drstsave = RTADDR->drst & 0176;

	if(where != -2) {       /* set up the destination */
		if(where == -1)
			where = (rtt->t_rtmod & COLORTA) ? COLOURS : VIDEO;
		if(place != where) {
			place = where;
			RTADDR->drst = SETUP;
			RTADDR->drwc = -1;
			RTADDR->drba = &place;
			RTADDR->drst =| GO;
		}
	}

	if(wcount) {    /* if there's words, put 'em out */
		RTADDR->drst = transbits;
		RTADDR->drwc = wcount;
		RTADDR->drba = buffer;
		RTADDR->drst =| GO;
	}
	else {
		RTADDR->drst = drstsave;
		iodone(rtek.rt_actf);
	}
}

/*
 * called when a character (or set thereof) is put on the outq(ueue),
 * or when a new buffer is ready for output, or when the interrupt
 * handler has found that the last rtio is done.
 */
rtstart()
{
	register struct buf *bp;

	if(bp = rtek.rt_actf) {
		rtek.rt_flags =| RT_BUSY;
if(rtt->t_rtmod & DEBUG) printf("rtstart on %o\n",bp);
		rtio(bp->b_dev,
		     bp->b_wcount,
		     bp->b_addr,
		     bp->b_resid | ((bp->b_xmem & 03)<<4));
	}
}

/*
 * This is the routine to put a buffer in line to be output. It is
 * called by rtcstrt, rtpush, physio, or rtcom, depending on what
 * is being written at the time.
 */
rtstrat(abp)
struct buf *abp;	/* the structured buffer containing the to-be-
			 * transmitted information */
{
	int saveps;
	register struct buf *bp;

	bp = abp;
	if(bp->b_flags & B_PHYS) mapalloc(bp);
	bp->av_forw = 0;
	saveps = PS->integ;
	spl5();
	if(rtek.rt_actf == 0)
		rtek.rt_actf = bp;
	else
		rtek.rt_actl->av_forw = bp;
	rtek.rt_actl = bp;
	if((rtek.rt_flags & RT_BUSY) == 0) rtstart();
	PS->integ = saveps;
}

/*
 * rtcom transmits any command the system may wish to send, via its own
 * buffer.
 */
rtcom(where,wcount,buffer,transbits)
int *buffer;
{
	register struct buf *bp;
	int saveps;

	bp = &rt_xbuf;
	saveps = PS->integ;
	spl5();
	while(bp->b_flags & B_BUSY) {
		bp->b_flags =| B_WANTED;
		sleep(bp,PRIBIO);
	}
	bp->b_flags = B_BUSY;
	PS->integ = saveps;
	bp->b_xmem = 0;
	bp->b_error = 0;
	bp->b_dev = where;
	if(bp->b_wcount = -wcount) {
		bp->b_addr = buffer;
		bp->b_resid = transbits | IENABLE | ATTN_ENAB;
	}
	rtstrat(bp);
	iowait(bp);
	spl5();
	if(bp->b_flags & B_WANTED) wakeup(bp);
	bp->b_flags =& ~(B_BUSY | B_WANTED);
	PS->integ = saveps;
}

/*
 * rtpush is used solely by rtoutput, to put words in rt_buf and
 * scoot them out to the Ramtek.
 */
rtpush(c)
{
	register struct buf *bp;

	*rtek.rt_p++ = c;
	if(rtek.rt_p >= &rtek.rt_buf[RTBSIZ]) {
		bp = &rt_cbuf;
		bp->b_wcount = -RTBSIZ;
		bp->b_resid = TRANSMIT | IENABLE | ATTN_ENAB;
		bp->b_flags =& ~B_DONE;
		rtstrat(bp);
		iowait(bp);
		rtek.rt_p = rtek.rt_buf;
	}
}

/*
 * rtoutput turns control characters into things the Ramtek knows about,
 * and sends plain characters on just as they are. They are all stored in
 * rt_buf, whence they are read out when rt_buf gets full or the outq gets
 * empty.
 */
rtoutput(c)     /* was (c,rt) struct tty *rt; */
{
	register a, b;
	static signal[];

	if(rtek.rt_flags & CPC) {
		rtek.rt_flags =& ~CPC;
		rtek.rt_flags =| CPL;
		rtek.rt_cc = rtek.rt_width *
		    ( ((c&017) < 10) ? ((c&017) + ((c>>4) & 7)*10) : 0);
		while(rtek.rt_cc >= (SCREENX - LMARGIN - RMARGIN))
			rtek.rt_cc =- (SCREENX - LMARGIN - RMARGIN);
		rtpush(LE1 rtek.rt_cc);
		return;
	}

	if(rtek.rt_flags & CPL) {
		rtek.rt_flags =& ~CPL;
		rtek.rt_lc = rtek.rt_height *
		    ( ((c&037) < 20) ? ((c&037) + ((c>>5) & 1)*20) : 0);
		while(rtek.rt_lc >= SCREENY) rtek.rt_lc =- SCREENY;
		rtpush(LL1 rtek.rt_lc);
		return;
	}

	if(rtek.rt_flags & ESCF) {
		rtek.rt_flags =& ~ESCF;
		if(c >= '0' && c <= '7') {
			rtpush(SSM  (~(c-'0')&07));
			return;
		}
	}

	switch(c) {
		case 010:       /* <-: backspace */
			rtek.rt_cc =- rtek.rt_width;
			if(rtek.rt_cc < 0) {
				rtek.rt_cc = (SCREENX - RMARGIN - LMARGIN)
						- rtek.rt_width;
				rtoutput(016);
			}
			rtpush(LE1 rtek.rt_cc);
			break;

		case 011:       /* tab character */
			c = (SCREENX - RMARGIN - LMARGIN) -
							rtek.rt_width;
			for(b = 0;b < NTABS;b++) {
				a = rtek.rt_tabs[b];
				if(a > rtek.rt_cc && a < c)
					c = a;
			}
			rtek.rt_cc = c;
			rtpush(LE1 c);
			break;

		case 012:       /* line feed */
			rtek.rt_lc =+ rtek.rt_height;
			if(rtek.rt_lc >= SCREENY) {
				rtek.rt_lc = (SCREENY - rtek.rt_height);
				rtpush(SCR (-(rtek.rt_height/2) & 0777));
			}
			rtpush(LL1 rtek.rt_lc);
			break;

		case 013:       /* ctrl-K: vertical tab */
			rtek.rt_lc = 0;
			rtpush(LL1 0);
			rtek.rt_cc = 0;
			rtpush(LE1 0);
			break;

		case 014:       /* form-feed homes and erases */
			rtpush(ERS);
			rtek.rt_lc = 0;
			rtpush(LL1 0);
			rtek.rt_cc = 0;
			rtpush(LE1 0);
			break;

		case 015:       /* carriage return */
			rtek.rt_cc = 0;
			rtpush(LE1 0);
			break;

		case 016:       /* up-arrow: negative line feed */
			rtek.rt_lc =- rtek.rt_height;
			if(rtek.rt_lc < 0) rtek.rt_lc = SCREENY - rtek.rt_height;
			rtpush(LL1 rtek.rt_lc);
			break;

		case 017:       /* SI, Ctrl-O: cursor address */
			rtek.rt_flags =| CPC;
			break;

		case 033:       /* escape: for colour-table switching */
			rtek.rt_flags =| ESCF;
			break;

		case 034:       /* fs homes, erases, and clears tabs */
			for(c = 0;c < NTABS;c++)
				rtek.rt_tabs[c] = 0;
			rtpush(ERS);
			rtek.rt_lc = 0;
			rtpush(LL1 0);
			rtek.rt_cc = 0;
			rtpush(LE1 0);
			break;

		case 035:       /* gs sets tab positions */
			for(c = 0;c < NTABS;c++) {
				if(rtek.rt_tabs[c] == 0) {
					rtek.rt_tabs[c] = rtek.rt_cc;
					break;
				}
				if(rtek.rt_tabs[c] == rtek.rt_cc) break;
			}
			break;

		case 036:       /* bs or rs: backspace-erase in rand and
				 * ann arbor conventions */
			rtek.rt_cc =- rtek.rt_width;
			if(rtek.rt_cc < 0) {
				rtek.rt_cc = (SCREENX - RMARGIN - LMARGIN)
						- rtek.rt_width;
				rtoutput(016);
			}
			rtpush(LE1 rtek.rt_cc);
			rtoutput(' ');
			rtpush(LE1 rtek.rt_cc);
			break;

		case 037:       /* ->: cursor right */
			rtek.rt_cc =+ rtek.rt_width;
			if(rtek.rt_cc >= (SCREENX - RMARGIN - LMARGIN)) {
				rtek.rt_cc = 0;
				rtoutput(012);
			}
			rtpush(LE1 rtek.rt_cc);
			break;

		default:        /* none of these */
			if((c & 0177) >= ' ') {
				rtpush(c & 0177);
				rtek.rt_cc =+ rtek.rt_width;
				if(rtek.rt_cc >=
				   (SCREENX - RMARGIN - LMARGIN)) {
					rtoutput(015);
					rtoutput(012);
				}
			}
	}

	if(c >= 0200 || c == 07) {
		*signal = c;
		rtcom(MUX_REG0,1,signal,TRANSMIT);
	}
}

/*
 * rtcstrt translates characters into the output buffer, then enqueues
 * the resulting buffer using rt_cbuf.
 */
rtcstrt(rt)
struct tty *rt;
{
	int saveps, c;
	register struct buf *bp;

	bp = &rt_cbuf;
	saveps = PS->integ;
	spl5();
	if(bp->b_flags & B_BUSY) {
		PS->integ = saveps;
		return;
	}
	bp->b_flags = B_BUSY;
	PS->integ = saveps;

	bp->b_xmem = 0;
	bp->b_addr = rtek.rt_buf;
	bp->b_error = 0;
	bp->b_dev = -1;

	/*
	 * The following is in an infinite loop in case someone leaves
	 * some characters on the queue and then leaves, seeing the
	 * buffer already in use. This will happen when the keyboard
	 * is struck during the final transmit, or someone else writes
	 * to the device during that time.
	 */
	for ever {
		rtek.rt_p = rtek.rt_buf;
		while((c = getc(&rt->t_outq)) >= 0) rtoutput(c & 0377);
		if(rtek.rt_p != rtek.rt_buf) {
			bp->b_resid = TRANSMIT | IENABLE | ATTN_ENAB;
			bp->b_wcount = rtek.rt_buf - rtek.rt_p;
			bp->b_flags =& ~B_DONE;
			rtstrat(bp);
			iowait(bp);
		}
		spl5();
		if(rt->t_outq.c_cc == 0) break;
		PS->integ = saveps;
	}
	bp->b_flags =& ~(B_BUSY | B_WANTED);
	PS->integ = saveps;
}

/*
 * called every time someone wants to talk to the Ramtek.
 * the first time, all the needed info is set up; new comers
 * are at the mercy of the old users.
 */
rtopen(dev,flag)
{
	static comnd[];
	register i;

	if (rtt->t_state & ISOPEN) return;

	rtt->t_state = ISOPEN | CARR_ON | SSTART;
	rtt->t_addr = rtcstrt;
	rtt->t_flags = XTABS | ECHO | CRMOD;
	rtt->t_erase = CERASE;
	rtt->t_kill = CKILL;
	rtt->t_rtmod = IX | BK;

	rtek.rt_flags = 0;
	rtek.rt_cc = rtek.rt_lc = 0;
	rtek.rt_height = CHEIGHT;
	rtek.rt_width = CWIDTH;
	for (i = 0;i < NTABS;i++) rtek.rt_tabs[i] = 0;

	rtcom(-2,1,comnd,STATUS);
	*comnd = 0;
	rtcom(MUX_REG1,1,comnd,TRANSMIT);
	rtcom(COLOURS, (sizeof rt_cols)/2, rt_cols, TRANSMIT);
	rtcom(VIDEO, (sizeof rt_open)/2, rt_open, TRANSMIT);
}

/*
 * When all users are done with the Ramtek, we flush all characters
 * (the buffers are assumed to be gone, by now) and drop the open
 * signals.
 */
rtclose(dev)
{
	RTADDR->drst = 0;
	wflushtty(rtt);
	rtt->t_state = 0;
}

/*
 * whenever anyone wants to read something, let them read the keyboard.
 */
rtread(dev)
{
	ttread(rtt);
}

/*
 * if in alphanumeric mode and talking to the video display, use the
 * tty write routine, else do raw i/o out of the user's buffer.
 */
rtwrite(dev)
{
	int c;
	register struct tty *tp;

	if(rtt->t_rtmod & (COLORTA | CMODES | RAWALPH)) {
		rt_rbuf.b_resid = TRANSMIT | IENABLE | ATTN_ENAB;
		physio(rtstrat, &rt_rbuf, -1, B_WRITE);
	}
	else {
		tp = rtt;
		while((c = cpass()) >= 0) {
			spl5();
			if(tp->t_outq.c_cc > TTHIWAT)
				rtcstrt(tp);
			while(tp->t_outq.c_cc > TTHIWAT) {
				tp->t_state =| ASLEEP;
				sleep(&tp->t_outq, TTOPRI);
			}
			spl0();
			ttyoutput(c,tp);
		}
		rtcstrt(tp);
	}
}

/*
 * the modifications to the standard sgtty schtick are that the
 * Ramtek modes and the write-addressee are stored in, respec-
 * tively, the last 10 bits of t_rtmod (t_speeds) and the bit
 * before that, since the Ramtek operates at bus speed.
 */
rtsgtty(dev,v)
{
	static comnd[5];
	auto ccount;

	if(ttystty(rtt,v)) return;

	if(rtt->t_rtmod & COLORTA) {
		*comnd = LTA (rtt->t_rtmod & 0377);
		rtcom(COLOURS,1,comnd,TRANSMIT);
		return;
	}

	if(rtt->t_rtmod & (CMODES | RAWALPH))
		ccount = 1;
	else {
		rtek.rt_lc = 0;
		rtek.rt_cc = 0;
		rtt->t_rtmod =| IX;
		comnd[1] = LEX LMARGIN;
		comnd[2] = LLX 0;
		comnd[3] = LE1 0;
		comnd[4] = LL1 0;
		ccount = 3;
	}
	comnd[0] = LCM (rtt->t_rtmod & 01777);
	rtcom(VIDEO,ccount,comnd,TRANSMIT);

	rtek.rt_height = ((rtt->t_rtmod & HT) ? 2*CHEIGHT : CHEIGHT);
	rtek.rt_width = ((rtt->t_rtmod & WD) ? 2*CWIDTH : CWIDTH);
}

/*
 * rtint is the interrupt-time routine. If ATTN is flagged, it's the
 * device calling; either the mux or buffer-empty. (programmed interrupt
 * is not now implemented: maybe later, if I can figure how to signal
 * for it.)
 * Otherwise, it's one of three error conditions. Buffer address overflow
 * can usually be handled fairly easily. Non-existent memory and hardware
 * errors cause an error return.
 */
rtint()
{
	static comnd;
	auto stsav, basav, wcsav;
	register struct buf *bp;

	bp = rtek.rt_actf;
	if(RTADDR->drst & ERROR) {
		if(RTADDR->drst & ATTN) {
			stsav = RTADDR->drst & 0176;
			RTADDR->drst =& ~IENABLE;
			basav = RTADDR->drba;
			wcsav = RTADDR->drwc;
			rtio(0,-1,&comnd,STATUS);
			if(comnd & MUX0I) {
				rtio(MUXINTS,-1,&comnd,RECEIVE);
				if(comnd & K0) {
					rtio(MUX_REG1,-1,&comnd,RECEIVE);
					ttyinput(comnd & 0377,rtt);
				}
			}
			rtio(-1,wcsav,basav,stsav);
			if(wcsav == 0) RTADDR->drst = stsav;
			return;
		}
		else {
			if(RTADDR->drst & NEXM) {
				RTADDR->drst =& ~NEXM;
				if(bp) {
					bp->b_error = ENXIO;
					bp->b_flags =| B_ERROR;
				}
			}
			else {
				if(RTADDR->drwc != 0) {
					if(RTADDR->drba == 0) {
			/*>*/   RTADDR->drba = 0;
			/*>*/   if((RTADDR->drst & 060) != 060) {
			/*>*/           RTADDR->drst =+ 020;
			/*>*/           RTADDR->drst =| GO;
			/*>*/           return;
			/*>*/   }
			/*>*/   else {
			/*>*/           if(bp) {
			/*>*/                   bp->b_error = ENXIO;
			/*>*/                   bp->b_flags =| B_ERROR;
			/*>*/           }
			/*>*/   }
					}
					else {
			/*>*/   if(RTADDR->drwc != bp->b_wcount) {
			/*>*/           printf("rt phantom: %o @ %o\n",
			/*>*/                   -RTADDR->drwc,RTADDR->drba);
			/*>*/           RTADDR->drst =| GO;
			/*>*/           return;
			/*>*/   }
			/*>*/   else {
			/*>*/           if(bp) {
			/*>*/                   bp->b_error = ENXIO;
			/*>*/                   bp->b_flags =| B_ERROR;
			/*>*/           }
			/*>*/   }
					}
				}
			}
		}
	}
	else
		if(RTADDR->drwc != 0) {
			printf("phantom rt: %o @ %o\n",
				-RTADDR->drwc, RTADDR->drba);
			RTADDR->drst =| GO;
			return;
		}

	/*
	 * At this point, either an unrecoverable er