#include "/h/ttylimits.h"

char *linep;

getlimits(ttyname)
{
	register int chn;
	register char *tp;
	static struct tty_limits tty;
	char buf[128];

	if((chn = open("/etc/ttylimits", 0)) < 0) {
		printf("Can't open /etc/ttylimits\n");
		return(0);
	}
loop:	readline(chn, buf, 128);
	linep = &buf;
	tp = ttyname;
	if(*linep != '*')
		while(*linep != ':')
			if(*linep++ != *tp++) goto loop;
	tty.l_noset = getoct();
	tty.l_noclr = getoct();
	tty.l_ispds = getoct();
	tty.l_n1    = getoct();
	tty.l_n2    = getoct();
	tty.l_n3    = getoct();
	close(chn);
	return(&tty);
}

getoct()
{
	register int num;

	num = 0;
	while(*linep < '0' || *linep > '7') linep++;
	do
		num = (num<<3) + *linep++ - '0';
	while(*linep >= '0' && *linep <= '7');
	return(num);
}
