#
/*
 *	Copyright 1973 Bell Telephone Laboratories Inc
 */

/*
 *	DM-BB driver
 *
 *			BSB 10/21/76 for Harvard.
 */
#include "../param.h"
#include "../tty.h"
#include "../conf.h"

/*
 * External page addresses for each DM11BB on the system.
 */
char *dmaddr[(NDHDM+15)>>4] { 0170500 };

/*
 * TTY structs for the DH lines
 */
struct	tty dh11[];

/*
 * Hardware bits
 */
#define	DONE	0200
#define	SCENABL	040
#define	CLSCAN	01000
#define LINENBL	01
#define	TURNON	01	/* -RQ send, -CD lead, line enable */
#define	TURNOFF	1	/* line enable only */
#define	CARRIER	0100
#define DTREADY	02
#define RINGCSR	0100000
#define RINGLINE 0200

/*
 * DM External page layout
 */
struct dmregs {
	int	dmcsr;
	int	dmlstat;
};

/*
 * Turn on (open) the line associated with the (DH) device dev.
 */
dmopen(dev)
{
	register struct tty *tp;
	register int d, *dmp;

	tp = &dh11[d = dev.d_minor];
	if(d < NDHDM+NDMHW) {
		dmp = dmaddr[d>>4];
		dmp->dmcsr = d & 017;
		dmp->dmlstat =| TURNON;
		if (dmp->dmlstat&CARRIER || d >= NDHDM) {
			dmp->dmlstat =| DTREADY;  /* for benefit of h.w. dm */
			tp->t_state =| CARR_ON;
		}
		dmp->dmcsr = IENABLE|SCENABL;
		spl5();
		while ((tp->t_state&CARR_ON)==0)
			sleep(&tp->t_rawq, TTIPRI);
		spl0();
	} else
		tp->t_state =| CARR_ON;
}

/*
 * If a DH line has the HUPCL mode,
 * turn off carrier when it is closed.
 */
dmclose(dev)
{
	register struct tty *tp;
	register int d, *dmp;

	tp = &dh11[d = dev.d_minor];
	if (tp->t_state&HUPCL && d < NDHDM) {
		dmp = dmaddr[d/16];
		dmp->dmcsr = d & 017;
		dmp->dmlstat = TURNOFF;
		dmp->dmcsr = IENABLE|SCENABL;
	}
}

/*
 * DM11 interrupt.
 * Mainly, deal with carrier transitions.
 */
dmint(mux)
{
	int dmretry();
	register struct tty *tp;
	register int *dmp;

	dmp = dmaddr[mux];
	if(dmp->dmcsr&DONE) {
		tp = &dh11[(dmp->dmcsr&017) + (mux * 16)];
		if(tp < &dh11[NDHDM] && tp->t_state&(WOPEN|ISOPEN)) {
			if((dmp->dmlstat&CARRIER) == 0) {
				if((tp->t_state&WOPEN) == 0) {
					signal(tp->t_grp, SIGHUP);
					dmp->dmlstat = 0;
					flushtty(tp);
					wakeup(&tp->t_rawq);
				}
				if (dmp->dmcsr&RINGCSR
				    || dmp->dmlstat&RINGLINE)
					dmp->dmlstat =| DTREADY;
				else	dmp->dmlstat =& ~DTREADY;
				/*##stt 1/21/77 force next dhopen to do dmopen*/
				tp->t_state =& ~(CARR_ON|ISOPEN);
			} else if(dmp->dmlstat&DTREADY) {
				dmp->dmlstat =& ~LINENBL;
				timeout(dmretry, tp, 60);
			}
		}
		dmp->dmcsr = IENABLE|SCENABL;
	}
}

/*
 * One second delay handler for Carrier Detect for el-cheapo
 * acoustic couplers.
 */
dmretry(atp)
{
	register struct tty *tp;
	register int *dmp;

	tp = atp;
	dmp = dmaddr[(tp - dh11)>>4];
	dmp->dmcsr = (tp - dh11)&017;
	dmp->dmlstat =| LINENBL;
	if(dmp->dmlstat&CARRIER) {
		tp->t_state =| CARR_ON;
		wakeup(&tp->t_rawq);
	}
	dmp->dmcsr = SCENABL|IENABLE;
}
