#
/*
 *	Copyright 1973 Bell Telephone Laboratories Inc
 */

/*
 * general TTY subroutines
 */
#include "../param.h"
#include "../systm.h"
#include "../user.h"
#include "../tty.h"
#include "../proc.h"
#include "../inode.h"
#include "../file.h"
#include "../reg.h"
#include "../conf.h"


#include "../lnk.h"
/*	maptab has been eliminated in ttyi... see code
 *	at beginning of ttyinput().
 */


struct cblock {
	struct cblock *c_next;
	char info[6];
};

struct cblock cfree[NCLIST];
struct cblock *cfreelist;

struct {
	int ttrcsr;
	int ttrbuf;
	int tttcsr;
	int tttbuf;
};

gtty()
{
	int v[3];
	register *up, *vp;

	vp = v;
	sgtty(vp);
	if (u.u_error)
		return;
	up = u.u_arg[0];
	suword(up, *vp++);
	suword(++up, *vp++);
	suword(++up, *vp++);
}

stty()
{
	register int *up;

	up = u.u_arg[0];
	u.u_arg[0] = fuword(up);
	u.u_arg[1] = fuword(++up);
	u.u_arg[2] = fuword(++up);
	sgtty(0);
}

sgtty(v)
{
	register struct file *fp;
	register struct inode *ip;

	if ((fp = getf(u.u_ar0[R0])) == NULL)
		return;
	ip = fp->f_inode;
	if ((ip->i_mode&IFMT) != IFCHR) {
		u.u_error = ENOTTY;
		return;
	}
	(*cdevsw[ip->i_addr[0].d_major].d_sgtty)(ip->i_addr[0], v);
}

wflushtty(atp)
struct tty *atp;
{
	register struct tty *tp;

	tp = atp;
	spl5();
	while (tp->t_outq.c_cc) {
		tp->t_state =| ASLEEP;
		sleep(&tp->t_outq, TTOPRI);
	}
	flushtty(tp);
	spl0();
}

cinit()
{
	register int ccp;
	register struct cblock *cp;
	register struct cdevsw *cdp;

	ccp = cfree;
	for (cp=(ccp+07)&~07; cp <= &cfree[NCLIST-1]; cp++) {
		cp->c_next = cfreelist;
		cfreelist = cp;
	}
	ccp = 0;
	for(cdp = cdevsw; cdp->d_open; cdp++)
		ccp++;
	nchrdev = ccp;
}
	/****** flushtty must follow cinit ******/

/*
 * flush all TTY queues
 */
flushtty(atp)
struct tty *atp;
{
	register struct tty *tp;
	register int sps;

	tp = atp;
	while (getc(&tp->t_outq) >= 0);
	wakeup(&tp->t_rawq);
	wakeup(&tp->t_outq);
	sps = PS->integ;
	spl5();
	ttstop(tp);
	tp->t_char = 0;
	/* ##stt/bsb 4/13/77 clear residue in DH DMA buffer */
	tp->t_state =& ~SUSPEND;
	while (getc(&tp->t_rawq) >= 0);
	tp->t_beglin = 0;
	tp->t_lincnt = 0;
	tp->t_delct = 0;
	PS->integ = sps;
}

/*
 * transfer raw list to canonical list,
 * doing code conversion.
 *
 *	***** removed feb '76 bsb *****
 */

/*
 * put character on TTY output queue, adding delays,
 * expanding tabs, and handling the CR/NL bit.
 */
ttyoutput(ac, tp)
struct tty *tp;
{
	register int c;
	register struct tty *rtp;
	register char *colp;
	int ctype, del;

	rtp = tp;
	c = ac&0177;
	if (c==004 && (rtp->t_flags&RAW)==0)
		return;
	if (c=='\t' && rtp->t_flags&XTABS) {
		/* ##stt 11/30/76 avoid clim=6 bug */
		c = -(rtp->t_col|0177770);
		do
			ttyoutput(' ', rtp);
		while (--c);
		return;
	}
	if (rtp->t_flags&LCASE) {
		colp = "{(})|!~^`'";
		do {
			if(c == *colp++){
				c= *colp;
				ttyoutput('\\',rtp);
				break;
			} else
				colp++;
		} while (*colp);
		if ('a'<=c && c<='z')
			c =+ 'A' - 'a';
	}
	if (c=='\n' && rtp->t_flags&CRMOD)
		ttyoutput('\r', rtp);
	colp = &rtp->t_col;
	ctype = partab[c] & 077;
again:	del = 0;
	switch (ctype) {

	/* ordinary */
	case 0:
		(*colp)++;

	/* non-printing */
	case 1:
		break;

	/* backspace */
	case 2:
		if (*colp)
			(*colp)--;
		break;

	/* newline */
	case 3:
		if (*colp)
			del = max((*colp>>4) + 3, 6);
		*colp = 0;
		break;

	/* tab */
	case 4:
		if ((rtp->t_flags&NTDELAY)==0)
			/*##stt 11/30/76 delay was  8-desired value */
			/* ##stt 1/22/77 divide by 3 instead of 2 */
			del = -(*colp|0177770)/3;
		*colp =| 07;
		(*colp)++;
		break;

	/* vertical motion */
	case 5:
		del = 0177;
		break;

	/* carriage return */
	case 6:
		del = 6;
		*colp = 0;
	}
	if(rtp->t_clim && (*colp&0377) > (rtp->t_clim&0377)) {
		ttyoutput('\n', rtp);
		goto again;
	}
	if (putc(c, &rtp->t_outq))
		return;
	if (del && (rtp->t_flags&NODELAY)==0)
		putc(del|0200, &rtp->t_outq);
}

ttrstrt(atp)
{
	register struct tty *tp;

	tp = atp;
	tp->t_state =& ~TIMEOUT;
	ttstart(tp);
}

ttstart(atp)
struct tty *atp;
{
	register int *addr, c;
	register struct tty *tp;
	struct { int (*func)(); };

	tp = atp;
	addr = tp->t_addr;
	if (tp->t_state&SSTART) {
		(*addr.func)(tp);
		return;
	}
	if ((addr->tttcsr&DONE)==0 || tp->t_state&(TIMEOUT|HALTOP))
		return;
	if ((c=getc(&tp->t_outq)) >= 0) {
		if (c<=0177)
			addr->tttbuf = c | (partab[c]&0200);
		else {
			timeout(ttrstrt, tp, c&0177);
			tp->t_state =| TIMEOUT;
		}
	}
}

ttread(atp)
struct tty *atp;
{
	register struct tty *tp;
	register int c;

	tp = atp;
	tp->t_state =& ~OPSUPRS;
	spl5();
	while(tp->t_delct == 0) {
		if((tp->t_state&CARR_ON) == 0)
			return;
		sleep(&tp->t_delct, TTIPRI);
	}
	spl0();
	while((c = getc(&tp->t_rawq)) != 0377)
		if(passc(c) < 0) {
			if(*tp->t_rawq.c_cf != -1)
				return;
			getc(&tp->t_rawq);
			break;
		}
	tp->t_delct--;
}

ttwrite(atp)
struct tty *atp;
{
	register struct tty *tp;
	register int c, i;

	tp = atp;
	while ((c=cpass())>=0) {
		if((tp->t_state&OPSUPRS)==0){
			ttyoutput(c, tp);
			spl5();
			while (tp->t_outq.c_cc > TTHIWAT) {
				tp->t_state =| ASLEEP;
				ttstart(tp);
				sleep(&tp->t_outq, TTOPRI);
			}
			spl0();
		}
	}
	ttstart(tp);
}

reducq(qp)
struct clist *qp;
{
	extern cblkuse;
	register struct clist *rqp;
	register char *rcb, *rcb1;
	int sps;

	rqp = qp;
	if(rqp->c_cc==0)
		return(-1);
	sps = PS->integ;
	spl6();
	if(--rqp->c_cc==0){
		rcb = rqp->c_cf&~07;
		rcb->c_next = cfreelist;
		cfreelist = rcb;
		cblkuse--;
		rqp->c_cf = 0;
		rqp->c_cl = 0;
	} else {
		if(((rcb1 = --rqp->c_cl)&07)==2){
			rcb1 =& ~07;
			for(rcb = rqp->c_cf& ~07; rcb->c_next!=rcb1; rcb = rcb->c_next);
			rcb1->c_next = cfreelist;
			cfreelist = rcb1;
			cblkuse--;
			rqp->c_cl = rcb+010;
			rcb->c_next = 0;
		}
	}
	PS->integ = sps;
	return((rcb = rqp->c_cl) ? (*(rcb-1))&0377 : -1);
}

/*
 * Common code for gtty and stty functions on typewriters.
 * If v is non-zero then gtty is being done and infror mation is
 * passed back therein;
 * if it is zero stty is being done and the input information is in the
 * u_arg array.
 */

ttystty(atp, av)
int *av;
{
	register *tp, *v;

	tp = atp;
	if(v = av) {
		*v++ = tp->t_speeds;
		*v++ = (tp->t_clim<<8)|tp->t_vlim;
		*v++ = tp->t_flags;
		return(1);
	}
	spl5();	/*##stt 11/29/76 try to fix ppl graphics hang */
	while(tp->t_outq.c_cc) {
		tp->t_state =| ASLEEP;
		sleep(&tp->t_outq, TTOPRI);
	}
	spl0();	/*##stt 11/29/76 */
	tp->t_speeds = u.u_arg[0];
	tp->t_clim = u.u_arg[1].hibyte;
	tp->t_vlim = u.u_arg[1].lobyte;
	if(u.u_uid != 0)
		tp->t_flags = (tp->t_flags&ILEGLMSK) |
				(u.u_arg[2]& ~ILEGLMSK);
	else
		tp->t_flags = u.u_arg[2];
	return(0);
}

ttstop(atp)
{
	register struct tty *tp;
	extern struct tty dh11[];

	tp = atp;
	/* add check for lnklin ##byer 2/77 */
	if(tp < &dh11[0] || tp >= &dh11[NDH11] ||
	    tp == &dh11[LNKLIN] || (tp->t_state&BUSY) == 0)
		return;
	dhstop(tp);
}
